/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.androidx.compose.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import top.fifthlight.touchcontroller.relocated.androidx.collection.MutableIntObjectMap;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.Anchor;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.ComposerKt;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.GroupIterator;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.GroupSourceInformation;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.PreconditionsKt;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotReader;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotTableKt;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotWriter;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SynchronizedObject;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.markers.KMappedMarker;

public final class SlotTable
implements Iterable,
KMappedMarker {
    public int[] groups = new int[0];
    public int groupsSize;
    public Object[] slots = new Object[0];
    public int slotsSize;
    public int readers;
    public final SynchronizedObject lock = new SynchronizedObject();
    public boolean writer;
    public int version;
    public ArrayList anchors = new ArrayList();
    public HashMap sourceInformationMap;
    public MutableIntObjectMap calledByMap;

    public final Anchor tryAnchor(int n) {
        int n2;
        if (!(this.writer ^ true)) {
            ComposerKt.composeImmediateRuntimeError("use active SlotWriter to crate an anchor for location instead");
        }
        return n >= 0 && n < (n2 = this.groupsSize) ? SlotTableKt.access$find(this.anchors, n, n2) : null;
    }

    public final int[] getGroups() {
        return this.groups;
    }

    public final int getGroupsSize() {
        return this.groupsSize;
    }

    public final Object[] getSlots() {
        return this.slots;
    }

    public final int getSlotsSize() {
        return this.slotsSize;
    }

    public final boolean getWriter$runtime() {
        return this.writer;
    }

    public final int getVersion$runtime() {
        return this.version;
    }

    public final ArrayList getAnchors$runtime() {
        return this.anchors;
    }

    public final HashMap getSourceInformationMap$runtime() {
        return this.sourceInformationMap;
    }

    public final MutableIntObjectMap getCalledByMap$runtime() {
        return this.calledByMap;
    }

    public boolean isEmpty() {
        return this.groupsSize == 0;
    }

    public final SlotReader openReader() {
        if (!this.writer) {
            ++this.readers;
            return new SlotReader(this);
        }
        throw new IllegalStateException("Cannot read while a writer is pending".toString());
    }

    public final SlotWriter openWriter() {
        if (!(this.writer ^ true)) {
            ComposerKt.composeImmediateRuntimeError("Cannot start a writer when another writer is pending");
        }
        if (!(this.readers <= 0)) {
            ComposerKt.composeImmediateRuntimeError("Cannot start a writer when a reader is pending");
        }
        this.writer = true;
        ++this.version;
        return new SlotWriter(this);
    }

    public final Anchor anchor(int n) {
        Anchor anchor;
        ArrayList arrayList;
        int n2;
        if (!(this.writer ^ true)) {
            ComposerKt.composeImmediateRuntimeError("use active SlotWriter to create an anchor location instead");
        }
        if (!(n >= 0 && n < this.groupsSize)) {
            PreconditionsKt.throwIllegalArgumentException("Parameter index is out of range");
        }
        if ((n2 = SlotTableKt.access$search(arrayList = this.anchors, n, this.groupsSize)) < 0) {
            Anchor anchor2;
            anchor = anchor2;
            anchor2 = new Anchor(n);
            arrayList.add(-(n2 + 1), anchor);
        } else {
            Object e = arrayList.get(n2);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            anchor = (Anchor)e;
        }
        return anchor;
    }

    public final int anchorIndex(Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        if (!(this.writer ^ true)) {
            ComposerKt.composeImmediateRuntimeError("Use active SlotWriter to determine anchor location instead");
        }
        if (!anchor.getValid()) {
            PreconditionsKt.throwIllegalArgumentException("Anchor refers to a group that was removed");
        }
        return anchor.getLocation$runtime();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean ownsAnchor(Anchor anchor) {
        Anchor anchor2 = anchor;
        Intrinsics.checkNotNullParameter(anchor2, "anchor");
        if (!anchor2.getValid()) return false;
        int n = anchor.getLocation$runtime();
        if ((n = SlotTableKt.access$search(this.anchors, n, this.groupsSize)) < 0) return false;
        if (!Intrinsics.areEqual(this.anchors.get(n), anchor)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean groupContainsAnchor(int n, Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        if (!(this.writer ^ true)) {
            ComposerKt.composeImmediateRuntimeError("Writer is active");
        }
        if (!(n >= 0 && n < this.groupsSize)) {
            ComposerKt.composeImmediateRuntimeError("Invalid group index");
        }
        if (!this.ownsAnchor(anchor)) return false;
        int n2 = n + SlotTableKt.access$groupSize(this.groups, n);
        if (n > (n = anchor.getLocation$runtime())) return false;
        if (n >= n2) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close$runtime(SlotReader object, HashMap hashMap) {
        SlotReader slotReader = object;
        Intrinsics.checkNotNullParameter(slotReader, "reader");
        if (!(slotReader.getTable$runtime() == this && this.readers > 0)) {
            ComposerKt.composeImmediateRuntimeError("Unexpected reader close()");
        }
        this.readers += -1;
        if (hashMap == null) return;
        SlotTable slotTable = this;
        object = slotTable.lock;
        synchronized (object) {
            Throwable throwable2;
            block6: {
                block7: {
                    block5: {
                        HashMap hashMap2;
                        try {
                            hashMap2 = slotTable.sourceInformationMap;
                            if (hashMap2 == null) break block5;
                        }
                        catch (Throwable throwable2) {
                            break block6;
                        }
                        hashMap2.putAll(hashMap);
                        break block7;
                    }
                    this.sourceInformationMap = hashMap;
                }
                return;
            }
            throw throwable2;
        }
    }

    public final void close$runtime(SlotWriter slotWriter, int[] nArray, int n, Object[] objectArray, int n2, ArrayList arrayList, HashMap hashMap, MutableIntObjectMap mutableIntObjectMap) {
        Intrinsics.checkNotNullParameter(slotWriter, "writer");
        Intrinsics.checkNotNullParameter(nArray, "groups");
        Intrinsics.checkNotNullParameter(objectArray, "slots");
        Intrinsics.checkNotNullParameter(arrayList, "anchors");
        if (!(slotWriter.getTable$runtime() == this && this.writer)) {
            PreconditionsKt.throwIllegalArgumentException("Unexpected writer close()");
        }
        this.writer = false;
        this.setTo$runtime(nArray, n, objectArray, n2, arrayList, hashMap, mutableIntObjectMap);
    }

    public final void setTo$runtime(int[] nArray, int n, Object[] objectArray, int n2, ArrayList arrayList, HashMap hashMap, MutableIntObjectMap mutableIntObjectMap) {
        SlotTable slotTable = this;
        Intrinsics.checkNotNullParameter(nArray, "groups");
        Intrinsics.checkNotNullParameter(objectArray, "slots");
        Intrinsics.checkNotNullParameter(arrayList, "anchors");
        slotTable.groups = nArray;
        slotTable.groupsSize = n;
        slotTable.slots = objectArray;
        slotTable.slotsSize = n2;
        slotTable.anchors = arrayList;
        slotTable.sourceInformationMap = hashMap;
        slotTable.calledByMap = mutableIntObjectMap;
    }

    public final boolean containsMark() {
        return this.groupsSize > 0 && SlotTableKt.access$containsMark(this.groups, 0);
    }

    public final GroupSourceInformation sourceInformationOf(int n) {
        HashMap hashMap = ((SlotTable)object).sourceInformationMap;
        Object object = hashMap != null && (object = ((SlotTable)object).tryAnchor(n)) != null ? (GroupSourceInformation)hashMap.get(object) : null;
        return object;
    }

    public final void collectCalledByInformation() {
        MutableIntObjectMap mutableIntObjectMap;
        SlotTable slotTable = mutableIntObjectMap2;
        MutableIntObjectMap mutableIntObjectMap2 = mutableIntObjectMap;
        mutableIntObjectMap = new MutableIntObjectMap(0, 1, null);
        slotTable.calledByMap = mutableIntObjectMap2;
    }

    public final void collectSourceInformation() {
        HashMap hashMap;
        SlotTable slotTable = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        slotTable.sourceInformationMap = hashMap2;
    }

    public Iterator iterator() {
        int n = this.groupsSize;
        return new GroupIterator(this, 0, n);
    }
}

