/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal;

import java.util.Arrays;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal.PrimitiveArrayBuilder;

public final class ByteArrayBuilder
extends PrimitiveArrayBuilder {
    public byte[] buffer;
    public int position;

    public ByteArrayBuilder(byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "bufferWithData");
        this.buffer = byArray;
        this.position = byArray.length;
        this.ensureCapacity$kotlinx_serialization_core(10);
    }

    @Override
    public int getPosition$kotlinx_serialization_core() {
        return this.position;
    }

    @Override
    public void ensureCapacity$kotlinx_serialization_core(int n) {
        byte[] byArray = this.buffer;
        if (this.buffer.length < n) {
            byte[] byArray2 = Arrays.copyOf(byArray, RangesKt___RangesKt.coerceAtLeast(n, byArray.length * 2));
            Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
            this.buffer = byArray2;
        }
    }

    public final void append$kotlinx_serialization_core(byte by) {
        ByteArrayBuilder byteArrayBuilder = this;
        PrimitiveArrayBuilder.ensureCapacity$kotlinx_serialization_core$default(byteArrayBuilder, 0, 1, null);
        int n = this.getPosition$kotlinx_serialization_core();
        this.position = n + 1;
        byteArrayBuilder.buffer[n] = by;
    }

    public byte[] build$kotlinx_serialization_core() {
        byte[] byArray = Arrays.copyOf(this.buffer, this.getPosition$kotlinx_serialization_core());
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
        return byArray;
    }
}

