/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal;

import java.util.Arrays;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.StructureKind;

public final class JsonPath {
    public Object[] currentObjectPath = new Object[8];
    public int[] indicies;
    public int currentDepth;

    public JsonPath() {
        int[] nArray = new int[8];
        for (int i = 0; i < 8; ++i) {
            nArray[i] = -1;
        }
        JsonPath jsonPath = this;
        jsonPath.indicies = nArray;
        jsonPath.currentDepth = -1;
    }

    public final void pushDescriptor(SerialDescriptor serialDescriptor) {
        int n;
        Intrinsics.checkNotNullParameter(serialDescriptor, "sd");
        this.currentDepth = n = this.currentDepth + 1;
        if (n == this.currentObjectPath.length) {
            this.resize();
        }
        this.currentObjectPath[n] = serialDescriptor;
    }

    public final void updateDescriptorIndex(int n) {
        this.indicies[this.currentDepth] = n;
    }

    public final void updateCurrentMapKey(Object object) {
        int n = this.currentDepth;
        if (this.indicies[n] != -2) {
            this.currentDepth = ++n;
            if (n == this.currentObjectPath.length) {
                this.resize();
            }
        }
        JsonPath jsonPath = this;
        int n2 = this.currentDepth;
        jsonPath.currentObjectPath[n2] = object;
        jsonPath.indicies[n2] = -2;
    }

    public final void resetCurrentMapKey() {
        int n = this.currentDepth;
        if (this.indicies[n] == -2) {
            this.currentObjectPath[n] = Tombstone.INSTANCE;
        }
    }

    public final void popDescriptor() {
        JsonPath jsonPath = this;
        int n = jsonPath.currentDepth;
        int[] nArray = jsonPath.indicies;
        if (jsonPath.indicies[n] == -2) {
            nArray[n] = -1;
            this.currentDepth = n + -1;
        }
        if ((n = this.currentDepth) != -1) {
            this.currentDepth = n + -1;
        }
    }

    public final String getPath() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("$");
        int n = this.currentDepth + 1;
        for (int i = 0; i < n; ++i) {
            Object object = this.currentObjectPath[i];
            if (object instanceof SerialDescriptor) {
                if (Intrinsics.areEqual((object = (SerialDescriptor)object).getKind(), StructureKind.LIST.INSTANCE)) {
                    if (this.indicies[i] == -1) continue;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    stringBuilder2.append("[");
                    stringBuilder3.append(this.indicies[i]);
                    stringBuilder3.append("]");
                    continue;
                }
                int n2 = this.indicies[i];
                if (n2 < 0) continue;
                stringBuilder2.append(".");
                stringBuilder2.append(object.getElementName(n2));
                continue;
            }
            if (object == Tombstone.INSTANCE) continue;
            StringBuilder stringBuilder4 = stringBuilder2;
            stringBuilder4.append("[");
            stringBuilder4.append("'");
            stringBuilder4.append(object);
            stringBuilder4.append("'");
            stringBuilder4.append("]");
        }
        return stringBuilder2.toString();
    }

    public String toString() {
        return this.getPath();
    }

    public final void resize() {
        JsonPath jsonPath = this;
        int n = jsonPath.currentDepth * 2;
        Object[] objectArray = Arrays.copyOf(jsonPath.currentObjectPath, n);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        jsonPath.currentObjectPath = objectArray;
        int[] nArray = Arrays.copyOf(jsonPath.indicies, n);
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
        jsonPath.indicies = nArray;
    }

    public static final class Tombstone {
        public static final Tombstone INSTANCE = new Tombstone();
    }
}

