/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.event;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.touchcontroller.common.config.ControllerLayout;
import top.fifthlight.touchcontroller.common.config.GlobalConfig;
import top.fifthlight.touchcontroller.common.config.GlobalConfigHolder;
import top.fifthlight.touchcontroller.common.config.LayerConditionKey;
import top.fifthlight.touchcontroller.common.config.preset.LayoutPreset;
import top.fifthlight.touchcontroller.common.config.preset.PresetControlInfo;
import top.fifthlight.touchcontroller.common.event.RenderEvents$special$;
import top.fifthlight.touchcontroller.common.event.WindowEvents;
import top.fifthlight.touchcontroller.common.gal.CameraPerspective;
import top.fifthlight.touchcontroller.common.gal.CrosshairTarget;
import top.fifthlight.touchcontroller.common.gal.DefaultKeyBindingType;
import top.fifthlight.touchcontroller.common.gal.GameState;
import top.fifthlight.touchcontroller.common.gal.GameStateProvider;
import top.fifthlight.touchcontroller.common.gal.KeyBindingHandler;
import top.fifthlight.touchcontroller.common.gal.PlayerHandle;
import top.fifthlight.touchcontroller.common.gal.PlayerHandleFactory;
import top.fifthlight.touchcontroller.common.gal.RidingEntityType;
import top.fifthlight.touchcontroller.common.gal.ViewActionProvider;
import top.fifthlight.touchcontroller.common.gal.WindowHandle;
import top.fifthlight.touchcontroller.common.input.InputManager;
import top.fifthlight.touchcontroller.common.layout.Context;
import top.fifthlight.touchcontroller.common.layout.ContextInput;
import top.fifthlight.touchcontroller.common.layout.ContextResult;
import top.fifthlight.touchcontroller.common.layout.ContextStatus;
import top.fifthlight.touchcontroller.common.layout.ContextTimer;
import top.fifthlight.touchcontroller.common.layout.DrawQueue;
import top.fifthlight.touchcontroller.common.layout.HudKt;
import top.fifthlight.touchcontroller.common.layout.InventorySlotStatus;
import top.fifthlight.touchcontroller.common.model.ControllerHudModel;
import top.fifthlight.touchcontroller.common.model.TouchStateModel;
import top.fifthlight.touchcontroller.common.platform.PlatformProvider;
import top.fifthlight.touchcontroller.proxy.client.PlatformCapability;
import top.fifthlight.touchcontroller.proxy.message.AddPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.CapabilityMessage;
import top.fifthlight.touchcontroller.proxy.message.ClearPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.InputStatusMessage;
import top.fifthlight.touchcontroller.proxy.message.RemovePointerMessage;
import top.fifthlight.touchcontroller.proxy.message.VibrateMessage;
import top.fifthlight.touchcontroller.relocated.kotlin.Lazy;
import top.fifthlight.touchcontroller.relocated.kotlin.LazyKt__LazyJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.MapsKt__MapsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function0;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function2;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Reflection;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.ExtensionsKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.PersistentMap;
import top.fifthlight.touchcontroller.relocated.org.koin.core.Koin;
import top.fifthlight.touchcontroller.relocated.org.koin.core.component.KoinComponent;
import top.fifthlight.touchcontroller.relocated.org.koin.core.qualifier.Qualifier;
import top.fifthlight.touchcontroller.relocated.org.koin.mp.KoinPlatformTools;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.input.TextInputState;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.input.TextRange;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.paint.Canvas;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntOffset;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntSize;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.Offset;

public final class RenderEvents
implements KoinComponent {
    public static final RenderEvents INSTANCE;
    public static final Logger logger;
    public static final Lazy window$delegate;
    public static final Lazy configHolder$delegate;
    public static final Lazy controllerHudModel$delegate;
    public static final Lazy touchStateModel$delegate;
    public static final Lazy playerHandleFactory$delegate;
    public static final Lazy platformProvider$delegate;
    public static final Lazy gameStateProvider$delegate;
    public static final Lazy keyBindingHandler$delegate;
    public static final Lazy viewActionProvider$delegate;
    public static int prevWidth;
    public static int prevHeight;
    public static final Set _platformCapabilities;
    public static final Set platformCapabilities;
    public static final int $stable;

    private final PlatformProvider getPlatformProvider() {
        return (PlatformProvider)platformProvider$delegate.getValue();
    }

    private final KeyBindingHandler getKeyBindingHandler() {
        return (KeyBindingHandler)keyBindingHandler$delegate.getValue();
    }

    public static final void onRenderStart() {
        ContextInput contextInput;
        DrawQueue drawQueue;
        Object object;
        Object object2;
        Object object3;
        Object object4 = INSTANCE;
        ((RenderEvents)object4).getControllerHudModel().getTimer().renderTick();
        ((RenderEvents)object4).getKeyBindingHandler().renderTick(((RenderEvents)object4).getControllerHudModel().getTimer().getRenderTick());
        if (((RenderEvents)object4).getControllerHudModel().getStatus().getVibrate()) {
            object3 = ((RenderEvents)object4).getPlatformProvider().getPlatform();
            if (object3 != null) {
                object3.sendEvent(new VibrateMessage(VibrateMessage.Kind.BLOCK_BROKEN));
            }
            ((RenderEvents)object4).getControllerHudModel().getStatus().setVibrate(false);
        }
        RenderEvents renderEvents = object4;
        object4 = renderEvents.getGameStateProvider().currentState();
        object3 = renderEvents.getPlatformProvider().getPlatform();
        if (object3 != null) {
            while (true) {
                TextRange textRange;
                TextRange textRange2;
                WindowEvents windowEvents = WindowEvents.INSTANCE;
                int n = windowEvents.getWindowWidth();
                int n2 = windowEvents.getWindowHeight();
                if (n != prevWidth || n2 != prevHeight) {
                    prevWidth = n;
                    prevHeight = n2;
                    object3.resize(n, n2);
                }
                if ((object2 = object3.pollEvent()) == null) break;
                if (object2 instanceof AddPointerMessage) {
                    AddPointerMessage addPointerMessage = (AddPointerMessage)object2;
                    int n3 = addPointerMessage.getIndex();
                    float f = addPointerMessage.getX();
                    float f2 = addPointerMessage.getY();
                    long l = Float.floatToRawIntBits(f2);
                    INSTANCE.getTouchStateModel().addPointer-_0sKWyo(n3, Offset.constructor-impl((long)Float.floatToRawIntBits(f) << 32 | l & 0xFFFFFFFFL));
                    continue;
                }
                if (object2 instanceof RemovePointerMessage) {
                    INSTANCE.getTouchStateModel().removePointer(((RemovePointerMessage)object2).getIndex());
                    continue;
                }
                if (Intrinsics.areEqual(object2, ClearPointerMessage.INSTANCE)) {
                    INSTANCE.getTouchStateModel().clearPointer();
                    continue;
                }
                if (object2 instanceof CapabilityMessage) {
                    Object var4_22;
                    block25: {
                        for (Object t : PlatformCapability.getEntries()) {
                            var4_22 = t;
                            if (!Intrinsics.areEqual(((PlatformCapability)((Object)t)).getId(), ((CapabilityMessage)object2).getCapability())) continue;
                            break block25;
                        }
                        var4_22 = null;
                    }
                    Object object5 = var4_22;
                    if (object5 != null) {
                        object2 = (CapabilityMessage)object2;
                        logger.info("TouchController capability " + ((CapabilityMessage)object2).getCapability() + " set to " + ((CapabilityMessage)object2).getEnabled());
                        if (((CapabilityMessage)object2).getEnabled()) {
                            ((Collection)_platformCapabilities).add(object5);
                            continue;
                        }
                        ((Collection)_platformCapabilities).remove(object5);
                        continue;
                    }
                    logger.warn("Unknown capability: " + ((CapabilityMessage)object2).getCapability() + ", maybe you should update TouchController?");
                    continue;
                }
                if (!(object2 instanceof InputStatusMessage) || (object2 = ((InputStatusMessage)object2).getStatus()) == null) continue;
                Object object6 = object2;
                String string = ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object6).getText();
                TextRange textRange3 = textRange2;
                textRange2 = new TextRange(((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object2).getComposition().getStart(), ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object2).getComposition().getLength());
                object = textRange;
                textRange = new TextRange(((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object2).getSelection().getStart(), ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object2).getSelection().getLength());
                boolean bl = ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object6).getSelectionLeft();
                InputManager.INSTANCE.updateNativeState(new TextInputState(string, textRange3, (TextRange)object, bl));
            }
        }
        if (((GlobalConfig)((RenderEvents)(object3 = INSTANCE)).getConfigHolder().getConfig().getValue()).getDebug().getEnableTouchEmulation()) {
            object2 = ((RenderEvents)object3).getWindow().getMousePosition-sHUuaow();
            if (((RenderEvents)object3).getWindow().getMouseLeftPressed() && object2 != null) {
                long l = Offset.div-JopVrvY(((Offset)object2).unbox-impl(), IntSize.toSize-2DEOzdI(((RenderEvents)object3).getWindow().getSize-KlICH20()));
                ((RenderEvents)object3).getTouchStateModel().addPointer-_0sKWyo(0, l);
            } else {
                ((RenderEvents)object3).getTouchStateModel().clearPointer();
            }
        }
        if (!((GameState)object4).getInGame()) {
            return;
        }
        PlayerHandle playerHandle = ((RenderEvents)object3).getPlayerHandleFactory().getPlayerHandle();
        if (playerHandle == null) {
            return;
        }
        if (playerHandle.isFlying() || playerHandle.isSubmergedInWater()) {
            super.getKeyBindingHandler().getState(DefaultKeyBindingType.SNEAK).clearLock();
        }
        Object object7 = playerHandle.getRidingEntityType();
        Object object8 = MapsKt__MapsJVMKt.createMapBuilder();
        object8.put(LayerConditionKey.FLYING, playerHandle.isFlying());
        object8.put(LayerConditionKey.CAN_FLY, playerHandle.getCanFly());
        object8.put(LayerConditionKey.SWIMMING, playerHandle.isTouchingWater());
        object8.put(LayerConditionKey.UNDERWATER, playerHandle.isSubmergedInWater());
        object8.put(LayerConditionKey.SPRINTING, playerHandle.isSprinting());
        object8.put(LayerConditionKey.SNEAKING, playerHandle.isSneaking());
        object8.put(LayerConditionKey.ON_GROUND, playerHandle.getOnGround());
        object8.put(LayerConditionKey.NOT_ON_GROUND, playerHandle.getOnGround() ^ true);
        object8.put(LayerConditionKey.USING_ITEM, playerHandle.isUsingItem());
        object = LayerConditionKey.RIDING;
        Boolean bl = object7 != null;
        object8.put(object, bl);
        object = LayerConditionKey.BLOCK_SELECTED;
        bl = ((RenderEvents)object3).getViewActionProvider().getCrosshairTarget() == CrosshairTarget.BLOCK;
        object8.put(object, bl);
        object = LayerConditionKey.ON_MINECART;
        bl = object7 == RidingEntityType.MINECART;
        object8.put(object, bl);
        object = LayerConditionKey.ON_BOAT;
        bl = object7 == RidingEntityType.BOAT;
        object8.put(object, bl);
        object = LayerConditionKey.ON_PIG;
        bl = object7 == RidingEntityType.PIG;
        object8.put(object, bl);
        object = LayerConditionKey.ON_HORSE;
        bl = object7 == RidingEntityType.HORSE;
        object8.put(object, bl);
        object = LayerConditionKey.ON_CAMEL;
        bl = object7 == RidingEntityType.CAMEL;
        object8.put(object, bl);
        object = LayerConditionKey.ON_LLAMA;
        bl = object7 == RidingEntityType.LLAMA;
        RidingEntityType ridingEntityType = object7;
        object8.put(object, bl);
        object7 = LayerConditionKey.ON_STRIDER;
        object = ridingEntityType == RidingEntityType.STRIDER;
        Map map2 = object8;
        map2.put(object7, object);
        object7 = ExtensionsKt.toPersistentMap(MapsKt__MapsJVMKt.build(map2));
        object8 = (LayoutPreset)((RenderEvents)object3).getConfigHolder().getCurrentPreset().getValue();
        object = drawQueue;
        drawQueue = new DrawQueue();
        long l = ((RenderEvents)object3).getWindow().getSize-KlICH20();
        long l2 = ((RenderEvents)object3).getWindow().getScaledSize-KlICH20();
        long l3 = ((RenderEvents)object3).getWindow().getScaledSize-KlICH20();
        long l4 = IntOffset.Companion.getZERO-ITD3_cg();
        HashMap hashMap = ((RenderEvents)object3).getTouchStateModel().getPointers();
        ContextInput contextInput2 = contextInput;
        Object object9 = object4;
        boolean bl2 = ((GameState)object9).getInGui();
        Object object10 = ((GameState)object9).getPerspective();
        contextInput = new ContextInput(bl2, (PersistentMap)object7, (CameraPerspective)((Object)object10));
        InventorySlotStatus[] inventorySlotStatusArray = ((RenderEvents)object3).getControllerHudModel().getStatus();
        object7 = ((RenderEvents)object3).getControllerHudModel().getTimer();
        object10 = super.getKeyBindingHandler();
        GlobalConfig globalConfig = (GlobalConfig)((RenderEvents)object3).getConfigHolder().getConfig().getValue();
        PresetControlInfo presetControlInfo = ((LayoutPreset)object8).getControlInfo();
        Context context = new Context(l, l2, (DrawQueue)object, l3, l4, 0.0f, hashMap, contextInput2, null, (ContextStatus)inventorySlotStatusArray, (KeyBindingHandler)object10, (ContextTimer)object7, globalConfig, presetControlInfo, 288, null);
        HudKt.Hud(context, ControllerLayout.box-impl(((LayoutPreset)object8).getLayout-HWbCNyc()));
        inventorySlotStatusArray = context.getResult();
        ((RenderEvents)object3).getControllerHudModel().setResult((ContextResult)inventorySlotStatusArray);
        ((RenderEvents)object3).getControllerHudModel().setPendingDrawQueue((DrawQueue)object);
        ((RenderEvents)object3).getControllerHudModel().getStatus().getDoubleClickCounter().clean(((RenderEvents)object3).getControllerHudModel().getTimer().getClientTick());
        object3 = inventorySlotStatusArray.getPendingAction().iterator();
        while (object3.hasNext()) {
            ((Function2)object3.next()).invoke(INSTANCE.getControllerHudModel().getTimer(), playerHandle);
        }
        object3 = inventorySlotStatusArray.getLookDirection-sHUuaow();
        if (object3 != null) {
            long l5 = ((Offset)object3).unbox-impl();
            float f = Offset.component1-impl(l5);
            double d = f;
            double d2 = Offset.component2-impl(l5);
            playerHandle.changeLookDirection(d, d2);
        }
        inventorySlotStatusArray = inventorySlotStatusArray.getInventory().getSlots();
        int n = 0;
        for (InventorySlotStatus inventorySlotStatus : inventorySlotStatusArray) {
            int n4 = n + 1;
            if (inventorySlotStatus.getSelect()) {
                playerHandle.setCurrentSelectedSlot(n);
            }
            if (inventorySlotStatus.getDrop()) {
                if (playerHandle.getInventorySlot(n).isEmpty()) {
                    playerHandle.setCurrentSelectedSlot(n);
                } else {
                    playerHandle.dropSlot(n);
                }
            }
            n = n4;
        }
    }

    static {
        RenderEvents renderEvents;
        RenderEvents renderEvents2 = renderEvents;
        INSTANCE = new RenderEvents();
        logger = LoggerFactory.getLogger(RenderEvents.class);
        KoinPlatformTools koinPlatformTools = KoinPlatformTools.INSTANCE;
        window$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$1 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(WindowHandle.class), qualifier, function0);
            }
        });
        configHolder$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$2 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GlobalConfigHolder.class), qualifier, function0);
            }
        });
        controllerHudModel$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$3 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ControllerHudModel.class), qualifier, function0);
            }
        });
        touchStateModel$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$4 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(TouchStateModel.class), qualifier, function0);
            }
        });
        playerHandleFactory$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$5 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PlayerHandleFactory.class), qualifier, function0);
            }
        });
        platformProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$6 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PlatformProvider.class), qualifier, function0);
            }
        });
        gameStateProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$7 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GameStateProvider.class), qualifier, function0);
            }
        });
        keyBindingHandler$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$8 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(KeyBindingHandler.class), qualifier, function0);
            }
        });
        viewActionProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$9 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ViewActionProvider.class), qualifier, function0);
            }
        });
        _platformCapabilities = new LinkedHashSet();
        Set set = Collections.unmodifiableSet(_platformCapabilities);
        Intrinsics.checkNotNullExpressionValue(set, "unmodifiableSet(...)");
        platformCapabilities = set;
        $stable = 8;
    }

    public final Set getPlatformCapabilities() {
        return platformCapabilities;
    }

    public final void onHudRender(Canvas canvas) {
        Intrinsics.checkNotNullParameter(canvas, "canvas");
        DrawQueue drawQueue = ((RenderEvents)((Object)drawQueue)).getControllerHudModel().getPendingDrawQueue();
        if (drawQueue != null) {
            drawQueue.execute(canvas);
            INSTANCE.getControllerHudModel().setPendingDrawQueue(null);
        }
    }

    public final boolean shouldRenderCrosshair() {
        GlobalConfig globalConfig = (GlobalConfig)((RenderEvents)this).getConfigHolder().getConfig().getValue();
        if (!globalConfig.getRegular().getDisableCrosshair()) {
            return true;
        }
        if ((this = ((RenderEvents)this).getPlayerHandleFactory().getPlayerHandle()) == null) {
            return false;
        }
        return this.hasItemsOnHand(globalConfig.getItem().getShowCrosshairItems());
    }

    @Override
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    public final WindowHandle getWindow() {
        return (WindowHandle)window$delegate.getValue();
    }

    public final GlobalConfigHolder getConfigHolder() {
        return (GlobalConfigHolder)configHolder$delegate.getValue();
    }

    public final ControllerHudModel getControllerHudModel() {
        return (ControllerHudModel)controllerHudModel$delegate.getValue();
    }

    public final TouchStateModel getTouchStateModel() {
        return (TouchStateModel)touchStateModel$delegate.getValue();
    }

    public final PlayerHandleFactory getPlayerHandleFactory() {
        return (PlayerHandleFactory)playerHandleFactory$delegate.getValue();
    }

    public final GameStateProvider getGameStateProvider() {
        return (GameStateProvider)gameStateProvider$delegate.getValue();
    }

    public final ViewActionProvider getViewActionProvider() {
        return (ViewActionProvider)viewActionProvider$delegate.getValue();
    }
}

