/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal;

import java.util.Arrays;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal.PrimitiveArrayBuilder;

public final class LongArrayBuilder
extends PrimitiveArrayBuilder {
    public long[] buffer;
    public int position;

    public LongArrayBuilder(long[] lArray) {
        Intrinsics.checkNotNullParameter(lArray, "bufferWithData");
        this.buffer = lArray;
        this.position = lArray.length;
        this.ensureCapacity$kotlinx_serialization_core(10);
    }

    @Override
    public int getPosition$kotlinx_serialization_core() {
        return this.position;
    }

    @Override
    public void ensureCapacity$kotlinx_serialization_core(int n) {
        long[] lArray = this.buffer;
        if (this.buffer.length < n) {
            long[] lArray2 = Arrays.copyOf(lArray, RangesKt___RangesKt.coerceAtLeast(n, lArray.length * 2));
            Intrinsics.checkNotNullExpressionValue(lArray2, "copyOf(...)");
            this.buffer = lArray2;
        }
    }

    public final void append$kotlinx_serialization_core(long l) {
        LongArrayBuilder longArrayBuilder = this;
        PrimitiveArrayBuilder.ensureCapacity$kotlinx_serialization_core$default(longArrayBuilder, 0, 1, null);
        int n = this.getPosition$kotlinx_serialization_core();
        this.position = n + 1;
        longArrayBuilder.buffer[n] = l;
    }

    public long[] build$kotlinx_serialization_core() {
        long[] lArray = Arrays.copyOf(this.buffer, this.getPosition$kotlinx_serialization_core());
        Intrinsics.checkNotNullExpressionValue(lArray, "copyOf(...)");
        return lArray;
    }
}

