/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.org.slf4j.helpers;

import java.io.PrintStream;

public abstract class Reporter {
    public static final String[] SYSOUT_KEYS = new String[]{"System.out", "stdout", "sysout"};
    public static final TargetChoice TARGET_CHOICE = Reporter.getTargetChoice();
    public static final Level INTERNAL_VERBOSITY = Reporter.initVerbosity();

    public static TargetChoice getTargetChoice() {
        String string = System.getProperty("slf4j.internal.report.stream");
        if (string != null && !string.isEmpty()) {
            String[] stringArray = SYSOUT_KEYS;
            int n = SYSOUT_KEYS.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                return TargetChoice.Stdout;
            }
            return TargetChoice.Stderr;
        }
        return TargetChoice.Stderr;
    }

    public static Level initVerbosity() {
        String string = System.getProperty("slf4j.internal.verbosity");
        if (string != null && !string.isEmpty()) {
            if (string.equalsIgnoreCase("DEBUG")) {
                return Level.DEBUG;
            }
            if (string.equalsIgnoreCase("ERROR")) {
                return Level.ERROR;
            }
            if (string.equalsIgnoreCase("WARN")) {
                return Level.WARN;
            }
            return Level.INFO;
        }
        return Level.INFO;
    }

    public static boolean isEnabledFor(Level level) {
        return level.levelInt >= Reporter.INTERNAL_VERBOSITY.levelInt;
    }

    public static PrintStream getTarget() {
        if (TARGET_CHOICE.ordinal() != 1) {
            return System.err;
        }
        return System.out;
    }

    public static void debug(String string) {
        if (Reporter.isEnabledFor(Level.DEBUG)) {
            Reporter.getTarget().println("SLF4J(D): " + string);
        }
    }

    public static void info(String string) {
        if (Reporter.isEnabledFor(Level.INFO)) {
            Reporter.getTarget().println("SLF4J(I): " + string);
        }
    }

    public static final void warn(String string) {
        if (Reporter.isEnabledFor(Level.WARN)) {
            Reporter.getTarget().println("SLF4J(W): " + string);
        }
    }

    public static final void error(String string, Throwable throwable) {
        Reporter.getTarget().println("SLF4J(E): " + string);
        Reporter.getTarget().println("SLF4J(E): Reported exception:");
        throwable.printStackTrace(Reporter.getTarget());
    }

    public static final void error(String string) {
        Reporter.getTarget().println("SLF4J(E): " + string);
    }

    public static final class TargetChoice
    extends Enum {
        public static final /* enum */ TargetChoice Stderr = new TargetChoice("Stderr", 0);
        public static final /* enum */ TargetChoice Stdout = new TargetChoice("Stdout", 1);
        public static final /* synthetic */ TargetChoice[] $VALUES;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public TargetChoice() {
            void var2_-1;
            void var1_-1;
        }

        public static /* synthetic */ TargetChoice[] $values() {
            return new TargetChoice[]{Stderr, Stdout};
        }

        static {
            $VALUES = TargetChoice.$values();
        }
    }

    public static final class Level
    extends Enum {
        public static final /* enum */ Level DEBUG = new Level("DEBUG", 0, 0);
        public static final /* enum */ Level INFO = new Level("INFO", 1, 1);
        public static final /* enum */ Level WARN = new Level("WARN", 2, 2);
        public static final /* enum */ Level ERROR = new Level("ERROR", 3, 3);
        public static final /* synthetic */ Level[] $VALUES;
        public int levelInt;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public Level() {
            void var3_2;
            void var2_-1;
            void var1_-1;
            this.levelInt = var3_2;
        }

        public static /* synthetic */ Level[] $values() {
            return new Level[]{DEBUG, INFO, WARN, ERROR};
        }

        static {
            $VALUES = Level.$values();
        }
    }
}

