/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common_1_21_3_1_21_5.gal;

import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import top.fifthlight.combine.platform_1_21_3_1_21_5.ItemFactoryImplKt;
import top.fifthlight.combine.platform_1_21_3_1_21_5.ItemStackImpl;
import top.fifthlight.touchcontroller.common.config.ItemList;
import top.fifthlight.touchcontroller.common.gal.PlayerHandle;
import top.fifthlight.touchcontroller.common.gal.RidingEntityType;
import top.fifthlight.touchcontroller.helper.SyncableGameMode;
import top.fifthlight.touchcontroller.relocated.kotlin.enums.EnumEntries;
import top.fifthlight.touchcontroller.relocated.kotlin.enums.EnumEntriesKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public abstract class AbstractPlayerHandleImpl
implements PlayerHandle {
    public final LocalPlayer inner;

    public AbstractPlayerHandleImpl(LocalPlayer localPlayer) {
        Intrinsics.checkNotNullParameter(localPlayer, "inner");
        this.inner = localPlayer;
    }

    public final LocalPlayer getInner() {
        return this.inner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasItemsOnHand(ItemList itemList) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter(itemList, "list");
        Object object = EntriesMappings.entries$0;
        if (object instanceof Collection && object.isEmpty()) {
            return false;
        }
        object = object.iterator();
        do {
            if (!object.hasNext()) return false;
            InteractionHand interactionHand = (InteractionHand)object.next();
            itemStack = this.inner.getItemInHand(interactionHand);
            Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInHand(...)");
        } while (!itemList.contains(ItemStackImpl.getItem-impl(ItemFactoryImplKt.toCombine(itemStack))));
        return true;
    }

    @Override
    public void changeLookDirection(double d, double d2) {
        double d3 = d / 0.15;
        double d4 = d2 / 0.15;
        this.inner.turn(d3, d4);
    }

    @Override
    public void dropSlot(int n) {
        if (n == this.getCurrentSelectedSlot()) {
            this.inner.drop(true);
            return;
        }
        AbstractPlayerHandleImpl abstractPlayerHandleImpl = this;
        int n2 = abstractPlayerHandleImpl.getCurrentSelectedSlot();
        MultiPlayerGameMode multiPlayerGameMode = abstractPlayerHandleImpl.getClient().gameMode;
        Intrinsics.checkNotNull(multiPlayerGameMode, "null cannot be cast to non-null type top.fifthlight.touchcontroller.helper.SyncableGameMode");
        SyncableGameMode syncableGameMode = (SyncableGameMode)multiPlayerGameMode;
        this.setCurrentSelectedSlot(n);
        syncableGameMode.touchcontroller$callSyncSelectedSlot();
        this.inner.drop(true);
        this.setCurrentSelectedSlot(n2);
        syncableGameMode.touchcontroller$callSyncSelectedSlot();
    }

    @Override
    public top.fifthlight.combine.data.ItemStack getInventorySlot(int n) {
        ItemStack itemStack = this.inner.getInventory().getItem(n);
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItem(...)");
        return ItemStackImpl.box-impl(ItemStackImpl.constructor-impl(itemStack));
    }

    @Override
    public boolean isUsingItem() {
        return this.inner.isUsingItem();
    }

    @Override
    public boolean getOnGround() {
        return this.inner.onGround();
    }

    @Override
    public boolean isFlying() {
        return this.inner.getAbilities().flying;
    }

    @Override
    public void setFlying(boolean bl) {
        this.inner.getAbilities().flying = bl;
    }

    @Override
    public boolean isSubmergedInWater() {
        return this.inner.isUnderWater();
    }

    @Override
    public boolean isTouchingWater() {
        return this.inner.isInWater();
    }

    @Override
    public boolean isSprinting() {
        return this.inner.isSprinting();
    }

    @Override
    public void setSprinting(boolean bl) {
        this.inner.setSprinting(bl);
    }

    @Override
    public boolean isSneaking() {
        return this.inner.isSteppingCarefully();
    }

    @Override
    public RidingEntityType getRidingEntityType() {
        AbstractPlayerHandleImpl abstractPlayerHandleImpl = abstractPlayerHandleImpl.inner.getVehicle();
        return abstractPlayerHandleImpl == null ? null : (abstractPlayerHandleImpl instanceof AbstractMinecart ? RidingEntityType.MINECART : (abstractPlayerHandleImpl instanceof AbstractBoat ? RidingEntityType.BOAT : (abstractPlayerHandleImpl instanceof Pig ? RidingEntityType.PIG : (abstractPlayerHandleImpl instanceof Camel ? RidingEntityType.CAMEL : (!(abstractPlayerHandleImpl instanceof Horse || abstractPlayerHandleImpl instanceof Donkey || abstractPlayerHandleImpl instanceof Mule || abstractPlayerHandleImpl instanceof ZombieHorse || abstractPlayerHandleImpl instanceof SkeletonHorse) ? (abstractPlayerHandleImpl instanceof Llama ? RidingEntityType.LLAMA : (abstractPlayerHandleImpl instanceof Strider ? RidingEntityType.STRIDER : RidingEntityType.OTHER)) : RidingEntityType.HORSE)))));
    }

    @Override
    public boolean getCanFly() {
        return this.inner.getAbilities().mayfly;
    }

    public final Minecraft getClient() {
        Minecraft minecraft = Minecraft.getInstance();
        Intrinsics.checkNotNullExpressionValue(minecraft, "getInstance(...)");
        return minecraft;
    }

    public abstract class EntriesMappings {
        public static final /* synthetic */ EnumEntries entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])InteractionHand.values());
        }
    }
}

