/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.androidx.compose.runtime;

import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.Applier;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.ComposerKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class OffsetApplier
implements Applier {
    public final Applier applier;
    public final int offset;
    public int nesting;

    public OffsetApplier(Applier applier, int n) {
        Intrinsics.checkNotNullParameter(applier, "applier");
        this.applier = applier;
        this.offset = n;
    }

    @Override
    public Object getCurrent() {
        return this.applier.getCurrent();
    }

    @Override
    public void down(Object object) {
        OffsetApplier offsetApplier = this;
        ++offsetApplier.nesting;
        offsetApplier.applier.down(object);
    }

    @Override
    public void up() {
        if (!(this.nesting > 0)) {
            ComposerKt.composeImmediateRuntimeError("OffsetApplier up called with no corresponding down");
        }
        OffsetApplier offsetApplier = this;
        offsetApplier.nesting += -1;
        offsetApplier.applier.up();
    }

    @Override
    public void insertTopDown(int n, Object object) {
        OffsetApplier offsetApplier = this;
        Applier applier = offsetApplier.applier;
        int n2 = offsetApplier.nesting == 0 ? this.offset : 0;
        applier.insertTopDown(n + n2, object);
    }

    @Override
    public void insertBottomUp(int n, Object object) {
        OffsetApplier offsetApplier = this;
        Applier applier = offsetApplier.applier;
        int n2 = offsetApplier.nesting == 0 ? this.offset : 0;
        applier.insertBottomUp(n + n2, object);
    }

    @Override
    public void remove(int n, int n2) {
        OffsetApplier offsetApplier = this;
        Applier applier = offsetApplier.applier;
        int n3 = offsetApplier.nesting == 0 ? this.offset : 0;
        applier.remove(n + n3, n2);
    }

    @Override
    public void move(int n, int n2, int n3) {
        int n4 = this.nesting == 0 ? this.offset : 0;
        int n5 = n + n4;
        this.applier.move(n5, n2 + n4, n3);
    }

    @Override
    public void clear() {
        ComposerKt.composeImmediateRuntimeError("Clear is not valid on OffsetApplier");
    }
}

