/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.androidx.compose.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.Anchor;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.Composer;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.ComposerKt;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.GroupSourceInformation;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.IntStack;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.KeyInfo;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.PreconditionsKt;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotTable;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.SlotTableKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class SlotReader {
    public final SlotTable table;
    public final int[] groups;
    public final int groupsSize;
    public final Object[] slots;
    public final int slotsSize;
    public HashMap sourceInformationMap;
    public boolean closed;
    public int currentGroup;
    public int currentEnd;
    public int parent;
    public final IntStack currentSlotStack;
    public int emptyCount;
    public int currentSlot;
    public int currentSlotEnd;
    public boolean hadNext;

    public SlotReader(SlotTable slotTable) {
        int n;
        SlotReader slotReader = this;
        Intrinsics.checkNotNullParameter(slotTable, "table");
        this.table = slotTable;
        this.groups = slotTable.getGroups();
        this.groupsSize = n = slotTable.getGroupsSize();
        this.slots = slotTable.getSlots();
        slotReader.slotsSize = slotTable.getSlotsSize();
        slotReader.currentEnd = n;
        slotReader.parent = -1;
        slotReader.currentSlotStack = new IntStack();
    }

    public final Object node(int[] nArray, int n) {
        return SlotTableKt.access$isNode(nArray, n) ? this.slots[SlotTableKt.access$nodeIndex(nArray, n)] : Composer.Companion.getEmpty();
    }

    public final Object aux(int[] nArray, int n) {
        return SlotTableKt.access$hasAux(nArray, n) ? this.slots[SlotTableKt.access$auxIndex(nArray, n)] : Composer.Companion.getEmpty();
    }

    public final Object objectKey(int[] nArray, int n) {
        return SlotTableKt.access$hasObjectKey(nArray, n) ? this.slots[SlotTableKt.access$objectKeyIndex(nArray, n)] : null;
    }

    public final SlotTable getTable$runtime() {
        return this.table;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final int getCurrentGroup() {
        return this.currentGroup;
    }

    public final int getParent() {
        return this.parent;
    }

    public final int getSize() {
        return this.groupsSize;
    }

    public final int parent(int n) {
        return SlotTableKt.access$parentAnchor(this.groups, n);
    }

    public final boolean isNode() {
        return SlotTableKt.access$isNode(this.groups, this.currentGroup);
    }

    public final boolean isNode(int n) {
        return SlotTableKt.access$isNode(this.groups, n);
    }

    public final int nodeCount(int n) {
        return SlotTableKt.access$nodeCount(this.groups, n);
    }

    public final Object node(int n) {
        Object object;
        if (SlotTableKt.access$isNode(this.groups, n)) {
            SlotReader slotReader = this;
            object = slotReader.node(slotReader.groups, n);
        } else {
            object = null;
        }
        return object;
    }

    public final boolean isGroupEnd() {
        return this.getInEmpty() || this.currentGroup == this.currentEnd;
    }

    public final boolean getInEmpty() {
        return this.emptyCount > 0;
    }

    public final int getGroupSize() {
        return SlotTableKt.access$groupSize(this.groups, this.currentGroup);
    }

    public final int groupSize(int n) {
        return SlotTableKt.access$groupSize(this.groups, n);
    }

    public final int getGroupEnd() {
        return this.currentEnd;
    }

    public final int getGroupKey() {
        int n = this.currentGroup;
        return n < this.currentEnd ? SlotTableKt.access$key(this.groups, n) : 0;
    }

    public final int groupKey(int n) {
        return SlotTableKt.access$key(this.groups, n);
    }

    public final int getGroupSlotIndex() {
        return this.currentSlot - SlotTableKt.access$slotAnchor(this.groups, this.parent);
    }

    public final boolean hasObjectKey(int n) {
        return SlotTableKt.access$hasObjectKey(this.groups, n);
    }

    public final boolean getHasObjectKey() {
        int n = this.currentGroup;
        return n < this.currentEnd && SlotTableKt.access$hasObjectKey(this.groups, n);
    }

    public final Object getGroupObjectKey() {
        Object object;
        int n = this.currentGroup;
        if (n < this.currentEnd) {
            SlotReader slotReader = this;
            object = slotReader.objectKey(slotReader.groups, n);
        } else {
            object = null;
        }
        return object;
    }

    public final Object groupObjectKey(int n) {
        SlotReader slotReader = this;
        return slotReader.objectKey(slotReader.groups, n);
    }

    public final Object getGroupAux() {
        Object object;
        int n = this.currentGroup;
        if (n < this.currentEnd) {
            SlotReader slotReader = this;
            object = slotReader.aux(slotReader.groups, n);
        } else {
            object = 0;
        }
        return object;
    }

    public final Object groupAux(int n) {
        SlotReader slotReader = this;
        return slotReader.aux(slotReader.groups, n);
    }

    public final boolean hasMark(int n) {
        return SlotTableKt.access$hasMark(this.groups, n);
    }

    public final boolean containsMark(int n) {
        return SlotTableKt.access$containsMark(this.groups, n);
    }

    public final int getParentNodes() {
        int n = this.parent;
        return n >= 0 ? SlotTableKt.access$nodeCount(this.groups, n) : 0;
    }

    public final int getRemainingSlots() {
        return this.currentSlotEnd - this.currentSlot;
    }

    public final Object groupGet(int n) {
        SlotReader slotReader = this;
        return slotReader.groupGet(slotReader.currentGroup, n);
    }

    public final Object groupGet(int n, int n2) {
        int n3 = SlotTableKt.access$slotAnchor(this.groups, n);
        n = ++n < this.groupsSize ? SlotTableKt.access$dataAnchor(this.groups, n) : this.slotsSize;
        n2 = n3 + n2;
        return n2 < n ? this.slots[n2] : Composer.Companion.getEmpty();
    }

    public final Object next() {
        int n;
        if (this.emptyCount <= 0 && (n = this.currentSlot) < this.currentSlotEnd) {
            this.hadNext = true;
            this.currentSlot = n + 1;
            return this.slots[n];
        }
        this.hadNext = false;
        return Composer.Companion.getEmpty();
    }

    public final boolean getHadNext() {
        return this.hadNext;
    }

    public final void beginEmpty() {
        ++this.emptyCount;
    }

    public final void endEmpty() {
        if (!(this.emptyCount > 0)) {
            PreconditionsKt.throwIllegalArgumentException("Unbalanced begin/end empty");
        }
        this.emptyCount += -1;
    }

    public final void close() {
        this.closed = true;
        SlotReader slotReader = this;
        this.table.close$runtime(slotReader, slotReader.sourceInformationMap);
    }

    public final void startGroup() {
        if (this.emptyCount <= 0) {
            int n;
            GroupSourceInformation groupSourceInformation;
            HashMap hashMap;
            SlotReader slotReader = this;
            int n2 = slotReader.parent;
            int n3 = slotReader.currentGroup;
            if (!(SlotTableKt.access$parentAnchor(slotReader.groups, n3) == n2)) {
                PreconditionsKt.throwIllegalArgumentException("Invalid slot table detected");
            }
            if ((hashMap = this.sourceInformationMap) != null && (groupSourceInformation = (GroupSourceInformation)hashMap.get(this.anchor(n2))) != null) {
                groupSourceInformation.reportGroup(this.table, n3);
            }
            SlotReader slotReader2 = this;
            IntStack intStack = slotReader2.currentSlotStack;
            int n4 = slotReader2.currentSlot;
            int n5 = this.currentSlotEnd;
            if (n4 == 0 && n5 == 0) {
                intStack.push(-1);
            } else {
                intStack.push(n4);
            }
            SlotReader slotReader3 = this;
            this.parent = n3;
            slotReader3.currentEnd = n3 + SlotTableKt.access$groupSize(this.groups, n3);
            slotReader3.currentGroup = n = n3 + 1;
            slotReader3.currentSlot = SlotTableKt.access$slotAnchor(slotReader3.groups, n3);
            n = n3 >= slotReader3.groupsSize - 1 ? this.slotsSize : SlotTableKt.access$dataAnchor(this.groups, n);
            this.currentSlotEnd = n;
        }
    }

    public final void startNode() {
        if (this.emptyCount <= 0) {
            if (!SlotTableKt.access$isNode(this.groups, this.currentGroup)) {
                PreconditionsKt.throwIllegalArgumentException("Expected a node group");
            }
            this.startGroup();
        }
    }

    public final int skipGroup() {
        if (!(this.emptyCount == 0)) {
            ComposerKt.composeImmediateRuntimeError("Cannot skip while in an empty region");
        }
        int n = this.currentGroup;
        this.currentGroup = n + SlotTableKt.access$groupSize(this.groups, n);
        return SlotTableKt.access$isNode(this.groups, this.currentGroup) ? 1 : SlotTableKt.access$nodeCount(this.groups, this.currentGroup);
    }

    public final void skipToGroupEnd() {
        if (!(this.emptyCount == 0)) {
            ComposerKt.composeImmediateRuntimeError("Cannot skip the enclosing group while in an empty region");
        }
        this.currentGroup = this.currentEnd;
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void reposition(int n) {
        if (!(this.emptyCount == 0)) {
            ComposerKt.composeImmediateRuntimeError("Cannot reposition while in an empty region");
        }
        this.currentGroup = n;
        n = n < this.groupsSize ? SlotTableKt.access$parentAnchor(this.groups, n) : -1;
        this.parent = n;
        this.currentEnd = n < 0 ? this.groupsSize : n + SlotTableKt.access$groupSize(this.groups, n);
        SlotReader slotReader = this;
        slotReader.currentSlot = 0;
        slotReader.currentSlotEnd = 0;
    }

    public final void restoreParent(int n) {
        int n2 = n + SlotTableKt.access$groupSize(this.groups, n);
        int n3 = this.currentGroup;
        if (!(n3 >= n && n3 <= n2)) {
            ComposerKt.composeImmediateRuntimeError("Index " + n + " is not a parent of " + n3);
        }
        SlotReader slotReader = this;
        slotReader.parent = n;
        slotReader.currentEnd = n2;
        slotReader.currentSlot = 0;
        slotReader.currentSlotEnd = 0;
    }

    public final void endGroup() {
        if (this.emptyCount == 0) {
            int n;
            if (!(this.currentGroup == this.currentEnd)) {
                ComposerKt.composeImmediateRuntimeError("endGroup() not called at the end of a group");
            }
            this.parent = n = SlotTableKt.access$parentAnchor(this.groups, this.parent);
            int n2 = n < 0 ? this.groupsSize : n + SlotTableKt.access$groupSize(this.groups, n);
            this.currentEnd = n2;
            n2 = this.currentSlotStack.pop();
            if (n2 < 0) {
                SlotReader slotReader = this;
                slotReader.currentSlot = 0;
                slotReader.currentSlotEnd = 0;
            } else {
                this.currentSlot = n2;
                n = n >= this.groupsSize - 1 ? this.slotsSize : SlotTableKt.access$dataAnchor(this.groups, n + 1);
                this.currentSlotEnd = n;
            }
        }
    }

    public final List extractKeys() {
        ArrayList<KeyInfo> arrayList;
        ArrayList<KeyInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<KeyInfo>();
        if (this.emptyCount > 0) {
            return arrayList2;
        }
        int n = 0;
        for (int i = this.currentGroup; i < this.currentEnd; i += SlotTableKt.access$groupSize(this.groups, i)) {
            KeyInfo keyInfo;
            SlotReader slotReader = this;
            int n2 = SlotTableKt.access$key(slotReader.groups, i);
            Object object = slotReader.objectKey(slotReader.groups, i);
            int n3 = SlotTableKt.access$isNode(slotReader.groups, i) ? 1 : SlotTableKt.access$nodeCount(this.groups, i);
            KeyInfo keyInfo2 = keyInfo;
            int n4 = n + 1;
            keyInfo2(n2, object, i, n3, n);
            arrayList2.add(keyInfo2);
            n = n4;
        }
        return arrayList2;
    }

    public String toString() {
        return "SlotReader(current=" + this.currentGroup + ", key=" + this.getGroupKey() + ", parent=" + this.parent + ", end=" + this.currentEnd + ')';
    }

    public final Anchor anchor(int n) {
        Anchor anchor;
        ArrayList arrayList = this.table.getAnchors$runtime();
        int n2 = SlotTableKt.access$search(arrayList, n, this.groupsSize);
        if (n2 < 0) {
            Anchor anchor2;
            anchor = anchor2;
            anchor2 = new Anchor(n);
            arrayList.add(-(n2 + 1), anchor);
        } else {
            Object e = arrayList.get(n2);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            anchor = (Anchor)e;
        }
        return anchor;
    }
}

