/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.AbstractCollection;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.markers.KMappedMarker;

public abstract class AbstractList
extends AbstractCollection
implements List,
KMappedMarker {
    public static final Companion Companion = new Companion(null);

    public abstract Object get(int var1);

    @Override
    public Iterator iterator() {
        return new IteratorImpl();
    }

    @Override
    public int indexOf(Object object) {
        int n;
        block2: {
            n = 0;
            Iterator iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                if (!Intrinsics.areEqual(iterator2.next(), object)) {
                    ++n;
                    continue;
                }
                break block2;
            }
            n = -1;
        }
        return n;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n;
        block1: {
            AbstractList abstractList = listIterator2;
            ListIterator listIterator2 = abstractList.listIterator(abstractList.size());
            while (listIterator2.hasPrevious()) {
                if (!Intrinsics.areEqual(listIterator2.previous(), object)) continue;
                n = listIterator2.nextIndex();
                break block1;
            }
            n = -1;
        }
        return n;
    }

    public ListIterator listIterator() {
        return new ListIteratorImpl(0);
    }

    public ListIterator listIterator(int n) {
        return new ListIteratorImpl(n);
    }

    public List subList(int n, int n2) {
        return new SubList(this, n, n2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        return Companion.orderedEquals$kotlin_stdlib(this, (Collection)object);
    }

    @Override
    public int hashCode() {
        return Companion.orderedHashCode$kotlin_stdlib(this);
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final void checkElementIndex$kotlin_stdlib(int n, int n2) {
            if (n >= 0 && n < n2) {
                return;
            }
            throw new IndexOutOfBoundsException("index: " + n + ", size: " + n2);
        }

        public final void checkPositionIndex$kotlin_stdlib(int n, int n2) {
            if (n >= 0 && n <= n2) {
                return;
            }
            throw new IndexOutOfBoundsException("index: " + n + ", size: " + n2);
        }

        public final void checkRangeIndexes$kotlin_stdlib(int n, int n2, int n3) {
            if (n >= 0 && n2 <= n3) {
                if (n <= n2) {
                    return;
                }
                throw new IllegalArgumentException("fromIndex: " + n + " > toIndex: " + n2);
            }
            throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + ", size: " + n3);
        }

        public final void checkBoundsIndexes$kotlin_stdlib(int n, int n2, int n3) {
            if (n >= 0 && n2 <= n3) {
                if (n <= n2) {
                    return;
                }
                throw new IllegalArgumentException("startIndex: " + n + " > endIndex: " + n2);
            }
            throw new IndexOutOfBoundsException("startIndex: " + n + ", endIndex: " + n2 + ", size: " + n3);
        }

        public final int newCapacity$kotlin_stdlib(int n, int n2) {
            int n3 = n;
            int n4 = n3 + (n3 >> 1);
            if (n4 - n2 < 0) {
                n4 = n2;
            }
            if (n4 - 0x7FFFFFF7 > 0) {
                n4 = n2 > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
            }
            return n4;
        }

        public final int orderedHashCode$kotlin_stdlib(Collection object) {
            Collection collection = object;
            Intrinsics.checkNotNullParameter(collection, "c");
            int n = 1;
            for (Object e : collection) {
                n *= 31;
                int n2 = e != null ? e.hashCode() : 0;
                n += n2;
            }
            return n;
        }

        public final boolean orderedEquals$kotlin_stdlib(Collection object, Collection collection) {
            Intrinsics.checkNotNullParameter(object, "c");
            Intrinsics.checkNotNullParameter(collection, "other");
            if (object.size() != collection.size()) {
                return false;
            }
            Iterator iterator2 = collection.iterator();
            object = object.iterator();
            while (object.hasNext()) {
                if (Intrinsics.areEqual(object.next(), iterator2.next())) continue;
                return false;
            }
            return true;
        }
    }

    public class IteratorImpl
    implements Iterator,
    KMappedMarker {
        public int index;

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractList.this.size();
        }

        public Object next() {
            if (this.hasNext()) {
                int n = this.index;
                this.index = n + 1;
                return AbstractList.this.get(n);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    public class ListIteratorImpl
    extends IteratorImpl
    implements ListIterator,
    KMappedMarker {
        public ListIteratorImpl(int n) {
            Companion.checkPositionIndex$kotlin_stdlib(n, AbstractList.this.size());
            this.setIndex(n);
        }

        @Override
        public boolean hasPrevious() {
            return this.getIndex() > 0;
        }

        @Override
        public int nextIndex() {
            return this.getIndex();
        }

        public Object previous() {
            if (this.hasPrevious()) {
                ListIteratorImpl listIteratorImpl = this;
                listIteratorImpl.setIndex(listIteratorImpl.getIndex() + -1);
                return AbstractList.this.get(listIteratorImpl.getIndex());
            }
            throw new NoSuchElementException();
        }

        @Override
        public int previousIndex() {
            return this.getIndex() - 1;
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public void add(Object object) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    public static final class SubList
    extends AbstractList
    implements RandomAccess {
        public final AbstractList list;
        public final int fromIndex;
        public int _size;

        public SubList(AbstractList abstractList, int n, int n2) {
            Intrinsics.checkNotNullParameter(abstractList, "list");
            this.list = abstractList;
            this.fromIndex = n;
            Companion.checkRangeIndexes$kotlin_stdlib(n, n2, abstractList.size());
            this._size = n2 - n;
        }

        @Override
        public Object get(int n) {
            Companion.checkElementIndex$kotlin_stdlib(n, this._size);
            return this.list.get(this.fromIndex + n);
        }

        @Override
        public int getSize() {
            return this._size;
        }
    }
}

