/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal;

import java.util.Arrays;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal.PrimitiveArrayBuilder;

public final class FloatArrayBuilder
extends PrimitiveArrayBuilder {
    public float[] buffer;
    public int position;

    public FloatArrayBuilder(float[] fArray) {
        Intrinsics.checkNotNullParameter(fArray, "bufferWithData");
        this.buffer = fArray;
        this.position = fArray.length;
        this.ensureCapacity$kotlinx_serialization_core(10);
    }

    @Override
    public int getPosition$kotlinx_serialization_core() {
        return this.position;
    }

    @Override
    public void ensureCapacity$kotlinx_serialization_core(int n) {
        float[] fArray = this.buffer;
        if (this.buffer.length < n) {
            float[] fArray2 = Arrays.copyOf(fArray, RangesKt___RangesKt.coerceAtLeast(n, fArray.length * 2));
            Intrinsics.checkNotNullExpressionValue(fArray2, "copyOf(...)");
            this.buffer = fArray2;
        }
    }

    public final void append$kotlinx_serialization_core(float f) {
        FloatArrayBuilder floatArrayBuilder = this;
        PrimitiveArrayBuilder.ensureCapacity$kotlinx_serialization_core$default(floatArrayBuilder, 0, 1, null);
        int n = this.getPosition$kotlinx_serialization_core();
        this.position = n + 1;
        floatArrayBuilder.buffer[n] = f;
    }

    public float[] build$kotlinx_serialization_core() {
        float[] fArray = Arrays.copyOf(this.buffer, this.getPosition$kotlinx_serialization_core());
        Intrinsics.checkNotNullExpressionValue(fArray, "copyOf(...)");
        return fArray;
    }
}

