/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal;

import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.Json;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.JsonArray;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.JsonElement;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;

public final class JsonTreeListDecoder
extends AbstractJsonTreeDecoder {
    public final JsonArray value;
    public final int size;
    public int currentIndex;

    public JsonTreeListDecoder(Json json, JsonArray jsonArray) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(jsonArray, "value");
        super(json, jsonArray, null, 4, null);
        this.value = jsonArray;
        this.size = this.getValue().size();
        this.currentIndex = -1;
    }

    @Override
    public JsonArray getValue() {
        return this.value;
    }

    @Override
    public String elementName(SerialDescriptor serialDescriptor, int n) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        return String.valueOf(n);
    }

    @Override
    public JsonElement currentElement(String string) {
        Intrinsics.checkNotNullParameter(string, "tag");
        return this.getValue().get(Integer.parseInt(string));
    }

    @Override
    public int decodeElementIndex(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        int n = this.currentIndex;
        if (n < this.size - 1) {
            this.currentIndex = n + 1;
            return this.currentIndex;
        }
        return -1;
    }
}

