/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.org.koin.core.logger;

import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.org.koin.core.logger.Level;

public abstract class Logger {
    public Level level;

    public Logger(Level level) {
        Intrinsics.checkNotNullParameter((Object)level, "level");
        this.level = level;
    }

    public final Level getLevel() {
        return this.level;
    }

    public abstract void display(Level var1, String var2);

    public final void debug(String string) {
        Intrinsics.checkNotNullParameter(string, "msg");
        this.log(Level.DEBUG, string);
    }

    public final void info(String string) {
        Intrinsics.checkNotNullParameter(string, "msg");
        this.log(Level.INFO, string);
    }

    public final void warn(String string) {
        Intrinsics.checkNotNullParameter(string, "msg");
        this.log(Level.WARNING, string);
    }

    public final void error(String string) {
        Intrinsics.checkNotNullParameter(string, "msg");
        this.log(Level.ERROR, string);
    }

    public final void log(Level level, String string) {
        Intrinsics.checkNotNullParameter((Object)level, "lvl");
        Intrinsics.checkNotNullParameter(string, "msg");
        if (this.getLevel().compareTo(level) <= 0) {
            this.display(level, string);
        }
    }
}

