/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.scheduling;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import top.fifthlight.touchcontroller.relocated.kotlin.NoWhenBranchMatchedException;
import top.fifthlight.touchcontroller.relocated.kotlin.enums.EnumEntries;
import top.fifthlight.touchcontroller.relocated.kotlin.enums.EnumEntriesKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Ref$ObjectRef;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.AbstractTimeSourceKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.DebugKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.DebugStringsKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.internal.ResizableAtomicArray;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.internal.Symbol;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.scheduling.GlobalQueue;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.scheduling.Task;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.scheduling.TasksKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.scheduling.WorkQueue;

public final class CoroutineScheduler
implements Executor,
Closeable {
    public static final Companion Companion = new Companion(null);
    public static final /* synthetic */ AtomicLongFieldUpdater parkedWorkersStack$volatile$FU;
    public static final /* synthetic */ AtomicLongFieldUpdater controlState$volatile$FU;
    public static final /* synthetic */ AtomicIntegerFieldUpdater _isTerminated$volatile$FU;
    public static final Symbol NOT_IN_STACK;
    public final int corePoolSize;
    public final int maxPoolSize;
    public final long idleWorkerKeepAliveNs;
    public final String schedulerName;
    public final GlobalQueue globalCpuQueue;
    public final GlobalQueue globalBlockingQueue;
    private volatile /* synthetic */ long parkedWorkersStack$volatile;
    public final ResizableAtomicArray workers;
    private volatile /* synthetic */ long controlState$volatile;
    private volatile /* synthetic */ int _isTerminated$volatile;

    public CoroutineScheduler(int n, int n2, long l, String string) {
        this.corePoolSize = n;
        this.maxPoolSize = n2;
        this.idleWorkerKeepAliveNs = l;
        this.schedulerName = string;
        if (n >= 1) {
            if (n2 >= n) {
                if (n2 <= 0x1FFFFE) {
                    if (l > 0L) {
                        CoroutineScheduler coroutineScheduler = this;
                        coroutineScheduler.globalCpuQueue = new GlobalQueue();
                        coroutineScheduler.globalBlockingQueue = new GlobalQueue();
                        coroutineScheduler.workers = new ResizableAtomicArray((n + 1) * 2);
                        this.controlState$volatile = (long)n << 42;
                        return;
                    }
                    String string2 = "Idle worker keep alive time " + l + " must be positive";
                    throw new IllegalArgumentException(string2.toString());
                }
                String string3 = "Max pool size " + n2 + " should not exceed maximal supported number of threads 2097150";
                throw new IllegalArgumentException(string3.toString());
            }
            String string4 = "Max pool size " + n2 + " should be greater than or equals to core pool size " + n;
            throw new IllegalArgumentException(string4.toString());
        }
        String string5 = "Core pool size " + n + " should be at least 1";
        throw new IllegalArgumentException(string5.toString());
    }

    public final boolean addToGlobalQueue(Task task) {
        return task.taskContext ? this.globalBlockingQueue.addLast(task) : this.globalCpuQueue.addLast(task);
    }

    public final Worker parkedWorkersStackPop() {
        long l;
        Worker worker;
        int n;
        AtomicLongFieldUpdater atomicLongFieldUpdater = CoroutineScheduler.parkedWorkersStack$volatile$FU;
        do {
            int n2;
            if ((worker = (Worker)this.workers.get(n2 = (int)((l = atomicLongFieldUpdater.get(this)) & 0x1FFFFFL))) == null) {
                return null;
            }
            long l2 = l + 0x200000L & 0xFFFFFFFFFFE00000L;
        } while ((n = this.parkedWorkersStackNextIndex(worker)) < 0 || !CoroutineScheduler.parkedWorkersStack$volatile$FU.compareAndSet(this, l, l2 |= (long)n));
        Worker worker2 = worker;
        worker2.setNextParkedWorker(NOT_IN_STACK);
        return worker2;
    }

    public final int parkedWorkersStackNextIndex(Worker worker) {
        Object object = worker.getNextParkedWorker();
        while (object != NOT_IN_STACK) {
            if (object == null) {
                return 0;
            }
            int n = ((Worker)(object = (Worker)object)).getIndexInArray();
            if (n != 0) {
                return n;
            }
            object = ((Worker)object).getNextParkedWorker();
        }
        return -1;
    }

    public static /* synthetic */ void dispatch$default(CoroutineScheduler coroutineScheduler, Runnable runnable, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        coroutineScheduler.dispatch(runnable, bl, bl2);
    }

    public final void signalBlockingWork(long l) {
        if (this.tryUnpark()) {
            return;
        }
        if (this.tryCreateWorker(l)) {
            return;
        }
        this.tryUnpark();
    }

    public final boolean tryCreateWorker(long l) {
        if (RangesKt___RangesKt.coerceAtLeast((int)(l & 0x1FFFFFL) - (int)((l & 0x3FFFFE00000L) >> 21), 0) < this.corePoolSize) {
            int n = this.createNewWorker();
            if (n == 1 && this.corePoolSize > 1) {
                this.createNewWorker();
            }
            if (n > 0) {
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean tryCreateWorker$default(CoroutineScheduler coroutineScheduler, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = CoroutineScheduler.controlState$volatile$FU.get(coroutineScheduler);
        }
        return coroutineScheduler.tryCreateWorker(l);
    }

    public final boolean tryUnpark() {
        Worker worker;
        do {
            if ((worker = this.parkedWorkersStackPop()) != null) continue;
            return false;
        } while (!Worker.workerCtl$volatile$FU.compareAndSet(worker, -1, 0));
        LockSupport.unpark(worker);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final int createNewWorker() {
        Object object;
        block14: {
            block15: {
                Worker worker;
                int n;
                block13: {
                    int n2;
                    block12: {
                        block11: {
                            CoroutineScheduler coroutineScheduler = object;
                            ResizableAtomicArray resizableAtomicArray = coroutineScheduler.workers;
                            // MONITORENTER : resizableAtomicArray
                            if (!coroutineScheduler.isTerminated()) break block11;
                            return -1;
                        }
                        long l = CoroutineScheduler.controlState$volatile$FU.get(object);
                        n2 = (int)(l & 0x1FFFFFL);
                        n = RangesKt___RangesKt.coerceAtLeast(n2 - (int)((l & 0x3FFFFE00000L) >> 21), 0);
                        if (n < ((CoroutineScheduler)object).corePoolSize) break block12;
                        // MONITOREXIT : resizableAtomicArray
                        return 0;
                    }
                    if (n2 < ((CoroutineScheduler)object).maxPoolSize) break block13;
                    // MONITOREXIT : resizableAtomicArray
                    return 0;
                }
                int n3 = (int)(CoroutineScheduler.getControlState$volatile$FU().get(object) & 0x1FFFFFL) + 1;
                if (n3 <= 0) break block14;
                if (((CoroutineScheduler)object).workers.get(n3) != null) break block14;
                int n4 = n3;
                Object object2 = object;
                Worker worker2 = worker;
                worker = new Worker((CoroutineScheduler)object, n3);
                ((CoroutineScheduler)object2).workers.setSynchronized(n3, worker2);
                if (n4 != (int)(CoroutineScheduler.controlState$volatile$FU.incrementAndGet(object) & 0x1FFFFFL)) break block15;
                // MONITOREXIT : resizableAtomicArray
                worker2.start();
                return n + 1;
            }
            object = "Failed requirement.";
            throw new IllegalArgumentException(object.toString());
        }
        object = "Failed requirement.";
        throw new IllegalArgumentException(object.toString());
    }

    public final Task submitToLocalQueue(Worker worker, Task task, boolean bl) {
        if (worker == null) {
            return task;
        }
        Object object = worker.state;
        if (object == WorkerState.TERMINATED) {
            return task;
        }
        if (!task.taskContext && object == WorkerState.BLOCKING) {
            return task;
        }
        worker.mayHaveLocalTasks = true;
        return worker.localQueue.add(task, bl);
    }

    public final Worker currentWorker() {
        Thread thread = Thread.currentThread();
        thread = thread instanceof Worker ? (Worker)thread : null;
        if (thread == null || !Intrinsics.areEqual(((Worker)thread).this$0, this)) {
            thread = null;
        }
        return thread;
    }

    static {
        parkedWorkersStack$volatile$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "parkedWorkersStack$volatile");
        controlState$volatile$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "controlState$volatile");
        _isTerminated$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(CoroutineScheduler.class, "_isTerminated$volatile");
        NOT_IN_STACK = new Symbol("NOT_IN_STACK");
    }

    public final void parkedWorkersStackTopUpdate(Worker worker, int n, int n2) {
        AtomicLongFieldUpdater atomicLongFieldUpdater = CoroutineScheduler.parkedWorkersStack$volatile$FU;
        while (true) {
            long l = atomicLongFieldUpdater.get(this);
            int n3 = (int)(l & 0x1FFFFFL);
            long l2 = l + 0x200000L & 0xFFFFFFFFFFE00000L;
            if (n3 == n) {
                n3 = n2 == 0 ? this.parkedWorkersStackNextIndex(worker) : n2;
            }
            if (n3 < 0) continue;
            long l3 = l2 | (long)n3;
            if (CoroutineScheduler.parkedWorkersStack$volatile$FU.compareAndSet(this, l, l3)) break;
        }
    }

    public final boolean parkedWorkersStackPush(Worker worker) {
        long l;
        long l2;
        if (worker.getNextParkedWorker() != NOT_IN_STACK) {
            return false;
        }
        AtomicLongFieldUpdater atomicLongFieldUpdater = CoroutineScheduler.parkedWorkersStack$volatile$FU;
        do {
            l2 = atomicLongFieldUpdater.get(this);
            int n = (int)(l2 & 0x1FFFFFL);
            long l3 = l2 + 0x200000L & 0xFFFFFFFFFFE00000L;
            int n2 = worker.getIndexInArray();
            if (DebugKt.getASSERTIONS_ENABLED() && n2 == 0) {
                throw new AssertionError();
            }
            worker.setNextParkedWorker(this.workers.get(n));
            l = l3 | (long)n2;
        } while (!CoroutineScheduler.parkedWorkersStack$volatile$FU.compareAndSet(this, l2, l));
        return true;
    }

    public final boolean isTerminated() {
        return CoroutineScheduler._isTerminated$volatile$FU.get(this) == 1;
    }

    @Override
    public void execute(Runnable runnable) {
        CoroutineScheduler.dispatch$default(this, runnable, false, false, 6, null);
    }

    @Override
    public void close() {
        this.shutdown(10000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void shutdown(long l) {
        int n;
        if (!CoroutineScheduler._isTerminated$volatile$FU.compareAndSet(this, 0, 1)) {
            return;
        }
        CoroutineScheduler coroutineScheduler = this;
        Worker worker = coroutineScheduler.currentWorker();
        ResizableAtomicArray resizableAtomicArray = coroutineScheduler.workers;
        synchronized (resizableAtomicArray) {
            n = (int)(CoroutineScheduler.controlState$volatile$FU.get(this) & 0x1FFFFFL);
        }
        int n2 = 1;
        if (1 <= n) {
            while (true) {
                Object object = this.workers.get(n2);
                Intrinsics.checkNotNull(object);
                Worker worker2 = (Worker)object;
                if (worker2 != worker) {
                    while (worker2.getState() != Thread.State.TERMINATED) {
                        Worker worker3 = worker2;
                        LockSupport.unpark(worker3);
                        worker3.join(l);
                    }
                    if (DebugKt.getASSERTIONS_ENABLED() && worker2.state != WorkerState.TERMINATED) {
                        throw new AssertionError();
                    }
                    worker2.localQueue.offloadAllWorkTo(this.globalBlockingQueue);
                }
                if (n2 == n) break;
                ++n2;
            }
        }
        CoroutineScheduler coroutineScheduler2 = this;
        coroutineScheduler2.globalBlockingQueue.close();
        coroutineScheduler2.globalCpuQueue.close();
        while (true) {
            Task task;
            if ((worker == null || (task = worker.findTask(true)) == null) && (task = (Task)this.globalCpuQueue.removeFirstOrNull()) == null && (task = (Task)this.globalBlockingQueue.removeFirstOrNull()) == null) {
                if (worker != null) {
                    worker.tryReleaseCpu(WorkerState.TERMINATED);
                }
                if (DebugKt.getASSERTIONS_ENABLED() && (int)((CoroutineScheduler.controlState$volatile$FU.get(this) & 0x7FFFFC0000000000L) >> 42) != this.corePoolSize) {
                    throw new AssertionError();
                }
                CoroutineScheduler.parkedWorkersStack$volatile$FU.set(this, 0L);
                CoroutineScheduler.controlState$volatile$FU.set(this, 0L);
                return;
            }
            this.runSafely(task);
        }
    }

    public final void dispatch(Runnable runnable, boolean bl, boolean bl2) {
        AbstractTimeSourceKt.access$getTimeSource$p();
        runnable = this.createTask(runnable, bl);
        bl = ((Task)runnable).taskContext;
        long l = bl ? CoroutineScheduler.controlState$volatile$FU.addAndGet(this, 0x200000L) : 0L;
        CoroutineScheduler coroutineScheduler = this;
        runnable = coroutineScheduler.submitToLocalQueue(coroutineScheduler.currentWorker(), (Task)runnable, bl2);
        if (runnable != null && !this.addToGlobalQueue((Task)runnable)) {
            throw new RejectedExecutionException(this.schedulerName + " was terminated");
        }
        if (bl) {
            this.signalBlockingWork(l);
        } else {
            this.signalCpuWork();
        }
    }

    public final Task createTask(Runnable runnable, boolean bl) {
        long l = TasksKt.schedulerTimeSource.nanoTime();
        if (runnable instanceof Task) {
            ((Task)runnable).submissionTime = l;
            ((Task)runnable).taskContext = bl;
            return (Task)runnable;
        }
        return TasksKt.asTask(runnable, l, bl);
    }

    public final void signalCpuWork() {
        if (this.tryUnpark()) {
            return;
        }
        if (CoroutineScheduler.tryCreateWorker$default(this, 0L, 1, null)) {
            return;
        }
        this.tryUnpark();
    }

    public String toString() {
        ArrayList<String> arrayList;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        int n6 = this.workers.currentLength();
        block7: for (int i = 1; i < n6; ++i) {
            Worker worker = (Worker)this.workers.get(i);
            if (worker == null) continue;
            Worker worker2 = worker;
            int n7 = worker2.localQueue.getSize$kotlinx_coroutines_core();
            switch (WhenMappings.$EnumSwitchMapping$0[worker2.state.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 5: {
                    ++n5;
                    continue block7;
                }
                case 4: {
                    ++n4;
                    if (n7 <= 0) continue block7;
                    arrayList2.add("" + n7 + 'd');
                    continue block7;
                }
                case 3: {
                    ++n3;
                    arrayList2.add("" + n7 + 'c');
                    continue block7;
                }
                case 2: {
                    ++n2;
                    arrayList2.add("" + n7 + 'b');
                    continue block7;
                }
                case 1: {
                    ++n;
                }
            }
        }
        long l = CoroutineScheduler.controlState$volatile$FU.get(this);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.schedulerName).append('@').append(DebugStringsKt.getHexAddress(this)).append("[Pool Size {core = ").append(this.corePoolSize).append(", max = ").append(this.maxPoolSize).append("}, Worker States {CPU = ").append(n3).append(", blocking = ").append(n2).append(", parked = ").append(n).append(", dormant = ").append(n4).append(", terminated = ").append(n5).append("}, running workers queues = ").append(arrayList2).append(", global CPU queue size = ").append(this.globalCpuQueue.getSize()).append(", global blocking queue size = ").append(this.globalBlockingQueue.getSize());
        stringBuilder.append(", Control State {created workers= ").append((int)(l & 0x1FFFFFL)).append(", blocking tasks = ").append((int)((l & 0x3FFFFE00000L) >> 21)).append(", CPUs acquired = ").append(this.corePoolSize - (int)((l & 0x7FFFFC0000000000L) >> 42)).append("}]");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void runSafely(Task runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            try {
                runnable = Thread.currentThread();
                ((Thread)runnable).getUncaughtExceptionHandler().uncaughtException((Thread)runnable, throwable);
            }
            catch (Throwable throwable2) {
                AbstractTimeSourceKt.access$getTimeSource$p();
                throw throwable2;
            }
        }
        AbstractTimeSourceKt.access$getTimeSource$p();
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public abstract class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorkerState.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[WorkerState.PARKING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[WorkerState.BLOCKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[WorkerState.CPU_ACQUIRED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[WorkerState.DORMANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[WorkerState.TERMINATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }

    public final class Worker
    extends Thread {
        public static final /* synthetic */ AtomicIntegerFieldUpdater workerCtl$volatile$FU;
        private volatile int indexInArray;
        public final WorkQueue localQueue;
        public final Ref$ObjectRef stolenTask;
        public WorkerState state;
        private volatile /* synthetic */ int workerCtl$volatile;
        public long terminationDeadline;
        private volatile Object nextParkedWorker;
        public long minDelayUntilStealableTaskNs;
        public int rngState;
        public boolean mayHaveLocalTasks;
        public final /* synthetic */ CoroutineScheduler this$0;

        public Worker(CoroutineScheduler coroutineScheduler) {
            Worker worker = this;
            worker.this$0 = coroutineScheduler;
            worker.setDaemon(true);
            this.setContextClassLoader(coroutineScheduler.getClass().getClassLoader());
            this.localQueue = new WorkQueue();
            this.stolenTask = new Ref$ObjectRef();
            this.state = WorkerState.DORMANT;
            this.nextParkedWorker = NOT_IN_STACK;
            int n = (int)System.nanoTime();
            if (n == 0) {
                n = 42;
            }
            this.rngState = n;
        }

        public Worker(CoroutineScheduler coroutineScheduler, int n) {
            Worker worker = this;
            worker(coroutineScheduler);
            worker.setIndexInArray(n);
        }

        static {
            workerCtl$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(Worker.class, "workerCtl$volatile");
        }

        public final int getIndexInArray() {
            return this.indexInArray;
        }

        public final void setIndexInArray(int n) {
            StringBuilder stringBuilder = new StringBuilder().append(this.this$0.schedulerName).append("-worker-");
            String string = n == 0 ? "TERMINATED" : String.valueOf(n);
            this.setName(stringBuilder.append(string).toString());
            this.indexInArray = n;
        }

        public final Object getNextParkedWorker() {
            return this.nextParkedWorker;
        }

        public final void setNextParkedWorker(Object object) {
            this.nextParkedWorker = object;
        }

        public final boolean tryReleaseCpu(WorkerState workerState) {
            WorkerState workerState2 = this.state;
            boolean bl = workerState2 == WorkerState.CPU_ACQUIRED;
            if (bl) {
                CoroutineScheduler.controlState$volatile$FU.addAndGet(this.this$0, 0x40000000000L);
            }
            if (workerState2 != workerState) {
                this.state = workerState;
            }
            return bl;
        }

        @Override
        public void run() {
            this.runWorker();
        }

        public final int nextInt(int n) {
            int n2;
            int n3 = this.rngState;
            int n4 = n3 ^ n3 << 13;
            int n5 = n4 ^ n4 >> 17;
            this.rngState = n2 = n5 ^ n5 << 5;
            int n6 = n - 1;
            if ((n6 & n) == 0) {
                return n2 & n6;
            }
            return (n2 & Integer.MAX_VALUE) % n;
        }

        public final Task findTask(boolean bl) {
            if (this.tryAcquireCpuPermit()) {
                return this.findAnyTask(bl);
            }
            return this.findBlockingTask();
        }

        public final boolean tryAcquireCpuPermit() {
            boolean bl;
            block4: {
                if (this.state == WorkerState.CPU_ACQUIRED) {
                    bl = true;
                } else {
                    long l;
                    long l2;
                    CoroutineScheduler coroutineScheduler = this.this$0;
                    AtomicLongFieldUpdater atomicLongFieldUpdater = CoroutineScheduler.controlState$volatile$FU;
                    do {
                        if ((int)(((l2 = atomicLongFieldUpdater.get(coroutineScheduler)) & 0x7FFFFC0000000000L) >> 42) == 0) {
                            bl = false;
                            break block4;
                        }
                        l = l2 - 0x40000000000L;
                    } while (!CoroutineScheduler.controlState$volatile$FU.compareAndSet(coroutineScheduler, l2, l));
                    this.state = WorkerState.CPU_ACQUIRED;
                    bl = true;
                }
            }
            return bl;
        }

        public final void runWorker() {
            boolean bl = false;
            while (!this.this$0.isTerminated() && this.state != WorkerState.TERMINATED) {
                Worker worker = this;
                Task task = worker.findTask(worker.mayHaveLocalTasks);
                if (task != null) {
                    bl = false;
                    this.minDelayUntilStealableTaskNs = 0L;
                    this.executeTask(task);
                    continue;
                }
                this.mayHaveLocalTasks = false;
                if (this.minDelayUntilStealableTaskNs != 0L) {
                    if (!bl) {
                        bl = true;
                        continue;
                    }
                    Worker worker2 = this;
                    bl = false;
                    worker2.tryReleaseCpu(WorkerState.PARKING);
                    Thread.interrupted();
                    LockSupport.parkNanos(worker2.minDelayUntilStealableTaskNs);
                    worker2.minDelayUntilStealableTaskNs = 0L;
                    continue;
                }
                this.tryPark();
            }
            this.tryReleaseCpu(WorkerState.TERMINATED);
        }

        public final void tryPark() {
            if (!this.inStack()) {
                this.this$0.parkedWorkersStackPush(this);
                return;
            }
            Worker.workerCtl$volatile$FU.set(this, -1);
            while (this.inStack() && Worker.workerCtl$volatile$FU.get(this) == -1 && !this.this$0.isTerminated() && this.state != WorkerState.TERMINATED) {
                Worker worker = this;
                worker.tryReleaseCpu(WorkerState.PARKING);
                Thread.interrupted();
                worker.park();
            }
        }

        public final boolean inStack() {
            return this.nextParkedWorker != NOT_IN_STACK;
        }

        public final void executeTask(Task object) {
            this.terminationDeadline = 0L;
            if (this.state == WorkerState.PARKING) {
                if (DebugKt.getASSERTIONS_ENABLED() && !object.taskContext) {
                    throw new AssertionError();
                }
                this.state = WorkerState.BLOCKING;
            }
            if (object.taskContext) {
                WorkerState workerState = WorkerState.BLOCKING;
                if (this.tryReleaseCpu(workerState)) {
                    this.this$0.signalCpuWork();
                }
                Worker worker = this;
                worker.this$0.runSafely((Task)object);
                CoroutineScheduler.controlState$volatile$FU.addAndGet(worker.this$0, -2097152L);
                object = worker.state;
                if (object != WorkerState.TERMINATED) {
                    if (DebugKt.getASSERTIONS_ENABLED() && object != workerState) {
                        throw new AssertionError();
                    }
                    this.state = WorkerState.DORMANT;
                }
            } else {
                this.this$0.runSafely((Task)object);
            }
        }

        public final void park() {
            if (this.terminationDeadline == 0L) {
                this.terminationDeadline = System.nanoTime() + this.this$0.idleWorkerKeepAliveNs;
            }
            LockSupport.parkNanos(this.this$0.idleWorkerKeepAliveNs);
            if (System.nanoTime() - this.terminationDeadline >= 0L) {
                this.terminationDeadline = 0L;
                this.tryTerminateWorker();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public final void tryTerminateWorker() {
            int n;
            CoroutineScheduler coroutineScheduler;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            coroutineScheduler = this.this$0;
                            ResizableAtomicArray resizableAtomicArray = coroutineScheduler.workers;
                            // MONITORENTER : resizableAtomicArray
                            if (!coroutineScheduler.isTerminated()) break block9;
                            return;
                        }
                        long l = CoroutineScheduler.controlState$volatile$FU.get(coroutineScheduler);
                        if ((int)(l & 0x1FFFFFL) > coroutineScheduler.corePoolSize) break block10;
                        // MONITOREXIT : resizableAtomicArray
                        return;
                    }
                    if (Worker.workerCtl$volatile$FU.compareAndSet(this, -1, 1)) break block11;
                    // MONITOREXIT : resizableAtomicArray
                    return;
                }
                Worker worker = this;
                int n2 = worker.indexInArray;
                worker.setIndexInArray(0);
                coroutineScheduler.parkedWorkersStackTopUpdate(worker, n2, 0);
                n = (int)(CoroutineScheduler.controlState$volatile$FU.getAndDecrement(coroutineScheduler) & 0x1FFFFFL);
                if (n == n2) break block12;
                CoroutineScheduler coroutineScheduler2 = coroutineScheduler;
                CoroutineScheduler coroutineScheduler3 = coroutineScheduler2;
                Object object = coroutineScheduler2.workers.get(n);
                Intrinsics.checkNotNull(object);
                Worker worker2 = (Worker)object;
                coroutineScheduler.workers.setSynchronized(n2, worker2);
                worker2.setIndexInArray(n2);
                coroutineScheduler3.parkedWorkersStackTopUpdate(worker2, n, n2);
            }
            coroutineScheduler.workers.setSynchronized(n, null);
            // MONITOREXIT : resizableAtomicArray
            this.state = WorkerState.TERMINATED;
        }

        public final Task findBlockingTask() {
            Task task = this.localQueue.pollBlocking();
            if (task == null && (task = (Task)this.this$0.globalBlockingQueue.removeFirstOrNull()) == null) {
                task = this.trySteal(1);
            }
            return task;
        }

        public final Task findAnyTask(boolean bl) {
            if (bl) {
                Task task;
                Task task2;
                Worker worker = this;
                bl = worker.nextInt(worker.this$0.corePoolSize * 2) == 0;
                if (bl && (task2 = this.pollGlobalQueues()) != null) {
                    return task2;
                }
                task2 = this.localQueue.poll();
                if (task2 != null) {
                    return task2;
                }
                if (!bl && (task = this.pollGlobalQueues()) != null) {
                    return task;
                }
            } else {
                Task task = this.pollGlobalQueues();
                if (task != null) {
                    return task;
                }
            }
            return this.trySteal(3);
        }

        public final Task pollGlobalQueues() {
            if (this.nextInt(2) == 0) {
                Task task = (Task)this.this$0.globalCpuQueue.removeFirstOrNull();
                if (task != null) {
                    return task;
                }
                return (Task)this.this$0.globalBlockingQueue.removeFirstOrNull();
            }
            Task task = (Task)this.this$0.globalBlockingQueue.removeFirstOrNull();
            if (task != null) {
                return task;
            }
            return (Task)this.this$0.globalCpuQueue.removeFirstOrNull();
        }

        public final Task trySteal(int n) {
            int n2 = (int)(CoroutineScheduler.controlState$volatile$FU.get(((Worker)((Object)ref$ObjectRef)).this$0) & 0x1FFFFFL);
            if (n2 < 2) {
                return null;
            }
            Worker worker = ref$ObjectRef;
            int n3 = worker.nextInt(n2);
            long l = Long.MAX_VALUE;
            CoroutineScheduler coroutineScheduler = worker.this$0;
            for (int i = 0; i < n2; ++i) {
                Worker worker2;
                if (++n3 > n2) {
                    n3 = 1;
                }
                if ((worker2 = (Worker)coroutineScheduler.workers.get(n3)) == null || worker2 == ref$ObjectRef) continue;
                long l2 = worker2.localQueue.trySteal(n, ((Worker)((Object)ref$ObjectRef)).stolenTask);
                if (l2 == -1L) {
                    Ref$ObjectRef ref$ObjectRef = ((Worker)((Object)ref$ObjectRef)).stolenTask;
                    ref$ObjectRef.element = null;
                    return (Task)ref$ObjectRef.element;
                }
                if (l2 <= 0L) continue;
                l = Math.min(l, l2);
            }
            if (l == Long.MAX_VALUE) {
                l = 0L;
            }
            ((Worker)((Object)ref$ObjectRef)).minDelayUntilStealableTaskNs = l;
            return null;
        }
    }

    public static final class WorkerState
    extends Enum {
        public static final /* enum */ WorkerState CPU_ACQUIRED = new WorkerState("CPU_ACQUIRED", 0);
        public static final /* enum */ WorkerState BLOCKING = new WorkerState("BLOCKING", 1);
        public static final /* enum */ WorkerState PARKING = new WorkerState("PARKING", 2);
        public static final /* enum */ WorkerState DORMANT = new WorkerState("DORMANT", 3);
        public static final /* enum */ WorkerState TERMINATED = new WorkerState("TERMINATED", 4);
        public static final /* synthetic */ WorkerState[] $VALUES;
        public static final /* synthetic */ EnumEntries $ENTRIES;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public WorkerState() {
            void var2_-1;
            void var1_-1;
        }

        public static WorkerState[] values() {
            return (WorkerState[])$VALUES.clone();
        }

        public static final /* synthetic */ WorkerState[] $values() {
            return new WorkerState[]{CPU_ACQUIRED, BLOCKING, PARKING, DORMANT, TERMINATED};
        }

        static {
            $VALUES = WorkerState.$values();
            $ENTRIES = EnumEntriesKt.enumEntries($VALUES);
        }
    }
}

