/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal;

import java.util.Arrays;
import top.fifthlight.touchcontroller.relocated.kotlin.Lazy;
import top.fifthlight.touchcontroller.relocated.kotlin.LazyKt__LazyJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.KSerializer;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.SerializationException;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.encoding.Decoder;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.encoding.Encoder;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal.EnumDescriptor;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal.PluginGeneratedSerialDescriptor;

public final class EnumSerializer
implements KSerializer {
    public final Enum[] values;
    public SerialDescriptor overriddenDescriptor;
    public final Lazy descriptor$delegate;

    public EnumSerializer(String string, Enum[] enumArray) {
        Intrinsics.checkNotNullParameter(string, "serialName");
        Intrinsics.checkNotNullParameter(enumArray, "values");
        this.values = enumArray;
        this.descriptor$delegate = LazyKt__LazyJVMKt.lazy(() -> EnumSerializer.descriptor_delegate$lambda$0(this, string));
    }

    public EnumSerializer(String string, Enum[] enumArray, SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter(string, "serialName");
        Intrinsics.checkNotNullParameter(enumArray, "values");
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        this(string, enumArray);
        this.overriddenDescriptor = serialDescriptor;
    }

    public static final SerialDescriptor descriptor_delegate$lambda$0(EnumSerializer enumSerializer, String string) {
        SerialDescriptor serialDescriptor = enumSerializer.overriddenDescriptor;
        if (serialDescriptor == null) {
            serialDescriptor = enumSerializer.createUnmarkedDescriptor(string);
        }
        return serialDescriptor;
    }

    @Override
    public SerialDescriptor getDescriptor() {
        return (SerialDescriptor)this.descriptor$delegate.getValue();
    }

    public void serialize(Encoder encoder, Enum enum_) {
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(enum_, "value");
        int n = ArraysKt___ArraysKt.indexOf(this.values, enum_);
        if (n != -1) {
            encoder.encodeEnum(this.getDescriptor(), n);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append(enum_).append(" is not a valid enum ").append(this.getDescriptor().getSerialName()).append(", must be one of ");
        String string = Arrays.toString(this.values);
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        throw new SerializationException(stringBuilder.append(string).toString());
    }

    @Override
    public Enum deserialize(Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        int n = decoder.decodeEnum(this.getDescriptor());
        if (n >= 0) {
            Enum[] enumArray = this.values;
            if (n < this.values.length) {
                return enumArray[n];
            }
        }
        throw new SerializationException(n + " is not among valid " + this.getDescriptor().getSerialName() + " enum values, values size is " + this.values.length);
    }

    public String toString() {
        return "kotlinx.serialization.internal.EnumSerializer<" + this.getDescriptor().getSerialName() + '>';
    }

    public final SerialDescriptor createUnmarkedDescriptor(String string) {
        EnumDescriptor enumDescriptor;
        EnumDescriptor enumDescriptor2 = enumDescriptor;
        enumDescriptor = new EnumDescriptor(string, enumArray.values.length);
        Enum[] enumArray = enumArray.values;
        int n = enumArray.values.length;
        for (int i = 0; i < n; ++i) {
            PluginGeneratedSerialDescriptor.addElement$default(enumDescriptor2, enumArray[i].name(), false, 2, null);
        }
        return enumDescriptor2;
    }
}

