/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.event;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.touchcontroller.common.config.ControllerLayout;
import top.fifthlight.touchcontroller.common.config.GlobalConfig;
import top.fifthlight.touchcontroller.common.config.GlobalConfigHolder;
import top.fifthlight.touchcontroller.common.config.condition.BuiltinLayerConditionKey;
import top.fifthlight.touchcontroller.common.config.preset.LayoutPreset;
import top.fifthlight.touchcontroller.common.config.preset.PresetControlInfo;
import top.fifthlight.touchcontroller.common.event.RenderEvents$special$;
import top.fifthlight.touchcontroller.common.event.WindowEvents;
import top.fifthlight.touchcontroller.common.gal.CameraPerspective;
import top.fifthlight.touchcontroller.common.gal.CrosshairTarget;
import top.fifthlight.touchcontroller.common.gal.DefaultKeyBindingType;
import top.fifthlight.touchcontroller.common.gal.GameState;
import top.fifthlight.touchcontroller.common.gal.GameStateProvider;
import top.fifthlight.touchcontroller.common.gal.KeyBindingHandler;
import top.fifthlight.touchcontroller.common.gal.PlayerHandle;
import top.fifthlight.touchcontroller.common.gal.PlayerHandleFactory;
import top.fifthlight.touchcontroller.common.gal.RidingEntityType;
import top.fifthlight.touchcontroller.common.gal.ViewActionProvider;
import top.fifthlight.touchcontroller.common.gal.WindowHandle;
import top.fifthlight.touchcontroller.common.helper.OffsetHelperKt;
import top.fifthlight.touchcontroller.common.input.InputManager;
import top.fifthlight.touchcontroller.common.layout.Context;
import top.fifthlight.touchcontroller.common.layout.ContextInput;
import top.fifthlight.touchcontroller.common.layout.ContextResult;
import top.fifthlight.touchcontroller.common.layout.ContextStatus;
import top.fifthlight.touchcontroller.common.layout.ContextTimer;
import top.fifthlight.touchcontroller.common.layout.DrawQueue;
import top.fifthlight.touchcontroller.common.layout.HudKt;
import top.fifthlight.touchcontroller.common.layout.InventorySlotStatus;
import top.fifthlight.touchcontroller.common.model.ControllerHudModel;
import top.fifthlight.touchcontroller.common.model.TouchStateModel;
import top.fifthlight.touchcontroller.common.platform.PlatformProvider;
import top.fifthlight.touchcontroller.proxy.client.PlatformCapability;
import top.fifthlight.touchcontroller.proxy.message.AddPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.CapabilityMessage;
import top.fifthlight.touchcontroller.proxy.message.ClearPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.InputStatusMessage;
import top.fifthlight.touchcontroller.proxy.message.MoveViewMessage;
import top.fifthlight.touchcontroller.proxy.message.RemovePointerMessage;
import top.fifthlight.touchcontroller.proxy.message.VibrateMessage;
import top.fifthlight.touchcontroller.relocated.kotlin.Lazy;
import top.fifthlight.touchcontroller.relocated.kotlin.LazyKt__LazyJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.SetsKt__SetsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function0;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function2;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Reflection;
import top.fifthlight.touchcontroller.relocated.kotlin.uuid.Uuid;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.ExtensionsKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.PersistentSet;
import top.fifthlight.touchcontroller.relocated.org.koin.core.Koin;
import top.fifthlight.touchcontroller.relocated.org.koin.core.component.KoinComponent;
import top.fifthlight.touchcontroller.relocated.org.koin.core.qualifier.Qualifier;
import top.fifthlight.touchcontroller.relocated.org.koin.mp.KoinPlatformTools;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.input.TextInputState;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.input.TextRange;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.paint.Canvas;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntOffset;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntSize;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.Offset;

public final class RenderEvents
implements KoinComponent {
    public static final RenderEvents INSTANCE;
    public static final Logger logger;
    public static final Lazy window$delegate;
    public static final Lazy configHolder$delegate;
    public static final Lazy controllerHudModel$delegate;
    public static final Lazy touchStateModel$delegate;
    public static final Lazy playerHandleFactory$delegate;
    public static final Lazy platformProvider$delegate;
    public static final Lazy gameStateProvider$delegate;
    public static final Lazy keyBindingHandler$delegate;
    public static final Lazy viewActionProvider$delegate;
    public static int prevWidth;
    public static int prevHeight;
    public static final Set _platformCapabilities;
    public static final Set platformCapabilities;
    public static final int $stable;

    private final ControllerHudModel getControllerHudModel() {
        return (ControllerHudModel)controllerHudModel$delegate.getValue();
    }

    private final PlatformProvider getPlatformProvider() {
        return (PlatformProvider)platformProvider$delegate.getValue();
    }

    private final KeyBindingHandler getKeyBindingHandler() {
        return (KeyBindingHandler)keyBindingHandler$delegate.getValue();
    }

    public static final void onRenderStart() {
        ContextInput contextInput;
        DrawQueue drawQueue;
        Object object;
        Object object2;
        Object object3 = INSTANCE;
        ((RenderEvents)object3).getControllerHudModel().getTimer().renderTick();
        ((RenderEvents)object3).getKeyBindingHandler().renderTick(((RenderEvents)object3).getControllerHudModel().getTimer().getRenderTick());
        if (((RenderEvents)object3).getControllerHudModel().getStatus().getVibrate()) {
            object2 = ((RenderEvents)object3).getPlatformProvider().getPlatform();
            if (object2 != null) {
                object2.sendEvent(new VibrateMessage(VibrateMessage.Kind.BLOCK_BROKEN));
            }
            ((RenderEvents)object3).getControllerHudModel().getStatus().setVibrate(false);
        }
        RenderEvents renderEvents = object3;
        object3 = (GlobalConfig)renderEvents.getConfigHolder().getConfig().getValue();
        object2 = renderEvents.getPlayerHandleFactory().getPlayerHandle();
        Object object4 = renderEvents.getGameStateProvider().currentState();
        Object object5 = renderEvents.getPlatformProvider().getPlatform();
        if (object5 != null) {
            while (true) {
                WindowEvents windowEvents = WindowEvents.INSTANCE;
                int n = windowEvents.getWindowWidth();
                int n2 = windowEvents.getWindowHeight();
                if (n != prevWidth || n2 != prevHeight) {
                    prevWidth = n;
                    prevHeight = n2;
                    object5.resize(n, n2);
                }
                if ((object = object5.pollEvent()) == null) break;
                if (object instanceof AddPointerMessage) {
                    AddPointerMessage addPointerMessage = (AddPointerMessage)object;
                    int n3 = addPointerMessage.getIndex();
                    float f = addPointerMessage.getX();
                    float f2 = addPointerMessage.getY();
                    long l = Float.floatToRawIntBits(f2);
                    INSTANCE.getTouchStateModel().addPointer-_0sKWyo(n3, Offset.constructor-impl((long)Float.floatToRawIntBits(f) << 32 | l & 0xFFFFFFFFL));
                    continue;
                }
                if (object instanceof RemovePointerMessage) {
                    INSTANCE.getTouchStateModel().removePointer(((RemovePointerMessage)object).getIndex());
                    continue;
                }
                if (Intrinsics.areEqual(object, ClearPointerMessage.INSTANCE)) {
                    INSTANCE.getTouchStateModel().clearPointer();
                    continue;
                }
                if (object instanceof CapabilityMessage) {
                    Object var6_30;
                    block29: {
                        for (Object t : PlatformCapability.getEntries()) {
                            var6_30 = t;
                            if (!Intrinsics.areEqual(((PlatformCapability)((Object)t)).getId(), ((CapabilityMessage)object).getCapability())) continue;
                            break block29;
                        }
                        var6_30 = null;
                    }
                    Object object6 = var6_30;
                    if (object6 != null) {
                        object = (CapabilityMessage)object;
                        logger.info("TouchController capability " + ((CapabilityMessage)object).getCapability() + " set to " + ((CapabilityMessage)object).getEnabled());
                        if (((CapabilityMessage)object).getEnabled()) {
                            ((Collection)_platformCapabilities).add(object6);
                            continue;
                        }
                        ((Collection)_platformCapabilities).remove(object6);
                        continue;
                    }
                    logger.warn("Unknown capability: " + ((CapabilityMessage)object).getCapability() + ", maybe you should update TouchController?");
                    continue;
                }
                if (object instanceof InputStatusMessage) {
                    TextRange textRange;
                    TextRange textRange2;
                    if ((object = ((InputStatusMessage)object).getStatus()) == null) continue;
                    Object object7 = object;
                    String string = ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object7).getText();
                    TextRange textRange3 = textRange2;
                    textRange2 = new TextRange(((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object).getComposition().getStart(), ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object).getComposition().getLength());
                    TextRange textRange4 = textRange;
                    textRange = new TextRange(((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object).getSelection().getStart(), ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object).getSelection().getLength());
                    boolean bl = ((top.fifthlight.touchcontroller.proxy.message.input.TextInputState)object7).getSelectionLeft();
                    InputManager.INSTANCE.updateNativeState(new TextInputState(string, textRange3, textRange4, bl));
                    continue;
                }
                if (!(object instanceof MoveViewMessage) || object2 == null) continue;
                MoveViewMessage moveViewMessage = (MoveViewMessage)object;
                float f = moveViewMessage.getDeltaYaw();
                float f3 = moveViewMessage.getDeltaPitch();
                long l = Float.floatToRawIntBits(f3);
                l = Offset.constructor-impl((long)Float.floatToRawIntBits(f) << 32 | l & 0xFFFFFFFFL);
                if (moveViewMessage.getScreenBased()) {
                    l = Offset.times-oOeltVE(OffsetHelperKt.fixAspectRadio-5vxnuq4(l, INSTANCE.getWindow().getSize-KlICH20()), ((GlobalConfig)object3).getControl().getViewMovementSensitivity());
                }
                long l2 = l;
                double d = Offset.getX-impl(l2);
                double d2 = Offset.getY-impl(l2);
                object2.changeLookDirection(d, d2);
            }
        }
        if (((GlobalConfig)object3).getDebug().getEnableTouchEmulation()) {
            object3 = INSTANCE;
            object5 = ((RenderEvents)object3).getWindow().getMousePosition-sHUuaow();
            if (((RenderEvents)object3).getWindow().getMouseLeftPressed() && object5 != null) {
                long l = Offset.div-JopVrvY(((Offset)object5).unbox-impl(), IntSize.toSize-2DEOzdI(((RenderEvents)object3).getWindow().getSize-KlICH20()));
                ((RenderEvents)object3).getTouchStateModel().addPointer-_0sKWyo(0, l);
            } else {
                ((RenderEvents)object3).getTouchStateModel().clearPointer();
            }
        }
        if (!((GameState)object4).getInGame()) {
            return;
        }
        if (((GameState)object4).getInGui()) {
            INSTANCE.getTouchStateModel().clearPointer();
        }
        if (object2 == null) {
            return;
        }
        if (object2.isFlying() || object2.isSubmergedInWater()) {
            INSTANCE.getKeyBindingHandler().getState(DefaultKeyBindingType.SNEAK).clearLock();
        }
        object3 = INSTANCE;
        object5 = (LayoutPreset)((RenderEvents)object3).getConfigHolder().getCurrentPreset().getValue();
        object = (Uuid)((RenderEvents)object3).getConfigHolder().getCurrentPresetUuid().getValue();
        if (!Intrinsics.areEqual(((RenderEvents)object3).getControllerHudModel().getStatus().getPreviousPresetUuid(), object)) {
            Iterator iterator2 = object3;
            super.getControllerHudModel().getStatus().setPreviousPresetUuid((Uuid)object);
            super.getControllerHudModel().getStatus().getEnabledCustomConditions().clear();
        }
        object = object2.getRidingEntityType();
        Set set = SetsKt__SetsJVMKt.createSetBuilder();
        RenderEvents.onRenderStart$lambda$5$put(set, BuiltinLayerConditionKey.Key.FLYING, object2.isFlying());
        RenderEvents.onRenderStart$lambda$5$put(set, BuiltinLayerConditionKey.Key.CAN_FLY, object2.getCanFly());
        RenderEvents.onRenderStart$lambda$5$put(set, BuiltinLayerConditionKey.Key.SWIMMING, object2.isTouchingWater());
        RenderEvents.onRenderStart$lambda$5$put(set, BuiltinLayerConditionKey.Key.UNDERWATER, object2.isSubmergedInWater());
        RenderEvents.onRenderStart$lambda$5$put(set, BuiltinLayerConditionKey.Key.SPRINTING, object2.isSprinting());
        RenderEvents.onRenderStart$lambda$5$put(set, BuiltinLayerConditionKey.Key.SNEAKING, object2.isSneaking());
        RenderEvents.onRenderStart$lambda$5$put(set, BuiltinLayerConditionKey.Key.ON_GROUND, object2.getOnGround());
        RenderEvents.onRenderStart$lambda$5$put(set, BuiltinLayerConditionKey.Key.NOT_ON_GROUND, object2.getOnGround() ^ true);
        RenderEvents.onRenderStart$lambda$5$put(set, BuiltinLayerConditionKey.Key.USING_ITEM, object2.isUsingItem());
        BuiltinLayerConditionKey.Key key = BuiltinLayerConditionKey.Key.RIDING;
        boolean bl = object != null;
        RenderEvents.onRenderStart$lambda$5$put(set, key, bl);
        key = BuiltinLayerConditionKey.Key.BLOCK_SELECTED;
        bl = ((RenderEvents)object3).getViewActionProvider().getCrosshairTarget() == CrosshairTarget.BLOCK;
        RenderEvents.onRenderStart$lambda$5$put(set, key, bl);
        key = BuiltinLayerConditionKey.Key.ON_MINECART;
        bl = object == RidingEntityType.MINECART;
        RenderEvents.onRenderStart$lambda$5$put(set, key, bl);
        key = BuiltinLayerConditionKey.Key.ON_BOAT;
        bl = object == RidingEntityType.BOAT;
        RenderEvents.onRenderStart$lambda$5$put(set, key, bl);
        key = BuiltinLayerConditionKey.Key.ON_PIG;
        bl = object == RidingEntityType.PIG;
        RenderEvents.onRenderStart$lambda$5$put(set, key, bl);
        key = BuiltinLayerConditionKey.Key.ON_HORSE;
        bl = object == RidingEntityType.HORSE;
        RenderEvents.onRenderStart$lambda$5$put(set, key, bl);
        key = BuiltinLayerConditionKey.Key.ON_CAMEL;
        bl = object == RidingEntityType.CAMEL;
        RenderEvents.onRenderStart$lambda$5$put(set, key, bl);
        key = BuiltinLayerConditionKey.Key.ON_LLAMA;
        bl = object == RidingEntityType.LLAMA;
        Object object8 = object;
        RenderEvents.onRenderStart$lambda$5$put(set, key, bl);
        object = BuiltinLayerConditionKey.Key.ON_STRIDER;
        int n = object8 == RidingEntityType.STRIDER ? 1 : 0;
        Iterator iterator3 = object3;
        GameState gameState = object4;
        GameState gameState2 = object4;
        Iterator iterator4 = object3;
        Set set2 = set;
        RenderEvents.onRenderStart$lambda$5$put(set2, (BuiltinLayerConditionKey.Key)((Object)object), n != 0);
        object4 = ExtensionsKt.toPersistentSet(SetsKt__SetsJVMKt.build(set2));
        object = drawQueue;
        drawQueue = new DrawQueue();
        long l = ((RenderEvents)((Object)iterator4)).getWindow().getSize-KlICH20();
        long l3 = ((RenderEvents)((Object)iterator4)).getWindow().getScaledSize-KlICH20();
        long l4 = ((RenderEvents)((Object)iterator4)).getWindow().getScaledSize-KlICH20();
        long l5 = IntOffset.Companion.getZERO-ITD3_cg();
        HashMap hashMap = ((RenderEvents)((Object)iterator4)).getTouchStateModel().getPointers();
        boolean bl2 = gameState2.getInGui();
        Object object9 = ExtensionsKt.toPersistentSet(super.getControllerHudModel().getStatus().getEnabledCustomConditions());
        Object object10 = gameState.getPerspective();
        ContextInput contextInput2 = contextInput;
        contextInput = new ContextInput(bl2, (PersistentSet)object4, (PersistentSet)object9, (PlayerHandle)object2, null, (CameraPerspective)((Object)object10), 16, null);
        object4 = super.getControllerHudModel().getStatus();
        ContextTimer contextTimer = super.getControllerHudModel().getTimer();
        object9 = super.getKeyBindingHandler();
        object10 = (GlobalConfig)((RenderEvents)((Object)iterator3)).getConfigHolder().getConfig().getValue();
        PresetControlInfo presetControlInfo = ((LayoutPreset)object5).getControlInfo();
        Context context = new Context(l, l3, (DrawQueue)object, l4, l5, 0.0f, hashMap, contextInput2, null, (ContextStatus)object4, (KeyBindingHandler)object9, contextTimer, (GlobalConfig)object10, presetControlInfo, 288, null);
        HudKt.Hud(context, ControllerLayout.box-impl(((LayoutPreset)object5).getLayout-HWbCNyc()));
        object4 = context.getResult();
        Iterator iterator5 = object3;
        super.getControllerHudModel().setResult((ContextResult)object4);
        super.getControllerHudModel().setPendingDrawQueue((DrawQueue)object);
        super.getControllerHudModel().getStatus().getDoubleClickCounter().clean(super.getControllerHudModel().getTimer().getClientTick());
        object3 = ((ContextResult)object4).getPendingAction().iterator();
        while (object3.hasNext()) {
            ((Function2)object3.next()).invoke(INSTANCE.getControllerHudModel().getTimer(), object2);
        }
        object3 = ((ContextResult)object4).getLookDirection-sHUuaow();
        if (object3 != null) {
            long l6 = ((Offset)object3).unbox-impl();
            float f = Offset.component1-impl(l6);
            double d = f;
            double d3 = Offset.component2-impl(l6);
            object2.changeLookDirection(d, d3);
        }
        InventorySlotStatus[] inventorySlotStatusArray = ((ContextResult)object4).getInventory().getSlots();
        int n4 = 0;
        for (InventorySlotStatus inventorySlotStatus : inventorySlotStatusArray) {
            n = n4 + 1;
            if (inventorySlotStatus.getSelect()) {
                object2.setCurrentSelectedSlot(n4);
            }
            if (inventorySlotStatus.getDrop()) {
                if (object2.getInventorySlot(n4).isEmpty()) {
                    object2.setCurrentSelectedSlot(n4);
                } else {
                    object2.dropSlot(n4);
                }
            }
            n4 = n;
        }
    }

    public static final void onRenderStart$lambda$5$put(Set set, BuiltinLayerConditionKey.Key key, boolean bl) {
        if (bl) {
            set.add(key);
        }
    }

    static {
        RenderEvents renderEvents;
        RenderEvents renderEvents2 = renderEvents;
        INSTANCE = new RenderEvents();
        logger = LoggerFactory.getLogger(RenderEvents.class);
        KoinPlatformTools koinPlatformTools = KoinPlatformTools.INSTANCE;
        window$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$1 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(WindowHandle.class), qualifier, function0);
            }
        });
        configHolder$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$2 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GlobalConfigHolder.class), qualifier, function0);
            }
        });
        controllerHudModel$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$3 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ControllerHudModel.class), qualifier, function0);
            }
        });
        touchStateModel$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$4 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(TouchStateModel.class), qualifier, function0);
            }
        });
        playerHandleFactory$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$5 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PlayerHandleFactory.class), qualifier, function0);
            }
        });
        platformProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$6 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PlatformProvider.class), qualifier, function0);
            }
        });
        gameStateProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$7 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GameStateProvider.class), qualifier, function0);
            }
        });
        keyBindingHandler$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$8 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(KeyBindingHandler.class), qualifier, function0);
            }
        });
        viewActionProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$9 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ViewActionProvider.class), qualifier, function0);
            }
        });
        _platformCapabilities = new LinkedHashSet();
        Set set = Collections.unmodifiableSet(_platformCapabilities);
        Intrinsics.checkNotNullExpressionValue(set, "unmodifiableSet(...)");
        platformCapabilities = set;
        $stable = 8;
    }

    public final Set getPlatformCapabilities() {
        return platformCapabilities;
    }

    public final void onHudRender(Canvas canvas) {
        Intrinsics.checkNotNullParameter(canvas, "canvas");
        DrawQueue drawQueue = ((RenderEvents)((Object)drawQueue)).getControllerHudModel().getPendingDrawQueue();
        if (drawQueue != null) {
            drawQueue.execute(canvas);
            INSTANCE.getControllerHudModel().setPendingDrawQueue(null);
        }
    }

    public final boolean shouldRenderCrosshair() {
        RenderEvents renderEvents = this;
        GlobalConfig globalConfig = (GlobalConfig)renderEvents.getConfigHolder().getConfig().getValue();
        if (!((LayoutPreset)renderEvents.getConfigHolder().getCurrentPreset().getValue()).getControlInfo().getDisableCrosshair()) {
            return true;
        }
        if ((this = ((RenderEvents)this).getPlayerHandleFactory().getPlayerHandle()) == null) {
            return false;
        }
        return this.hasItemsOnHand(globalConfig.getItem().getShowCrosshairItems());
    }

    @Override
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    public final WindowHandle getWindow() {
        return (WindowHandle)window$delegate.getValue();
    }

    public final GlobalConfigHolder getConfigHolder() {
        return (GlobalConfigHolder)configHolder$delegate.getValue();
    }

    public final TouchStateModel getTouchStateModel() {
        return (TouchStateModel)touchStateModel$delegate.getValue();
    }

    public final PlayerHandleFactory getPlayerHandleFactory() {
        return (PlayerHandleFactory)playerHandleFactory$delegate.getValue();
    }

    public final GameStateProvider getGameStateProvider() {
        return (GameStateProvider)gameStateProvider$delegate.getValue();
    }

    public final ViewActionProvider getViewActionProvider() {
        return (ViewActionProvider)viewActionProvider$delegate.getValue();
    }
}

