/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.RandomAccess;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.AbstractCollection;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.AbstractIterator;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.AbstractList;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysJvmKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.CollectionsKt__CollectionsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.RingBuffer;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.markers.KMappedMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;

public final class RingBuffer
extends AbstractList
implements RandomAccess {
    public final Object[] buffer;
    public final int capacity;
    public int startIndex;
    public int size;

    public RingBuffer(Object[] object, int n) {
        Intrinsics.checkNotNullParameter(object, "buffer");
        this.buffer = object;
        if (n >= 0) {
            if (n <= ((Object[])object).length) {
                this.capacity = ((Object[])object).length;
                this.size = n;
                return;
            }
            object = "ring buffer filled size: " + n + " cannot be larger than the buffer size: " + ((Object)object).length;
            throw new IllegalArgumentException(object.toString());
        }
        object = "ring buffer filled size should not be negative but it is " + n;
        throw new IllegalArgumentException(object.toString());
    }

    public RingBuffer(int n) {
        this(new Object[n], 0);
    }

    public static final /* synthetic */ int access$getStartIndex$p(RingBuffer ringBuffer) {
        return ringBuffer.startIndex;
    }

    public static final /* synthetic */ Object[] access$getBuffer$p(RingBuffer ringBuffer) {
        return ringBuffer.buffer;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Object get(int n) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.size());
        return this.buffer[(this.startIndex + n) % this.capacity];
    }

    public final boolean isFull() {
        return this.size() == this.capacity;
    }

    @Override
    public Iterator iterator() {
        return new AbstractIterator(this){
            public int count;
            public int index;
            public final /* synthetic */ RingBuffer this$0;
            {
                this.this$0 = ringBuffer;
                this.count = ringBuffer.size();
                this.index = RingBuffer.access$getStartIndex$p(ringBuffer);
            }

            public void computeNext() {
                if (kMappedMarker.count == 0) {
                    kMappedMarker.done();
                } else {
                    iterator.1 v0 = kMappedMarker;
                    v0.setNext(RingBuffer.access$getBuffer$p(v0.this$0)[kMappedMarker.index]);
                    KMappedMarker kMappedMarker = v0.this$0;
                    v0.index = (v0.index + 1) % RingBuffer.access$getCapacity$p((RingBuffer)kMappedMarker);
                    v0.count += -1;
                }
            }
        };
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        int n;
        Intrinsics.checkNotNullParameter(objectArray, "array");
        if (objectArray.length < this.size()) {
            objectArray = Arrays.copyOf(objectArray, this.size());
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        }
        int n2 = this.size();
        int n3 = 0;
        for (n = (v268551).startIndex; n3 < n2 && n < this.capacity; ++n3, ++n) {
            objectArray[n3] = this.buffer[n];
        }
        n = 0;
        while (n3 < n2) {
            objectArray[n3] = this.buffer[n];
            ++n3;
            ++n;
        }
        return CollectionsKt__CollectionsJVMKt.terminateCollectionToArray(n2, objectArray);
    }

    @Override
    public Object[] toArray() {
        RingBuffer ringBuffer = this;
        return ringBuffer.toArray(new Object[ringBuffer.size()]);
    }

    public final RingBuffer expanded(int n) {
        Object[] objectArray;
        RingBuffer ringBuffer = this;
        int n2 = ringBuffer.capacity;
        n = RangesKt___RangesKt.coerceAtMost(n2 + (n2 >> 1) + 1, n);
        if (ringBuffer.startIndex == 0) {
            objectArray = Arrays.copyOf(this.buffer, n);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        } else {
            objectArray = this.toArray(new Object[n]);
        }
        return new RingBuffer(objectArray, this.size());
    }

    public final void add(Object object) {
        if (!this.isFull()) {
            RingBuffer ringBuffer = this;
            ringBuffer.buffer[(this.startIndex + this.size()) % ((RingBuffer)this).capacity] = object;
            ringBuffer.size = ringBuffer.size() + 1;
            return;
        }
        throw new IllegalStateException("ring buffer is full");
    }

    public final void removeFirst(int n) {
        Object object;
        if (n >= 0) {
            if (n <= ((AbstractCollection)object).size()) {
                if (n > 0) {
                    int n2 = ((RingBuffer)object).startIndex;
                    int n3 = (n2 + n) % ((RingBuffer)object).capacity;
                    if (n2 > n3) {
                        Object object2 = object;
                        int n4 = ((RingBuffer)object).capacity;
                        ArraysKt___ArraysJvmKt.fill(((RingBuffer)object2).buffer, null, n2, n4);
                        ArraysKt___ArraysJvmKt.fill(((RingBuffer)object2).buffer, null, 0, n3);
                    } else {
                        ArraysKt___ArraysJvmKt.fill(((RingBuffer)object).buffer, null, n2, n3);
                    }
                    ((RingBuffer)object).startIndex = n3;
                    ((RingBuffer)object).size = ((AbstractCollection)object).size() - n;
                }
                return;
            }
            object = "n shouldn't be greater than the buffer size: n = " + n + ", size = " + ((AbstractCollection)object).size();
            throw new IllegalArgumentException(object.toString());
        }
        object = "n shouldn't be negative but it is " + n;
        throw new IllegalArgumentException(object.toString());
    }
}

