/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.FloatRect;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class InputAreaMessage
extends ProxyMessage {
    public final FloatRect inputAreaRect;
    public final int type;

    public InputAreaMessage(FloatRect floatRect) {
        super(null);
        this.inputAreaRect = floatRect;
        this.type = 11;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        InputAreaMessage inputAreaMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        if (inputAreaMessage.inputAreaRect != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putFloat(this.inputAreaRect.getLeft());
            byteBuffer.putFloat(this.inputAreaRect.getTop());
            byteBuffer.putFloat(this.inputAreaRect.getWidth());
            byteBuffer.putFloat(this.inputAreaRect.getHeight());
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public String toString() {
        return "InputAreaMessage(inputAreaRect=" + this.inputAreaRect + ')';
    }

    public int hashCode() {
        FloatRect floatRect = ((InputAreaMessage)((Object)floatRect)).inputAreaRect;
        return floatRect == null ? 0 : floatRect.hashCode();
    }

    public boolean equals(Object object) {
        if (inputAreaMessage2 == object) {
            return true;
        }
        if (!(object instanceof InputAreaMessage)) {
            return false;
        }
        InputAreaMessage inputAreaMessage = inputAreaMessage2;
        InputAreaMessage inputAreaMessage2 = (InputAreaMessage)object;
        return Intrinsics.areEqual(inputAreaMessage.inputAreaRect, inputAreaMessage2.inputAreaRect);
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public InputAreaMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() >= 1) {
                if (byteBuffer.get() != 0) {
                    if (byteBuffer.remaining() == 16) {
                        FloatRect floatRect;
                        FloatRect floatRect2 = floatRect;
                        ByteBuffer byteBuffer3 = byteBuffer;
                        float f = byteBuffer3.getFloat();
                        float f2 = byteBuffer3.getFloat();
                        float f3 = byteBuffer3.getFloat();
                        float f4 = byteBuffer3.getFloat();
                        floatRect = new FloatRect(f, f2, f3, f4);
                        return new InputAreaMessage(floatRect2);
                    }
                    throw new BadMessageLengthException(16, byteBuffer.remaining());
                }
                return new InputAreaMessage(null);
            }
            throw new BadMessageLengthException(1, byteBuffer.remaining());
        }
    }
}

