/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.scheduling;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Ref$ObjectRef;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.DebugKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.scheduling.GlobalQueue;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.scheduling.Task;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.scheduling.TasksKt;

public final class WorkQueue {
    public static final /* synthetic */ AtomicReferenceFieldUpdater lastScheduledTask$volatile$FU;
    public static final /* synthetic */ AtomicIntegerFieldUpdater producerIndex$volatile$FU;
    public static final /* synthetic */ AtomicIntegerFieldUpdater consumerIndex$volatile$FU;
    public static final /* synthetic */ AtomicIntegerFieldUpdater blockingTasksInBuffer$volatile$FU;
    public final AtomicReferenceArray buffer;
    private volatile /* synthetic */ Object lastScheduledTask$volatile;
    private volatile /* synthetic */ int producerIndex$volatile;
    private volatile /* synthetic */ int consumerIndex$volatile;
    private volatile /* synthetic */ int blockingTasksInBuffer$volatile;

    public WorkQueue() {
        AtomicReferenceArray atomicReferenceArray;
        AtomicReferenceArray atomicReferenceArray2 = atomicReferenceArray;
        atomicReferenceArray = new AtomicReferenceArray(128);
        v1.buffer = atomicReferenceArray2;
    }

    public final int getBufferSize() {
        return WorkQueue.producerIndex$volatile$FU.get(this) - WorkQueue.consumerIndex$volatile$FU.get(this);
    }

    public final Task addLast(Task task) {
        if (this.getBufferSize() == 127) {
            return task;
        }
        if (task.taskContext) {
            WorkQueue.blockingTasksInBuffer$volatile$FU.incrementAndGet(this);
        }
        int n = WorkQueue.producerIndex$volatile$FU.get(this) & 0x7F;
        while (this.buffer.get(n) != null) {
            Thread.yield();
        }
        this.buffer.lazySet(n, task);
        WorkQueue.producerIndex$volatile$FU.incrementAndGet(this);
        return null;
    }

    public final Task stealWithExclusiveMode(int n) {
        int n2 = n;
        n = WorkQueue.consumerIndex$volatile$FU.get(this);
        int n3 = WorkQueue.producerIndex$volatile$FU.get(this);
        boolean bl = n2 == 1;
        while (n != n3) {
            if (bl && WorkQueue.blockingTasksInBuffer$volatile$FU.get(this) == 0) {
                return null;
            }
            int n4 = n + 1;
            Task task = this.tryExtractFromTheMiddle(n, bl);
            if (task == null) {
                n = n4;
                continue;
            }
            return task;
        }
        return null;
    }

    public final Task pollWithExclusiveMode(boolean bl) {
        Task task;
        while ((task = (Task)WorkQueue.lastScheduledTask$volatile$FU.get(this)) != null && task.taskContext == bl) {
            if (!WorkQueue.lastScheduledTask$volatile$FU.compareAndSet(this, task, null)) continue;
            return task;
        }
        int n = WorkQueue.consumerIndex$volatile$FU.get(this);
        int n2 = WorkQueue.producerIndex$volatile$FU.get(this);
        while (n != n2) {
            if (bl && WorkQueue.blockingTasksInBuffer$volatile$FU.get(this) == 0) {
                return null;
            }
            Task task2 = this.tryExtractFromTheMiddle(n2 += -1, bl);
            if (task2 == null) continue;
            return task2;
        }
        return null;
    }

    public final Task tryExtractFromTheMiddle(int n, boolean bl) {
        Task task = (Task)this.buffer.get(n &= 0x7F);
        if (task != null && task.taskContext == bl && this.buffer.compareAndSet(n, task, null)) {
            if (bl) {
                WorkQueue.blockingTasksInBuffer$volatile$FU.decrementAndGet(this);
            }
            return task;
        }
        return null;
    }

    public final long tryStealLastScheduled(int n, Ref$ObjectRef ref$ObjectRef) {
        Task task;
        do {
            long l;
            if ((task = (Task)WorkQueue.lastScheduledTask$volatile$FU.get(this)) == null) {
                return -2L;
            }
            if (((task.taskContext ? 1 : 2) & n) == 0) {
                return -2L;
            }
            long l2 = TasksKt.schedulerTimeSource.nanoTime() - task.submissionTime;
            if (l2 >= (l = TasksKt.WORK_STEALING_TIME_RESOLUTION_NS)) continue;
            return l - l2;
        } while (!WorkQueue.lastScheduledTask$volatile$FU.compareAndSet(this, task, null));
        ref$ObjectRef.element = task;
        return -1L;
    }

    public final boolean pollTo(GlobalQueue globalQueue) {
        if ((this = ((WorkQueue)this).pollBuffer()) == null) {
            return false;
        }
        globalQueue.addLast(this);
        return true;
    }

    public final Task pollBuffer() {
        int n;
        Task task;
        int n2;
        do {
            if ((n2 = WorkQueue.consumerIndex$volatile$FU.get(this)) - WorkQueue.producerIndex$volatile$FU.get(this) == 0) {
                return null;
            }
            n = n2 & 0x7F;
        } while (!WorkQueue.consumerIndex$volatile$FU.compareAndSet(this, n2, n2 + 1) || (task = (Task)this.buffer.getAndSet(n, null)) == null);
        this.decrementIfBlocking(task);
        return task;
    }

    public final void decrementIfBlocking(Task task) {
        if (task != null && task.taskContext) {
            int n = WorkQueue.blockingTasksInBuffer$volatile$FU.decrementAndGet(this);
            if (DebugKt.getASSERTIONS_ENABLED() && n < 0) {
                throw new AssertionError();
            }
        }
    }

    static {
        lastScheduledTask$volatile$FU = AtomicReferenceFieldUpdater.newUpdater(WorkQueue.class, Object.class, "lastScheduledTask$volatile");
        producerIndex$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "producerIndex$volatile");
        consumerIndex$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "consumerIndex$volatile");
        blockingTasksInBuffer$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "blockingTasksInBuffer$volatile");
    }

    public final int getSize$kotlinx_coroutines_core() {
        return WorkQueue.lastScheduledTask$volatile$FU.get(this) != null ? this.getBufferSize() + 1 : this.getBufferSize();
    }

    public final Task poll() {
        Task task = WorkQueue.lastScheduledTask$volatile$FU.getAndSet(this, null);
        if (task == null) {
            task = this.pollBuffer();
        }
        return task;
    }

    public final Task add(Task task, boolean bl) {
        if (bl) {
            return this.addLast(task);
        }
        task = WorkQueue.lastScheduledTask$volatile$FU.getAndSet(this, task);
        if (task == null) {
            return null;
        }
        return this.addLast(task);
    }

    public final long trySteal(int n, Ref$ObjectRef ref$ObjectRef) {
        Task task = n == 3 ? this.pollBuffer() : this.stealWithExclusiveMode(n);
        if (task != null) {
            ref$ObjectRef.element = task;
            return -1L;
        }
        return this.tryStealLastScheduled(n, ref$ObjectRef);
    }

    public final Task pollBlocking() {
        return this.pollWithExclusiveMode(true);
    }

    public final void offloadAllWorkTo(GlobalQueue globalQueue) {
        Task task = WorkQueue.lastScheduledTask$volatile$FU.getAndSet(this, null);
        if (task != null) {
            globalQueue.addLast(task);
        }
        while (this.pollTo(globalQueue)) {
        }
    }
}

