/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.platform.wayland;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.common.gal.NativeWindow;
import top.fifthlight.touchcontroller.common.platform.Platform;
import top.fifthlight.touchcontroller.common.platform.wayland.Interface;
import top.fifthlight.touchcontroller.proxy.message.MessageDecodeException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.org.slf4j.Logger;
import top.fifthlight.touchcontroller.relocated.org.slf4j.LoggerFactory;

public final class WaylandPlatform
implements Platform {
    public final Logger logger;
    public final byte[] readBuffer;
    public final byte[] sendBuffer;

    public WaylandPlatform(NativeWindow.Wayland wayland) {
        WaylandPlatform waylandPlatform = this;
        Intrinsics.checkNotNullParameter(wayland, "window");
        this.logger = LoggerFactory.getLogger(WaylandPlatform.class);
        Interface.init(wayland.getDisplayPointer(), wayland.getSurfacePointer());
        waylandPlatform.readBuffer = new byte[65536];
        waylandPlatform.sendBuffer = new byte[65536];
    }

    @Override
    public void resize(int n, int n2) {
        Interface.resize(n, n2);
    }

    @Override
    public ProxyMessage pollEvent() {
        Integer n = Interface.pollEvent(((WaylandPlatform)object).readBuffer);
        if (n == 0) {
            n = null;
        }
        if (n != null) {
            Object object;
            int n2 = n;
            ByteBuffer byteBuffer = ByteBuffer.wrap(((WaylandPlatform)object).readBuffer);
            ((Buffer)byteBuffer).limit(n2);
            if (byteBuffer.remaining() < 4) {
                return null;
            }
            try {
                Intrinsics.checkNotNull(byteBuffer);
                object = ProxyMessage.Companion.decode(byteBuffer.getInt(), byteBuffer);
            }
            catch (MessageDecodeException messageDecodeException) {
                ((WaylandPlatform)object).logger.warn("Bad message from native side: " + messageDecodeException);
                object = null;
            }
            return object;
        }
        return null;
    }

    @Override
    public void sendEvent(ProxyMessage proxyMessage) {
        Intrinsics.checkNotNullParameter(proxyMessage, "message");
        Object object = this = ByteBuffer.wrap(((WaylandPlatform)this).sendBuffer);
        Intrinsics.checkNotNull(object);
        proxyMessage.encode((ByteBuffer)object);
        byte[] byArray = ((ByteBuffer)this).array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        Interface.pushEvent(byArray, ((Buffer)this).position());
    }
}

