/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.gal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.touchcontroller.common.gal.NativeLibraryPathGetter;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class NativeLibraryPathGetterImpl
implements NativeLibraryPathGetter {
    public static final NativeLibraryPathGetterImpl INSTANCE = new NativeLibraryPathGetterImpl();
    public static final Logger logger = LoggerFactory.getLogger(NativeLibraryPathGetterImpl.class);

    @Override
    public InputStream getNativeLibraryPath(String string, Path path) {
        Intrinsics.checkNotNullParameter(string, "path");
        if (FMLEnvironment.production) {
            this = NativeLibraryPathGetterImpl.class.getClassLoader().getResourceAsStream(string);
            if (this == null) {
                logger.warn("Failed to get resource " + string);
                this = null;
            }
        } else {
            if (path != null) {
                int n = 0;
                this = Files.newInputStream(path, Arrays.copyOf(new OpenOption[0], n));
                try {
                    Intrinsics.checkNotNullExpressionValue(this, "newInputStream(...)");
                }
                catch (IOException iOException) {
                    logger.warn("Read debug library failed", (Throwable)iOException);
                    this = null;
                }
            } else {
                this = null;
            }
            if (this == null) {
                logger.warn("No debug library for your platform");
                this = null;
            }
        }
        return this;
    }
}

