/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.markers.KMappedMarker;

public abstract class AbstractIterator
implements Iterator,
KMappedMarker {
    public int state;
    public Object nextValue;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasNext() {
        int n = this.state;
        if (n != 0) {
            if (n == 1) return true;
            if (n != 2) throw new IllegalArgumentException("hasNext called when the iterator is in the FAILED state.");
            return false;
        }
        boolean bl = this.tryToComputeNext();
        return bl;
    }

    public Object next() {
        int n = this.state;
        if (n == 1) {
            this.state = 0;
            return this.nextValue;
        }
        if (n != 2 && this.tryToComputeNext()) {
            this.state = 0;
            return this.nextValue;
        }
        throw new NoSuchElementException();
    }

    public abstract void computeNext();

    public final void setNext(Object object) {
        AbstractIterator abstractIterator = this;
        abstractIterator.nextValue = object;
        abstractIterator.state = 1;
    }

    public final void done() {
        this.state = 2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public final boolean tryToComputeNext() {
        AbstractIterator abstractIterator = this;
        abstractIterator.state = 3;
        abstractIterator.computeNext();
        return abstractIterator.state == 1;
    }
}

