/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.internal;

import java.util.ArrayDeque;
import top.fifthlight.touchcontroller.relocated._COROUTINE.ArtificialStackFrames;
import top.fifthlight.touchcontroller.relocated._COROUTINE.CoroutineDebuggingKt;
import top.fifthlight.touchcontroller.relocated.kotlin.Pair;
import top.fifthlight.touchcontroller.relocated.kotlin.Result;
import top.fifthlight.touchcontroller.relocated.kotlin.ResultKt;
import top.fifthlight.touchcontroller.relocated.kotlin.TuplesKt;
import top.fifthlight.touchcontroller.relocated.kotlin.coroutines.jvm.internal.BaseContinuationImpl;
import top.fifthlight.touchcontroller.relocated.kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.DebugKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.internal.ExceptionsConstructorKt;

public abstract class StackTraceRecoveryKt {
    public static final StackTraceElement ARTIFICIAL_FRAME;
    public static final String baseContinuationImplClassName;
    public static final String stackTraceRecoveryClassName;

    public static final Throwable recoverStackTrace(Throwable throwable) {
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            return throwable;
        }
        Throwable throwable2 = ExceptionsConstructorKt.tryCopyException(throwable);
        if (throwable2 == null) {
            return throwable;
        }
        return StackTraceRecoveryKt.sanitizeStackTrace(throwable2);
    }

    public static final Throwable sanitizeStackTrace(Throwable throwable) {
        int n;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n2 = stackTraceElementArray.length;
        int n3 = stackTraceElementArray.length + -1;
        if (n3 >= 0) {
            while (true) {
                int n4 = n3;
                n = n4 + -1;
                if (!Intrinsics.areEqual(stackTraceRecoveryClassName, stackTraceElementArray[n4].getClassName())) {
                    if (n < 0) break;
                    n3 = n;
                    continue;
                }
                break;
            }
        } else {
            n3 = -1;
        }
        n = n3 + 1;
        int n5 = StackTraceRecoveryKt.firstFrameIndex(stackTraceElementArray, baseContinuationImplClassName);
        n5 = n5 == -1 ? 0 : n2 - n5;
        int n6 = n2;
        n3 = n6 - n3 - n5;
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            StackTraceElement stackTraceElement = n2 == 0 ? ARTIFICIAL_FRAME : stackTraceElementArray[n + n2 - 1];
            stackTraceElementArray2[n2] = stackTraceElement;
        }
        Throwable throwable2 = throwable;
        throwable2.setStackTrace(stackTraceElementArray2);
        return throwable2;
    }

    public static final Throwable recoverFromStackFrame(Throwable throwable, CoroutineStackFrame object) {
        StackTraceElement[] stackTraceElementArray = StackTraceRecoveryKt.causeAndStacktrace(throwable);
        Throwable throwable2 = (Throwable)stackTraceElementArray.component1();
        stackTraceElementArray = (StackTraceElement[])stackTraceElementArray.component2();
        Throwable throwable3 = ExceptionsConstructorKt.tryCopyException(throwable2);
        if (throwable3 == null) {
            return throwable;
        }
        if (((ArrayDeque)(object = StackTraceRecoveryKt.createStackTrace((CoroutineStackFrame)object))).isEmpty()) {
            return throwable;
        }
        if (throwable2 != throwable) {
            StackTraceRecoveryKt.mergeRecoveredTraces(stackTraceElementArray, (ArrayDeque)object);
        }
        return StackTraceRecoveryKt.createFinalException(throwable2, throwable3, (ArrayDeque)object);
    }

    public static final Throwable createFinalException(Throwable object, Throwable throwable, ArrayDeque arrayDeque) {
        arrayDeque.addFirst(ARTIFICIAL_FRAME);
        object = ((Throwable)object).getStackTrace();
        int n = StackTraceRecoveryKt.firstFrameIndex((StackTraceElement[])object, baseContinuationImplClassName);
        if (n == -1) {
            Throwable throwable2 = throwable;
            throwable2.setStackTrace(arrayDeque.toArray(new StackTraceElement[0]));
            return throwable2;
        }
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[arrayDeque.size() + n];
        for (int i = 0; i < n; ++i) {
            stackTraceElementArray[i] = object[i];
        }
        object = arrayDeque.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            StackTraceElement stackTraceElement;
            stackTraceElementArray[n + n2++] = stackTraceElement = (StackTraceElement)object.next();
        }
        Throwable throwable3 = throwable;
        throwable3.setStackTrace(stackTraceElementArray);
        return throwable3;
    }

    public static final Pair causeAndStacktrace(Throwable throwable) {
        Pair pair;
        block3: {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null && Intrinsics.areEqual(throwable2.getClass(), throwable.getClass())) {
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!StackTraceRecoveryKt.isArtificial(stackTraceElementArray[i])) continue;
                    pair = TuplesKt.to(throwable2, stackTraceElementArray);
                    break block3;
                }
                pair = TuplesKt.to(throwable, new StackTraceElement[0]);
            } else {
                pair = TuplesKt.to(throwable, new StackTraceElement[0]);
            }
        }
        return pair;
    }

    public static final void mergeRecoveredTraces(StackTraceElement[] stackTraceElementArray, ArrayDeque arrayDeque) {
        int n;
        int n2;
        block5: {
            n2 = stackTraceElementArray.length;
            for (n = 0; n < n2; ++n) {
                if (!StackTraceRecoveryKt.isArtificial(stackTraceElementArray[n])) {
                    continue;
                }
                break block5;
            }
            n = -1;
        }
        n2 = stackTraceElementArray.length - 1;
        if (++n <= n2) {
            while (true) {
                if (StackTraceRecoveryKt.elementWiseEquals(stackTraceElementArray[n2], (StackTraceElement)arrayDeque.getLast())) {
                    arrayDeque.removeLast();
                }
                arrayDeque.addFirst(stackTraceElementArray[n2]);
                if (n2 == n) break;
                --n2;
            }
        }
    }

    public static final Throwable unwrapImpl(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null && Intrinsics.areEqual(throwable2.getClass(), throwable.getClass())) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                if (!StackTraceRecoveryKt.isArtificial(stackTraceElementArray[i])) continue;
                return throwable2;
            }
            return throwable;
        }
        return throwable;
    }

    public static final ArrayDeque createStackTrace(CoroutineStackFrame coroutineStackFrame) {
        ArrayDeque<StackTraceElement> arrayDeque;
        ArrayDeque<StackTraceElement> arrayDeque2 = arrayDeque;
        arrayDeque = new ArrayDeque<StackTraceElement>();
        StackTraceElement stackTraceElement = coroutineStackFrame.getStackTraceElement();
        if (stackTraceElement != null) {
            arrayDeque2.add(stackTraceElement);
        }
        while ((coroutineStackFrame = coroutineStackFrame.getCallerFrame()) != null) {
            stackTraceElement = coroutineStackFrame.getStackTraceElement();
            if (stackTraceElement == null) continue;
            arrayDeque2.add(stackTraceElement);
        }
        return arrayDeque2;
    }

    public static final boolean isArtificial(StackTraceElement stackTraceElement) {
        return StringsKt__StringsJVMKt.startsWith$default(stackTraceElement.getClassName(), CoroutineDebuggingKt.getARTIFICIAL_FRAME_PACKAGE_NAME(), false, 2, null);
    }

    public static final int firstFrameIndex(StackTraceElement[] stackTraceElementArray, String string) {
        int n;
        block2: {
            int n2 = stackTraceElementArray.length;
            for (n = 0; n < n2; ++n) {
                if (!Intrinsics.areEqual(string, stackTraceElementArray[n].getClassName())) {
                    continue;
                }
                break block2;
            }
            n = -1;
        }
        return n;
    }

    public static final boolean elementWiseEquals(StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2) {
        return stackTraceElement.getLineNumber() == stackTraceElement2.getLineNumber() && Intrinsics.areEqual(stackTraceElement.getMethodName(), stackTraceElement2.getMethodName()) && Intrinsics.areEqual(stackTraceElement.getFileName(), stackTraceElement2.getFileName()) && Intrinsics.areEqual(stackTraceElement.getClassName(), stackTraceElement2.getClassName());
    }

    public static final /* synthetic */ Throwable access$recoverFromStackFrame(Throwable throwable, CoroutineStackFrame coroutineStackFrame) {
        return StackTraceRecoveryKt.recoverFromStackFrame(throwable, coroutineStackFrame);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Object object;
        block7: {
            ARTIFICIAL_FRAME = new ArtificialStackFrames().coroutineBoundary();
            try {
                // empty try
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
                break block7;
            }
            {
                object = Result.constructor-impl(BaseContinuationImpl.class.getCanonicalName());
            }
        }
        if (Result.exceptionOrNull-impl(object) != null) {
            object = "kotlin.coroutines.jvm.internal.BaseContinuationImpl";
        }
        baseContinuationImplClassName = (String)object;
        try {
            object = Result.constructor-impl(StackTraceRecoveryKt.class.getCanonicalName());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        if (Result.exceptionOrNull-impl(object) != null) {
            object = "kotlinx.coroutines.internal.StackTraceRecoveryKt";
        }
        stackTraceRecoveryClassName = (String)object;
    }
}

