/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal;

import java.util.Arrays;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.internal.PrimitiveArrayBuilder;

public final class ShortArrayBuilder
extends PrimitiveArrayBuilder {
    public short[] buffer;
    public int position;

    public ShortArrayBuilder(short[] sArray) {
        Intrinsics.checkNotNullParameter(sArray, "bufferWithData");
        this.buffer = sArray;
        this.position = sArray.length;
        this.ensureCapacity$kotlinx_serialization_core(10);
    }

    @Override
    public int getPosition$kotlinx_serialization_core() {
        return this.position;
    }

    @Override
    public void ensureCapacity$kotlinx_serialization_core(int n) {
        short[] sArray = this.buffer;
        if (this.buffer.length < n) {
            short[] sArray2 = Arrays.copyOf(sArray, RangesKt___RangesKt.coerceAtLeast(n, sArray.length * 2));
            Intrinsics.checkNotNullExpressionValue(sArray2, "copyOf(...)");
            this.buffer = sArray2;
        }
    }

    public final void append$kotlinx_serialization_core(short s) {
        ShortArrayBuilder shortArrayBuilder = this;
        PrimitiveArrayBuilder.ensureCapacity$kotlinx_serialization_core$default(shortArrayBuilder, 0, 1, null);
        int n = this.getPosition$kotlinx_serialization_core();
        this.position = n + 1;
        shortArrayBuilder.buffer[n] = s;
    }

    public short[] build$kotlinx_serialization_core() {
        short[] sArray = Arrays.copyOf(this.buffer, this.getPosition$kotlinx_serialization_core());
        Intrinsics.checkNotNullExpressionValue(sArray, "copyOf(...)");
        return sArray;
    }
}

