/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.input;

import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsKt;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.input.TextRange;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.input.TextRangeKt;

public final class TextInputState {
    public static final Companion Companion = new Companion(null);
    public static final char[] rejectedChar = new char[]{'\b', '\u0000', '\r', '\n', '\u007f'};
    public final String text;
    public final TextRange composition;
    public final TextRange selection;
    public final boolean selectionLeft;
    public final String compositionText;
    public final String selectionText;

    public TextInputState(String string, TextRange textRange, TextRange textRange2, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "text");
        Intrinsics.checkNotNullParameter(textRange, "composition");
        Intrinsics.checkNotNullParameter(textRange2, "selection");
        this.text = string;
        this.composition = textRange;
        this.selection = textRange2;
        this.selectionLeft = bl;
        if (textRange.getEnd() <= string.length()) {
            if (textRange2.getEnd() <= string.length()) {
                this.compositionText = TextRangeKt.substring(string, textRange);
                this.selectionText = TextRangeKt.substring(string, textRange2);
                return;
            }
            string = "selection region end " + textRange2.getEnd() + " should not exceed text length " + string.length();
            throw new IllegalArgumentException(string.toString());
        }
        string = "composition region end " + textRange.getEnd() + " should not exceed text length " + string.length();
        throw new IllegalArgumentException(string.toString());
    }

    public /* synthetic */ TextInputState(String string, TextRange textRange, TextRange textRange2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            textRange = TextRange.Companion.getEMPTY();
        }
        if ((n & 4) != 0) {
            TextRange textRange3;
            textRange2 = textRange3;
            textRange3 = new TextRange(string.length());
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string, textRange, textRange2, bl);
    }

    public static /* synthetic */ TextInputState copy$default(TextInputState textInputState, String string, TextRange textRange, TextRange textRange2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = textInputState.text;
        }
        if ((n & 2) != 0) {
            textRange = textInputState.composition;
        }
        if ((n & 4) != 0) {
            textRange2 = textInputState.selection;
        }
        if ((n & 8) != 0) {
            bl = textInputState.selectionLeft;
        }
        return textInputState.copy(string, textRange, textRange2, bl);
    }

    public final String getText() {
        return this.text;
    }

    public final TextRange getComposition() {
        return this.composition;
    }

    public final TextRange getSelection() {
        return this.selection;
    }

    public final boolean getSelectionLeft() {
        return this.selectionLeft;
    }

    public final String getSelectionText() {
        return this.selectionText;
    }

    public final TextInputState appendText(String object) {
        Object object2;
        Intrinsics.checkNotNullParameter(object, "appendText");
        if (((TextInputState)object2).composition.getLength() == 0) {
            TextInputState textInputState;
            TextRange textRange;
            StringBuilder stringBuilder = new StringBuilder();
            String string = ((TextInputState)object2).text.substring(0, ((TextInputState)object2).selection.getStart());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append((String)object);
            String string2 = ((TextInputState)object2).text.substring(((TextInputState)object2).selection.getEnd());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String string3 = stringBuilder2.append(string2).toString();
            TextRange textRange2 = textRange;
            textRange = new TextRange(((TextInputState)object2).selection.getStart() + ((String)object).length());
            object2 = TextRange.Companion.getEMPTY();
            object = textInputState;
            textInputState = new TextInputState(string3, (TextRange)object2, textRange2, false, 8, null);
        } else {
            TextInputState textInputState;
            TextRange textRange;
            StringBuilder stringBuilder = new StringBuilder();
            String string = ((TextInputState)object2).text.substring(0, ((TextInputState)object2).composition.getStart());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            StringBuilder stringBuilder3 = stringBuilder.append(string).append((String)object);
            String string4 = ((TextInputState)object2).text.substring(((TextInputState)object2).composition.getEnd());
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            String string5 = stringBuilder3.append(string4).toString();
            TextRange textRange3 = textRange;
            textRange = new TextRange(((TextInputState)object2).composition.getStart() + ((String)object).length());
            object2 = TextRange.Companion.getEMPTY();
            object = textInputState;
            textInputState = new TextInputState(string5, (TextRange)object2, textRange3, false, 8, null);
        }
        return object;
    }

    public final TextInputState commitText(String string) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(string, "commitText");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (ArraysKt___ArraysKt.contains(rejectedChar, c)) continue;
            stringBuilder2.append(c);
        }
        return this.appendText(stringBuilder2.toString());
    }

    public final TextInputState removeSelection() {
        TextRange textRange;
        TextInputState textInputState = this;
        TextRange textRange2 = textRange;
        textRange = new TextRange(this.selection.getStart());
        return TextInputState.copy$default(textInputState, TextRangeKt.removeRange(textInputState.text, this.selection), TextRange.Companion.getEMPTY(), textRange2, false, 8, null);
    }

    public final TextInputState doBackspace() {
        if (textInputState.composition.getLength() == 0) {
            TextInputState textInputState;
            if (textInputState.selection.getLength() != 0) {
                TextRange textRange;
                TextInputState textInputState2 = textInputState;
                TextRange textRange2 = textRange;
                textRange = new TextRange(textInputState.selection.getStart());
                textInputState = TextInputState.copy$default(textInputState2, TextRangeKt.removeRange(textInputState2.text, textInputState.selection), TextRange.Companion.getEMPTY(), textRange2, false, 8, null);
            } else if (textInputState.selection.getStart() > 0) {
                TextRange textRange;
                TextInputState textInputState3 = textInputState;
                TextRange textRange3 = textRange;
                textRange = new TextRange(textInputState.selection.getStart() - 1);
                textInputState = TextInputState.copy$default(textInputState3, ((Object)StringsKt__StringsKt.removeRange(textInputState3.text, textInputState.selection.getStart() - 1, textInputState.selection.getStart())).toString(), TextRange.Companion.getEMPTY(), textRange3, false, 8, null);
            }
        }
        return textInputState;
    }

    public final TextInputState doDelete() {
        if (textInputState.composition.getLength() == 0) {
            TextInputState textInputState;
            if (textInputState.selection.getLength() != 0) {
                TextRange textRange;
                TextInputState textInputState2 = textInputState;
                TextRange textRange2 = textRange;
                textRange = new TextRange(textInputState.selection.getStart());
                textInputState = TextInputState.copy$default(textInputState2, TextRangeKt.removeRange(textInputState2.text, textInputState.selection), TextRange.Companion.getEMPTY(), textRange2, false, 8, null);
            } else if (textInputState.selection.getEnd() < textInputState.text.length()) {
                TextRange textRange;
                TextInputState textInputState3 = textInputState;
                TextRange textRange3 = textRange;
                textRange = new TextRange(textInputState.selection.getStart());
                textInputState = TextInputState.copy$default(textInputState3, ((Object)StringsKt__StringsKt.removeRange(textInputState3.text, textInputState.selection.getStart(), textInputState.selection.getStart() + 1)).toString(), TextRange.Companion.getEMPTY(), textRange3, false, 8, null);
            }
        }
        return textInputState;
    }

    public final TextInputState doHome() {
        if (((TextInputState)object).composition.getLength() == 0) {
            TextRange textRange;
            TextInputState textInputState = object;
            Object object = textRange;
            textRange = new TextRange(0);
            object = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), (TextRange)object, false, 9, null);
        }
        return object;
    }

    public final TextInputState doEnd() {
        if (textInputState.composition.getLength() == 0) {
            TextRange textRange;
            TextRange textRange2 = textRange;
            textRange = new TextRange(textInputState.text.length());
            TextInputState textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange2, false, 9, null);
        }
        return textInputState;
    }

    public final TextInputState doArrowLeft() {
        if (textInputState.composition.getLength() == 0) {
            TextInputState textInputState;
            if (textInputState.selection.getLength() > 0) {
                TextRange textRange;
                TextRange textRange2 = textRange;
                textRange = new TextRange(textInputState.selection.getStart());
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange2, false, 9, null);
            } else if (textInputState.selection.getStart() > 0) {
                TextRange textRange;
                TextRange textRange3 = textRange;
                textRange = new TextRange(textInputState.selection.getStart() - 1);
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange3, false, 9, null);
            }
        }
        return textInputState;
    }

    public final TextInputState doArrowRight() {
        if (textInputState.composition.getLength() == 0) {
            TextInputState textInputState;
            if (textInputState.selection.getLength() > 0) {
                TextRange textRange;
                TextRange textRange2 = textRange;
                textRange = new TextRange(textInputState.selection.getEnd());
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange2, false, 9, null);
            } else if (textInputState.selection.getEnd() < textInputState.text.length()) {
                TextRange textRange;
                TextRange textRange3 = textRange;
                textRange = new TextRange(textInputState.selection.getEnd() + 1);
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange3, false, 9, null);
            }
        }
        return textInputState;
    }

    public final TextInputState doShiftLeft() {
        if (textInputState.composition.getLength() == 0) {
            TextInputState textInputState;
            if (textInputState.selection.getLength() == 0) {
                if (textInputState.selection.getStart() > 0) {
                    TextRange textRange;
                    TextRange textRange2 = textRange;
                    textRange = new TextRange(textInputState.selection.getStart() - 1, 1);
                    textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange2, true, 1, null);
                }
            } else if (textInputState.selectionLeft) {
                if (textInputState.selection.getStart() > 0) {
                    TextRange textRange;
                    TextRange textRange3 = textRange;
                    textRange = new TextRange(textInputState.selection.getStart() - 1, textInputState.selection.getLength() + 1);
                    textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange3, true, 1, null);
                }
            } else if (textInputState.selection.getEnd() > 0) {
                TextRange textRange;
                TextRange textRange4 = textRange;
                textRange = new TextRange(textInputState.selection.getStart(), textInputState.selection.getLength() - 1);
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange4, false, 1, null);
            }
        }
        return textInputState;
    }

    public final TextInputState doShiftRight() {
        if (textInputState.composition.getLength() == 0) {
            TextInputState textInputState;
            if (textInputState.selection.getLength() == 0) {
                if (textInputState.selection.getEnd() < textInputState.text.length()) {
                    TextRange textRange;
                    TextRange textRange2 = textRange;
                    textRange = new TextRange(textInputState.selection.getStart(), 1);
                    textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange2, false, 1, null);
                }
            } else if (textInputState.selectionLeft) {
                if (textInputState.selection.getStart() < textInputState.text.length()) {
                    TextRange textRange;
                    TextRange textRange3 = textRange;
                    textRange = new TextRange(textInputState.selection.getStart() + 1, textInputState.selection.getLength() - 1);
                    textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange3, true, 1, null);
                }
            } else if (textInputState.selection.getEnd() < textInputState.text.length()) {
                TextRange textRange;
                TextRange textRange4 = textRange;
                textRange = new TextRange(textInputState.selection.getStart(), textInputState.selection.getLength() + 1);
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange4, false, 1, null);
            }
        }
        return textInputState;
    }

    public final TextInputState doShiftHome() {
        if (textInputState.composition.getLength() == 0) {
            TextInputState textInputState;
            if (textInputState.selectionLeft) {
                TextRange textRange;
                TextRange textRange2 = textRange;
                textRange = new TextRange(0, textInputState.selection.getEnd());
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange2, true, 1, null);
            } else {
                TextRange textRange;
                TextRange textRange3 = textRange;
                textRange = new TextRange(0, textInputState.selection.getStart());
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange3, true, 1, null);
            }
        }
        return textInputState;
    }

    public final TextInputState doShiftEnd() {
        if (textInputState.composition.getLength() == 0) {
            TextInputState textInputState;
            if (textInputState.selectionLeft) {
                TextRange textRange;
                TextRange textRange2 = textRange;
                textRange = new TextRange(textInputState.selection.getEnd(), textInputState.text.length() - textInputState.selection.getEnd());
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange2, false, 1, null);
            } else {
                TextRange textRange;
                TextRange textRange3 = textRange;
                textRange = new TextRange(textInputState.selection.getStart(), textInputState.text.length() - textInputState.selection.getStart());
                textInputState = TextInputState.copy$default(textInputState, null, TextRange.Companion.getEMPTY(), textRange3, false, 1, null);
            }
        }
        return textInputState;
    }

    public final TextInputState copy(String string, TextRange textRange, TextRange textRange2, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "text");
        Intrinsics.checkNotNullParameter(textRange, "composition");
        Intrinsics.checkNotNullParameter(textRange2, "selection");
        return new TextInputState(string, textRange, textRange2, bl);
    }

    public String toString() {
        return "TextInputState(text=" + this.text + ", composition=" + this.composition + ", selection=" + this.selection + ", selectionLeft=" + this.selectionLeft + ')';
    }

    public int hashCode() {
        return ((this.text.hashCode() * 31 + this.composition.hashCode()) * 31 + this.selection.hashCode()) * 31 + Boolean.hashCode(this.selectionLeft);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextInputState)) {
            return false;
        }
        object = (TextInputState)object;
        if (!Intrinsics.areEqual(this.text, ((TextInputState)object).text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.composition, ((TextInputState)object).composition)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.selection, ((TextInputState)object).selection)) {
            return false;
        }
        return this.selectionLeft == ((TextInputState)object).selectionLeft;
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

