/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.modifier.scroll;

import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function1;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function2;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.math.MathKt__MathJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.data.BackgroundTexture;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.pointer.PointerEvent;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.input.pointer.PointerEventType;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.layout.Measurable;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.layout.MeasureResult;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.layout.MeasureScope;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.layout.Placeable;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.layout.Placer;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.modifier.Constraints;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.modifier.DrawModifierNode;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.modifier.LayoutModifierNode;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.modifier.Modifier;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.modifier.PointerInputModifierNode;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.modifier.scroll.ScrollState;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.node.LayoutNode;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.paint.Canvas;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.paint.ColorKt;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntOffset;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntRect;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntSize;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.Offset;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.Rect;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.Size;

public final class VerticalScrollNode
implements LayoutModifierNode,
DrawModifierNode,
PointerInputModifierNode,
Modifier.Node {
    public final ScrollState scrollState;
    public final boolean reverse;
    public final BackgroundTexture background;
    public final float backgroundScale;

    public VerticalScrollNode(ScrollState scrollState, boolean bl, BackgroundTexture backgroundTexture, float f) {
        Intrinsics.checkNotNullParameter(scrollState, "scrollState");
        this.scrollState = scrollState;
        this.reverse = bl;
        this.background = backgroundTexture;
        this.backgroundScale = f;
    }

    public static final void measure$lambda$0(VerticalScrollNode verticalScrollNode, int n, Placeable placeable) {
        int n2 = verticalScrollNode.reverse ? -(n - ((Number)verticalScrollNode.scrollState.getProgress().getValue()).intValue()) : -((Number)verticalScrollNode.scrollState.getProgress().getValue()).intValue();
        placeable.placeAt(0, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onPointerEvent(PointerEvent pointerEvent, Placeable placeable, LayoutNode object, Function1 function1) {
        Intrinsics.checkNotNullParameter(pointerEvent, "event");
        Intrinsics.checkNotNullParameter(placeable, "node");
        Intrinsics.checkNotNullParameter(object, "layoutNode");
        Intrinsics.checkNotNullParameter(function1, "children");
        int n = pointerEvent.getType-vurL73A();
        object = PointerEventType.Companion;
        if (PointerEventType.equals-impl0(n, ((PointerEventType.Companion)object).getScroll-vurL73A())) {
            float f = this.reverse ? -Offset.getY-impl(pointerEvent.getScrollDelta-Pjb2od0()) : Offset.getY-impl(pointerEvent.getScrollDelta-Pjb2od0());
            ScrollState scrollState = this.scrollState;
            scrollState.updateProgress((int)(((Number)scrollState.getProgress().getValue()).floatValue() - f * (float)12), true);
            return true;
        }
        if (PointerEventType.equals-impl0(n, ((PointerEventType.Companion)object).getPress-vurL73A())) {
            this.scrollState.setInitialPointerPosition-wRmQ-vo$combine(Offset.box-impl(pointerEvent.getPosition-Pjb2od0()));
            this.scrollState.setStartPointerPosition-wRmQ-vo$combine(null);
            this.scrollState.setScrolling$combine(false);
            this.scrollState.stopAnimation();
            return false;
        }
        if (!PointerEventType.equals-impl0(n, ((PointerEventType.Companion)object).getCancel-vurL73A()) && !PointerEventType.equals-impl0(n, ((PointerEventType.Companion)object).getRelease-vurL73A())) {
            if (!PointerEventType.equals-impl0(n, ((PointerEventType.Companion)object).getMove-vurL73A())) return false;
            Offset offset = this.scrollState.getInitialPointerPosition-sHUuaow$combine();
            if (this.scrollState.getScrolling$combine()) {
                int n2;
                if (this.reverse) {
                    float f = Offset.getY-impl(pointerEvent.getPosition-Pjb2od0());
                    Offset offset2 = this.scrollState.getStartPointerPosition-sHUuaow$combine();
                    Intrinsics.checkNotNull(offset2);
                    n2 = MathKt__MathJVMKt.roundToInt(f - Offset.getY-impl(offset2.unbox-impl()));
                } else {
                    Offset offset3 = this.scrollState.getStartPointerPosition-sHUuaow$combine();
                    Intrinsics.checkNotNull(offset3);
                    n2 = MathKt__MathJVMKt.roundToInt(Offset.getY-impl(offset3.unbox-impl()) - Offset.getY-impl(pointerEvent.getPosition-Pjb2od0()));
                }
                ScrollState scrollState = this.scrollState;
                ScrollState.updateProgress$default(scrollState, n2 + scrollState.getStartProgress$combine(), false, 2, null);
                return true;
            }
            if (offset == null) return false;
            float f = this.reverse ? Offset.getY-impl(pointerEvent.getPosition-Pjb2od0()) - Offset.getY-impl(offset.unbox-impl()) : Offset.getY-impl(offset.unbox-impl()) - Offset.getY-impl(pointerEvent.getPosition-Pjb2od0());
            if (!(Math.abs(f) > 8.0f)) return false;
            this.scrollState.setScrolling$combine(true);
            ScrollState scrollState = this.scrollState;
            scrollState.setStartProgress$combine(((Number)scrollState.getProgress().getValue()).intValue());
            this.scrollState.setStartPointerPosition-wRmQ-vo$combine(Offset.box-impl(pointerEvent.getPosition-Pjb2od0()));
            int n3 = ((PointerEventType.Companion)object).getCancel-vurL73A();
            function1.invoke(PointerEvent.copy-joTQNaI$default(pointerEvent, 0, 0L, 0, null, 0L, n3, 31, null));
            return true;
        }
        this.scrollState.setInitialPointerPosition-wRmQ-vo$combine(null);
        this.scrollState.setStartPointerPosition-wRmQ-vo$combine(null);
        ScrollState scrollState = this.scrollState;
        scrollState.updateProgress(((Number)scrollState.getProgress().getValue()).intValue(), true);
        if (!this.scrollState.getScrolling$combine()) return false;
        this.scrollState.setScrolling$combine(false);
        return true;
    }

    @Override
    public MeasureResult measure(MeasureScope object, Measurable measurable, Constraints constraints) {
        Constraints constraints2 = constraints;
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(measurable, "measurable");
        Intrinsics.checkNotNullParameter(constraints2, "constraints");
        int n = constraints2.getMaxHeight();
        if (n != Integer.MAX_VALUE) {
            Constraints constraints3 = constraints;
            int n2 = constraints3.getMinHeight();
            Placeable placeable = measurable.measure(Constraints.copy$default(constraints3, 0, 0, n2, Integer.MAX_VALUE, 3, null));
            VerticalScrollNode verticalScrollNode = this;
            int n3 = RangesKt___RangesKt.coerceAtMost(placeable.getHeight(), n);
            verticalScrollNode.scrollState.setContentHeight$combine(placeable.getHeight());
            verticalScrollNode.scrollState.setViewportHeight$combine(n3);
            n = RangesKt___RangesKt.coerceAtLeast(placeable.getHeight() - n3, 0);
            int n4 = ((Number)this.scrollState.getActualProgress().getValue()).intValue();
            if (n4 > n) {
                ScrollState.updateProgress$default(this.scrollState, n, false, 2, null);
            } else if (n4 < 0) {
                ScrollState.updateProgress$default(this.scrollState, 0, false, 2, null);
            }
            MeasureScope measureScope = object;
            int n5 = placeable.getWidth();
            object = () -> VerticalScrollNode.measure$lambda$0(this, n, placeable);
            return measureScope.layout(n5, n3, (Placer)object);
        }
        throw new IllegalStateException("Bad maxHeight of verticalScroll(): check nested scroll modifiers".toString());
    }

    @Override
    public void renderBefore(Canvas canvas, Placeable placeable) {
        Intrinsics.checkNotNullParameter(canvas, "<this>");
        Intrinsics.checkNotNullParameter(placeable, "node");
        Placeable placeable2 = placeable;
        int n = placeable2.getAbsoluteX();
        int n2 = placeable2.getAbsoluteY();
        long l = IntOffset.constructor-impl((long)n << 32 | (long)n2 & 0xFFFFFFFFL);
        int n3 = placeable2.getWidth();
        int n4 = placeable2.getHeight();
        IntRect intRect = new IntRect(l, IntSize.constructor-impl((long)n3 << 32 | (long)n4 & 0xFFFFFFFFL), null);
        Placeable placeable3 = placeable;
        int n5 = placeable3.getX();
        n2 = placeable3.getY();
        long l2 = IntOffset.constructor-impl((long)n5 << 32 | (long)n2 & 0xFFFFFFFFL);
        n3 = placeable3.getWidth();
        n4 = placeable3.getHeight();
        canvas.pushClip(intRect, new IntRect(l2, IntSize.constructor-impl((long)n3 << 32 | (long)n4 & 0xFFFFFFFFL), null));
        BackgroundTexture backgroundTexture = this.background;
        if (backgroundTexture != null && (n2 = IntSize.getHeight-impl(backgroundTexture.getSize-KlICH20())) != 0) {
            VerticalScrollNode verticalScrollNode = this;
            float f = (float)n2 * this.backgroundScale;
            float f2 = (float)((Number)verticalScrollNode.scrollState.getProgress().getValue()).intValue() % f;
            f2 = -f - f2;
            long l3 = Float.floatToRawIntBits(f2);
            f = (float)placeable.getHeight() + f * (float)2;
            long l4 = Float.floatToRawIntBits(f);
            Canvas.DefaultImpls.drawBackgroundTexture-_726XUM$default(canvas, backgroundTexture, verticalScrollNode.backgroundScale, new Rect(Offset.constructor-impl((long)Float.floatToRawIntBits(0.0f) << 32 | l3 & 0xFFFFFFFFL), Size.constructor-impl((long)Float.floatToRawIntBits(placeable.getWidth()) << 32 | l4 & 0xFFFFFFFFL), null), 0, 8, null);
        }
    }

    @Override
    public void renderAfter(Canvas canvas, Placeable placeable) {
        Intrinsics.checkNotNullParameter(canvas, "<this>");
        Intrinsics.checkNotNullParameter(placeable, "node");
        if (this.scrollState.getViewportHeight() < this.scrollState.getContentHeight()) {
            Placeable placeable2 = placeable;
            float f = (float)((Number)this.scrollState.getProgress().getValue()).intValue() / (float)(this.scrollState.getContentHeight() - this.scrollState.getViewportHeight());
            int n = RangesKt___RangesKt.coerceAtLeast(placeable2.getHeight() * this.scrollState.getViewportHeight() / this.scrollState.getContentHeight(), 12);
            float f2 = placeable2.getHeight() - n;
            if (this.reverse) {
                f = 1.0f - f;
            }
            int n2 = MathKt__MathJVMKt.roundToInt(f2 * f);
            canvas.fillRect-xZPMaPk(IntOffset.constructor-impl((long)(placeable.getWidth() - 3) << 32 | (long)n2 & 0xFFFFFFFFL), IntSize.constructor-impl((long)3 << 32 | (long)n & 0xFFFFFFFFL), ColorKt.Color-WZ4Q5Ns(0x66FFFFFF));
        }
        canvas.popClip();
    }

    public String toString() {
        return "VerticalScrollNode(scrollState=" + this.scrollState + ", reverse=" + this.reverse + ", background=" + this.background + ", backgroundScale=" + this.backgroundScale + ')';
    }

    public int hashCode() {
        VerticalScrollNode verticalScrollNode = this;
        int n = (verticalScrollNode.scrollState.hashCode() * 31 + Boolean.hashCode(this.reverse)) * 31;
        BackgroundTexture backgroundTexture = verticalScrollNode.background;
        int n2 = backgroundTexture == null ? 0 : backgroundTexture.hashCode();
        return (n + n2) * 31 + Float.hashCode(this.backgroundScale);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VerticalScrollNode)) {
            return false;
        }
        object = (VerticalScrollNode)object;
        if (!Intrinsics.areEqual(this.scrollState, ((VerticalScrollNode)object).scrollState)) {
            return false;
        }
        if (this.reverse != ((VerticalScrollNode)object).reverse) {
            return false;
        }
        if (!Intrinsics.areEqual(this.background, ((VerticalScrollNode)object).background)) {
            return false;
        }
        return Float.compare(this.backgroundScale, ((VerticalScrollNode)object).backgroundScale) == 0;
    }

    @Override
    public MeasureResult measure(Measurable measurable, Constraints constraints) {
        return LayoutModifierNode.DefaultImpls.measure(this, measurable, constraints);
    }

    @Override
    public Object foldIn(Object object, Function2 function2) {
        return Modifier.Node.DefaultImpls.foldIn(this, object, function2);
    }

    @Override
    public Modifier then(Modifier modifier) {
        return Modifier.Node.DefaultImpls.then(this, modifier);
    }
}

