/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.layout;

import java.util.LinkedHashMap;
import java.util.Map;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function1;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.uuid.Uuid;

public final class DoubleClickCounter {
    public final Map lastClickTimes;

    public DoubleClickCounter(Map map2) {
        Intrinsics.checkNotNullParameter(map2, "lastClickTimes");
        this.lastClickTimes = map2;
    }

    public /* synthetic */ DoubleClickCounter(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LinkedHashMap linkedHashMap;
            map2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
        }
        this(map2);
    }

    public static final boolean clean$lambda$0(int n, CounterEntry counterEntry) {
        CounterEntry counterEntry2 = counterEntry;
        Intrinsics.checkNotNullParameter(counterEntry2, "it");
        return counterEntry2.getLastUpdateTick() < n;
    }

    public static final boolean clean$lambda$1(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    public final void update(int n, Uuid uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        CounterEntry counterEntry = (CounterEntry)((DoubleClickCounter)((Object)counterEntry3)).lastClickTimes.get(uuid);
        if (counterEntry == null) {
            CounterEntry counterEntry2;
            CounterEntry counterEntry3 = counterEntry2;
            counterEntry2 = new CounterEntry(0, n, 1, null);
            ((DoubleClickCounter)((Object)counterEntry3)).lastClickTimes.put(uuid, counterEntry3);
        } else {
            ((DoubleClickCounter)((Object)counterEntry3)).lastClickTimes.put(uuid, CounterEntry.copy$default(counterEntry, 0, n, 1, null));
        }
    }

    public final boolean click(int n, Uuid uuid, int n2) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        CounterEntry counterEntry = (CounterEntry)this.lastClickTimes.get(uuid);
        if (counterEntry == null) {
            return false;
        }
        n2 = n - counterEntry.getLastClickTick() <= n2 ? 1 : 0;
        if (n2 != 0) {
            this.lastClickTimes.put(uuid, CounterEntry.copy$default(counterEntry, -1, 0, 2, null));
        } else {
            this.lastClickTimes.put(uuid, CounterEntry.copy$default(counterEntry, n, 0, 2, null));
        }
        return n2 != 0;
    }

    public final void clean(int n) {
        this.lastClickTimes.values().removeIf(arg_0 -> DoubleClickCounter.clean$lambda$1(arg_0 -> DoubleClickCounter.clean$lambda$0(n, arg_0), arg_0));
    }

    public static final class CounterEntry {
        public final int lastClickTick;
        public final int lastUpdateTick;

        public CounterEntry(int n, int n2) {
            this.lastClickTick = n;
            this.lastUpdateTick = n2;
        }

        public /* synthetic */ CounterEntry(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = -1;
            }
            this(n, n2);
        }

        public static /* synthetic */ CounterEntry copy$default(CounterEntry counterEntry, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = counterEntry.lastClickTick;
            }
            if ((n3 & 2) != 0) {
                n2 = counterEntry.lastUpdateTick;
            }
            return counterEntry.copy(n, n2);
        }

        public final int getLastClickTick() {
            return this.lastClickTick;
        }

        public final int getLastUpdateTick() {
            return this.lastUpdateTick;
        }

        public final CounterEntry copy(int n, int n2) {
            return new CounterEntry(n, n2);
        }

        public String toString() {
            return "CounterEntry(lastClickTick=" + this.lastClickTick + ", lastUpdateTick=" + this.lastUpdateTick + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.lastClickTick) * 31 + Integer.hashCode(this.lastUpdateTick);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CounterEntry)) {
                return false;
            }
            object = (CounterEntry)object;
            if (this.lastClickTick != ((CounterEntry)object).lastClickTick) {
                return false;
            }
            return this.lastUpdateTick == ((CounterEntry)object).lastUpdateTick;
        }
    }
}

