/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.uuid;

import java.io.Serializable;
import java.util.Comparator;
import top.fifthlight.touchcontroller.relocated.kotlin.ULong;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.text.HexExtensionsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.uuid.UuidKt__UuidJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.uuid.UuidKt__UuidKt;

public final class Uuid
implements Serializable {
    public static final Companion Companion = new Companion(null);
    public static final Uuid NIL = new Uuid(0L, 0L);
    public static final Comparator LEXICAL_ORDER = Uuid::LEXICAL_ORDER$lambda$0;
    public final long mostSignificantBits;
    public final long leastSignificantBits;

    public Uuid(long l, long l2) {
        this.mostSignificantBits = l;
        this.leastSignificantBits = l2;
    }

    public static final int LEXICAL_ORDER$lambda$0(Uuid uuid, Uuid uuid2) {
        Intrinsics.checkNotNullParameter(uuid, "a");
        Intrinsics.checkNotNullParameter(uuid2, "b");
        long l = uuid.mostSignificantBits;
        return l != uuid2.mostSignificantBits ? Long.compareUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(uuid2.mostSignificantBits)) : Long.compareUnsigned(ULong.constructor-impl(uuid.leastSignificantBits), ULong.constructor-impl(uuid2.leastSignificantBits));
    }

    public final long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    public final long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    public String toString() {
        byte[] byArray = new byte[36];
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits, byArray, 24, 6);
        byArray[23] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits >>> 48, byArray, 19, 2);
        byArray[18] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits, byArray, 14, 2);
        byArray[13] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits >>> 16, byArray, 9, 2);
        byArray[8] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits >>> 32, byArray, 0, 4);
        return StringsKt__StringsJVMKt.decodeToString(byArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Uuid)) {
            return false;
        }
        object = (Uuid)object;
        return this.mostSignificantBits == ((Uuid)object).mostSignificantBits && this.leastSignificantBits == ((Uuid)object).leastSignificantBits;
    }

    public int hashCode() {
        long l = this.mostSignificantBits ^ this.leastSignificantBits;
        return (int)(l >> 32) ^ (int)l;
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final Uuid getNIL() {
            return NIL;
        }

        public final Uuid fromLongs(long l, long l2) {
            Object object;
            if (l == 0L && l2 == 0L) {
                object = ((Companion)object).getNIL();
            } else {
                Uuid uuid;
                object = uuid;
                uuid = new Uuid(l, l2);
            }
            return object;
        }

        public final Uuid fromByteArray(byte[] byArray) {
            Intrinsics.checkNotNullParameter(byArray, "byteArray");
            if (byArray.length == 16) {
                long l = UuidKt__UuidKt.access$toLong(byArray, 0);
                long l2 = UuidKt__UuidKt.access$toLong(byArray, 8);
                return this.fromLongs(l, l2);
            }
            throw new IllegalArgumentException("Expected exactly 16 bytes".toString());
        }

        public final Uuid parse(String string) {
            String string2 = string;
            Intrinsics.checkNotNullParameter(string2, "uuidString");
            if (string2.length() == 36) {
                String string3 = string;
                long l = HexExtensionsKt.hexToLong$default(string3, 0, 8, null, 4, null);
                UuidKt__UuidKt.access$checkHyphenAt(string3, 8);
                long l2 = HexExtensionsKt.hexToLong$default(string3, 9, 13, null, 4, null);
                UuidKt__UuidKt.access$checkHyphenAt(string3, 13);
                long l3 = HexExtensionsKt.hexToLong$default(string3, 14, 18, null, 4, null);
                UuidKt__UuidKt.access$checkHyphenAt(string3, 18);
                long l4 = HexExtensionsKt.hexToLong$default(string3, 19, 23, null, 4, null);
                String string4 = string;
                UuidKt__UuidKt.access$checkHyphenAt(string4, 23);
                long l5 = HexExtensionsKt.hexToLong$default(string4, 24, 36, null, 4, null);
                l = l << 32 | l2 << 16 | l3;
                l5 = l4 << 48 | l5;
                return this.fromLongs(l, l5);
            }
            throw new IllegalArgumentException("Expected a 36-char string in the standard uuid format.".toString());
        }

        public final Uuid random() {
            return UuidKt__UuidJVMKt.secureRandomUuid();
        }
    }
}

