/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList;

import java.util.Arrays;
import java.util.ListIterator;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysJvmKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function1;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.PersistentList;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.ObjectRef;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorIterator;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.SmallPersistentVector;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.internal.CommonFunctionsKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.internal.ListImplementation;

public final class PersistentVector
extends AbstractPersistentList
implements PersistentList {
    public final Object[] root;
    public final Object[] tail;
    public final int size;
    public final int rootShift;

    public PersistentVector(Object[] object, Object[] objectArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(object, "root");
        Intrinsics.checkNotNullParameter(objectArray, "tail");
        this.root = object;
        this.tail = objectArray;
        this.size = n;
        this.rootShift = n2;
        if (this.size() > 32) {
            CommonFunctionsKt.assert(this.size() - UtilsKt.rootSize(this.size()) <= RangesKt___RangesKt.coerceAtMost(objectArray.length, 32));
            return;
        }
        object = "Trie-based persistent vector should have at least 33 elements, got " + this.size();
        throw new IllegalArgumentException(object.toString());
    }

    private final int rootSize() {
        return UtilsKt.rootSize(this.size());
    }

    private final Object[] pushTail(Object[] objectArray, int n, Object[] objectArray2) {
        int n2;
        block6: {
            block5: {
                n2 = UtilsKt.indexSegment(objectArray4.size() - 1, n);
                if (objectArray == null) break block5;
                objectArray = Arrays.copyOf(objectArray, 32);
                Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
                if (objectArray != null) break block6;
            }
            objectArray = new Object[32];
        }
        if (n == 5) {
            objectArray[n2] = objectArray2;
        } else {
            Object[] objectArray3 = objectArray4;
            Object[] objectArray4 = (Object[])objectArray[n2];
            objectArray[n2] = super.pushTail(objectArray4, n - 5, objectArray2);
        }
        return objectArray;
    }

    private final Object[] bufferFor(int n) {
        if (objectArray.rootSize() <= n) {
            return objectArray.tail;
        }
        Object[] objectArray = objectArray.root;
        for (int i = objectArray.rootShift; i > 0; i -= 5) {
            Object object = objectArray[UtilsKt.indexSegment(n, i)];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray = (Object[])object;
        }
        return objectArray;
    }

    private final Object[] setInRoot(Object[] objectArray, int n, int n2, Object object) {
        int n3 = UtilsKt.indexSegment(n2, n);
        Object[] objectArray2 = Arrays.copyOf(objectArray, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
        if (n == 0) {
            objectArray2[n3] = object;
        } else {
            Object[] objectArray3 = objectArray4;
            Object object2 = objectArray2[n3];
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            Object[] objectArray4 = (Object[])object2;
            objectArray2[n3] = super.setInRoot(objectArray4, n - 5, n2, object);
        }
        return objectArray2;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public PersistentList add(Object objectArray) {
        Object[] objectArray2;
        int n = objectArray2.size() - objectArray2.rootSize();
        if (n < 32) {
            Object[] objectArray3 = Arrays.copyOf(objectArray2.tail, 32);
            Object[] objectArray4 = objectArray3;
            Intrinsics.checkNotNullExpressionValue(objectArray4, "copyOf(...)");
            objectArray3[n] = objectArray;
            objectArray2 = objectArray2.root;
            int n2 = objectArray2.size() + 1;
            n = objectArray2.rootShift;
            return new PersistentVector(objectArray2, objectArray4, n2, n);
        }
        Object[] objectArray5 = objectArray2;
        objectArray2 = UtilsKt.presizedBufferWith(objectArray);
        objectArray = objectArray5.root;
        return objectArray2.pushFilledTail(objectArray, objectArray5.tail, objectArray2);
    }

    @Override
    public PersistentList add(int n, Object object) {
        ObjectRef objectRef;
        Object[] objectArray;
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(n, objectArray.size());
        if (n == objectArray.size()) {
            return objectArray.add(object);
        }
        int n2 = objectArray.rootSize();
        if (n >= n2) {
            Object[] objectArray2 = objectArray;
            objectArray = objectArray.root;
            return objectArray2.insertIntoTail(objectArray, n - n2, object);
        }
        Object[] objectArray3 = objectArray;
        ObjectRef objectRef2 = objectRef;
        objectRef2(null);
        objectArray = objectArray.root;
        objectArray = objectArray.insertIntoRoot(objectArray, objectArray.rootShift, n, object, objectRef2);
        Object object2 = objectRef.getValue();
        return objectArray3.insertIntoTail(objectArray, 0, object2);
    }

    @Override
    public PersistentList removeAt(int n) {
        ObjectRef objectRef;
        Object[] objectArray;
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(n, objectArray.size());
        int n2 = objectArray.rootSize();
        if (n >= n2) {
            Object[] objectArray2 = objectArray;
            int n3 = n;
            objectArray = objectArray.root;
            n = objectArray.rootShift;
            int n4 = n3 - n2;
            return objectArray2.removeFromTailAt(objectArray, n2, n, n4);
        }
        Object[] objectArray3 = objectArray;
        Object object = objectArray3.root;
        int n5 = objectArray3.rootShift;
        Object[] objectArray4 = object;
        object = objectRef;
        objectRef = new ObjectRef(objectArray.tail[0]);
        objectArray = objectArray3.removeFromRootAt(objectArray4, n5, n, (ObjectRef)object);
        n = objectArray3.rootShift;
        return objectArray.removeFromTailAt(objectArray, n2, n, 0);
    }

    @Override
    public PersistentList removeAll(Function1 function1) {
        Intrinsics.checkNotNullParameter(function1, "predicate");
        PersistentVectorBuilder persistentVectorBuilder = this.builder();
        persistentVectorBuilder.removeAllWithPredicate(function1);
        return persistentVectorBuilder.build();
    }

    @Override
    public PersistentVectorBuilder builder() {
        PersistentVector persistentVector = this;
        Object[] objectArray = persistentVector.root;
        Object[] objectArray2 = persistentVector.tail;
        int n = persistentVector.rootShift;
        return new PersistentVectorBuilder(this, objectArray, objectArray2, n);
    }

    @Override
    public ListIterator listIterator(int n) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(n, this.size());
        PersistentVector persistentVector = this;
        Object[] objectArray = persistentVector.root;
        Object[] objectArray2 = persistentVector.tail;
        int n2 = persistentVector.size();
        int n3 = this.rootShift / 5 + 1;
        return new PersistentVectorIterator(objectArray, objectArray2, n, n2, n3);
    }

    @Override
    public Object get(int n) {
        int n2 = n;
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(n2, this.size());
        return this.bufferFor(n2)[n & 0x1F];
    }

    @Override
    public PersistentList set(int n, Object object) {
        Object[] objectArray;
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(n, objectArray.size());
        if (objectArray.rootSize() <= n) {
            Object[] objectArray2 = Arrays.copyOf(objectArray.tail, 32);
            Object[] objectArray3 = objectArray2;
            Intrinsics.checkNotNullExpressionValue(objectArray3, "copyOf(...)");
            objectArray2[n & 0x1F] = object;
            objectArray = objectArray.root;
            n = objectArray.size();
            int n2 = objectArray.rootShift;
            return new PersistentVector(objectArray, objectArray3, n, n2);
        }
        Object[] objectArray4 = objectArray.root;
        Object[] objectArray5 = objectArray.setInRoot(objectArray4, objectArray.rootShift, n, object);
        objectArray = objectArray.tail;
        int n3 = objectArray.size();
        int n4 = objectArray.rootShift;
        return new PersistentVector(objectArray5, objectArray, n3, n4);
    }

    public final PersistentVector pushFilledTail(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        int n = this.rootShift;
        if (this.size() >> 5 > 1 << n) {
            int n2 = this.rootShift + 5;
            objectArray2 = this.pushTail(UtilsKt.presizedBufferWith(objectArray), n2, objectArray2);
            return new PersistentVector(objectArray2, objectArray3, this.size() + 1, n2);
        }
        objectArray = this.pushTail(objectArray, n, objectArray2);
        PersistentVector persistentVector = this;
        int n3 = persistentVector.size() + 1;
        int n4 = persistentVector.rootShift;
        return new PersistentVector(objectArray, objectArray3, n3, n4);
    }

    public final PersistentVector insertIntoTail(Object[] objectArray, int n, Object object) {
        int n2 = objectArray4.size() - objectArray4.rootSize();
        Object[] objectArray2 = Arrays.copyOf(objectArray4.tail, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
        if (n2 < 32) {
            ArraysKt___ArraysJvmKt.copyInto(objectArray4.tail, objectArray2, n + 1, n, n2);
            objectArray2[n] = object;
            int n3 = objectArray4.size() + 1;
            return new PersistentVector(objectArray, objectArray2, n3, objectArray4.rootShift);
        }
        Object[] objectArray3 = objectArray4;
        Object[] objectArray4 = objectArray4.tail;
        Object object2 = objectArray4.tail[31];
        int n4 = n + 1;
        int n5 = n2 - 1;
        ArraysKt___ArraysJvmKt.copyInto(objectArray4, objectArray2, n4, n, n5);
        objectArray2[n] = object;
        return objectArray3.pushFilledTail(objectArray, objectArray2, UtilsKt.presizedBufferWith(object2));
    }

    public final Object[] insertIntoRoot(Object[] objectArray, int n, int n2, Object objectArray2, ObjectRef objectRef) {
        int n3 = UtilsKt.indexSegment(n2, n);
        if (n == 0) {
            Object[] objectArray3;
            if (n3 == 0) {
                objectArray3 = new Object[32];
            } else {
                objectArray3 = Arrays.copyOf(objectArray, 32);
                Intrinsics.checkNotNullExpressionValue(objectArray3, "copyOf(...)");
            }
            ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray3, n3 + 1, n3, 31);
            objectRef.setValue(objectArray[31]);
            objectArray3[n3] = objectArray2;
            return objectArray3;
        }
        Object[] objectArray4 = Arrays.copyOf(objectArray, 32);
        Object[] objectArray5 = objectArray4;
        Intrinsics.checkNotNullExpressionValue(objectArray5, "copyOf(...)");
        Object object = objectArray[n3];
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        objectArray4[n3] = objectArray3.insertIntoRoot((Object[])object, n -= 5, n2, objectArray2, objectRef);
        for (n2 = n3 + 1; n2 < 32 && objectArray5[n2] != null; ++n2) {
            Object object2 = objectArray[n2];
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray2 = (Object[])object2;
            Object object3 = objectRef.getValue();
            objectArray5[n2] = objectArray3.insertIntoRoot(objectArray2, n, 0, object3, objectRef);
        }
        return objectArray5;
    }

    public final PersistentList removeFromTailAt(Object[] objectArray, int n, int n2, int n3) {
        int n4 = this.size() - n;
        CommonFunctionsKt.assert(n3 < n4);
        if (n4 == 1) {
            return this.pullLastBufferFromRoot(objectArray, n, n2);
        }
        Object[] objectArray2 = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
        int n5 = n4 - 1;
        if (n3 < n5) {
            ArraysKt___ArraysJvmKt.copyInto(this.tail, objectArray2, n3, n3 + 1, n4);
        }
        objectArray2[n5] = null;
        return new PersistentVector(objectArray, objectArray2, n + n4 - 1, n2);
    }

    public final PersistentList pullLastBufferFromRoot(Object[] objectArray, int n, int n2) {
        ObjectRef objectRef;
        if (n2 == 0) {
            if (objectArray.length == 33) {
                objectArray = Arrays.copyOf(objectArray, 32);
                Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
            }
            return new SmallPersistentVector(objectArray);
        }
        PersistentVector persistentVector = objectArray2;
        Object[] objectArray2 = objectRef;
        objectRef = new ObjectRef(null);
        objectArray = persistentVector.pullLastBuffer(objectArray, n2, n - 1, (ObjectRef)objectArray2);
        Intrinsics.checkNotNull(objectArray);
        Object object = objectArray2.getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        objectArray2 = (Object[])object;
        if (objectArray[1] == null) {
            Object object2 = objectArray[0];
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray = (Object[])object2;
            return new PersistentVector(objectArray, objectArray2, n, n2 -= 5);
        }
        return new PersistentVector(objectArray, objectArray2, n, n2);
    }

    public final Object[] pullLastBuffer(Object[] objectArray, int n, int n2, ObjectRef objectRef) {
        Object[] objectArray2;
        int n3 = UtilsKt.indexSegment(n2, n);
        if (n == 5) {
            objectRef.setValue(objectArray[n3]);
            objectArray2 = null;
        } else {
            Object[] objectArray3 = objectArray2;
            Object object = objectArray[n3];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray2 = (Object[])object;
            objectArray2 = objectArray3.pullLastBuffer(objectArray2, n - 5, n2, objectRef);
        }
        if (objectArray2 == null && n3 == 0) {
            return null;
        }
        Object[] objectArray4 = Arrays.copyOf(objectArray, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray4, "copyOf(...)");
        objectArray4[n3] = objectArray2;
        return objectArray4;
    }

    public final Object[] removeFromRootAt(Object[] objectArray, int n, int n2, ObjectRef objectRef) {
        int n3 = UtilsKt.indexSegment(n2, n);
        if (n == 0) {
            Object[] objectArray2;
            if (n3 == 0) {
                objectArray2 = new Object[32];
            } else {
                objectArray2 = Arrays.copyOf(objectArray, 32);
                Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
            }
            ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray2, n3, n3 + 1, 32);
            objectArray2[31] = objectRef.getValue();
            objectRef.setValue(objectArray[n3]);
            return objectArray2;
        }
        int n4 = 31;
        if (objectArray[31] == null) {
            n4 = UtilsKt.indexSegment(super.rootSize() - 1, n);
        }
        objectArray = Arrays.copyOf(objectArray, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        n -= 5;
        int n5 = n3 + 1;
        if (n5 <= n4) {
            while (true) {
                Object object = objectArray[n4];
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                objectArray[n4] = objectArray2.removeFromRootAt((Object[])object, n, 0, objectRef);
                if (n4 == n5) break;
                --n4;
            }
        }
        Object object = objectArray[n3];
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        objectArray[n3] = objectArray2.removeFromRootAt((Object[])object, n, n2, objectRef);
        return objectArray;
    }
}

