/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.platform.win32;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.common.gal.NativeWindow;
import top.fifthlight.touchcontroller.common.platform.Platform;
import top.fifthlight.touchcontroller.common.platform.win32.Interface;
import top.fifthlight.touchcontroller.proxy.message.MessageDecodeException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.org.slf4j.Logger;
import top.fifthlight.touchcontroller.relocated.org.slf4j.LoggerFactory;

public final class Win32Platform
implements Platform {
    public final Logger logger;
    public final byte[] readBuffer;

    public Win32Platform(NativeWindow.Win32 win32) {
        Intrinsics.checkNotNullParameter(win32, "window");
        this.logger = LoggerFactory.getLogger(Win32Platform.class);
        Interface.init(win32.getHandle());
        this.readBuffer = new byte[128];
    }

    @Override
    public ProxyMessage pollEvent() {
        Integer n = Interface.pollEvent(((Win32Platform)object).readBuffer);
        if (n == 0) {
            n = null;
        }
        if (n != null) {
            Object object;
            int n2 = n;
            ByteBuffer byteBuffer = ByteBuffer.wrap(((Win32Platform)object).readBuffer);
            ((Buffer)byteBuffer).limit(n2);
            if (byteBuffer.remaining() < 4) {
                return null;
            }
            try {
                Intrinsics.checkNotNull(byteBuffer);
                object = ProxyMessage.Companion.decode(byteBuffer.getInt(), byteBuffer);
            }
            catch (MessageDecodeException messageDecodeException) {
                ((Win32Platform)object).logger.warn("Bad message from native side: " + messageDecodeException);
                object = null;
            }
            return object;
        }
        return null;
    }

    @Override
    public void sendEvent(ProxyMessage proxyMessage) {
        Intrinsics.checkNotNullParameter(proxyMessage, "message");
    }

    @Override
    public void resize(int n, int n2) {
        Platform.DefaultImpls.resize(this, n, n2);
    }
}

