/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine;

import java.util.HashMap;
import java.util.Map;
import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.BaseTween;
import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.Pool;
import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.TweenAccessor;
import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.TweenEquation;
import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.TweenPath;
import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.TweenPaths;
import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.equations.Quad;

public final class Tween
extends BaseTween {
    public static int combinedAttrsLimit;
    public static int waypointsLimit;
    public static final Pool.Callback poolCallback;
    public static final Pool pool;
    public static final Map registeredAccessors;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public Object target;
    public Class targetClass;
    public TweenAccessor accessor;
    public int type;
    public TweenEquation equation;
    public TweenPath path;
    public boolean isFrom;
    public boolean isRelative;
    public int combinedAttrsCnt;
    public int waypointsCnt;
    public final float[] startValues;
    public final float[] targetValues;
    public final float[] waypoints;
    public float[] accessorBuffer;
    public float[] pathBuffer;

    public static void registerAccessor(Class clazz, TweenAccessor tweenAccessor) {
        registeredAccessors.put(clazz, tweenAccessor);
    }

    public static Tween to(Object object, int n, float f) {
        Tween tween = (Tween)pool.get();
        tween.setup(object, n, f);
        tween.ease(Quad.INOUT);
        tween.path(TweenPaths.catmullRom);
        return tween;
    }

    public Tween() {
        Tween tween = this;
        int n = combinedAttrsLimit;
        tween.startValues = new float[n];
        tween.targetValues = new float[n];
        int n2 = waypointsLimit;
        this.waypoints = new float[n2 * n];
        this.accessorBuffer = new float[n];
        tween.pathBuffer = new float[(n2 + 2) * n];
        tween.reset();
    }

    public final void setup(Object clazz, int n, float f) {
        if (!(f < 0.0f)) {
            this.target = clazz;
            clazz = clazz != null ? this.findTargetClass() : null;
            Tween tween = this;
            tween.targetClass = clazz;
            tween.type = n;
            tween.duration = f;
            return;
        }
        throw new RuntimeException("Duration can't be negative");
    }

    public final Class findTargetClass() {
        if (registeredAccessors.containsKey(((Tween)object).target.getClass())) {
            return ((Tween)object).target.getClass();
        }
        Object object = ((Tween)object).target;
        if (object instanceof TweenAccessor) {
            return object.getClass();
        }
        for (object = object.getClass().getSuperclass(); object != null && !registeredAccessors.containsKey(object); object = ((Class)object).getSuperclass()) {
        }
        return object;
    }

    public final void throwCombinedAttrsLimitReached() {
        String string = "You cannot combine more than " + combinedAttrsLimit + " attributes in a tween. You can raise this limit with Tween.setCombinedAttributesLimit(), which should be called once in application initialization code.";
        throw new RuntimeException(string);
    }

    public /* synthetic */ Tween(1 var1_1) {
        this();
    }

    static {
        Pool.Callback callback;
        $assertionsDisabled = Tween.class.desiredAssertionStatus() ^ true;
        combinedAttrsLimit = 3;
        waypointsLimit = 0;
        Pool.Callback callback2 = callback;
        poolCallback = new Pool.Callback(){

            public void onPool(Tween tween) {
                tween.reset();
            }

            public void onUnPool(Tween tween) {
                tween.reset();
            }
        };
        pool = new Pool(20, callback2){

            @Override
            public Tween create() {
                return new Tween(null);
            }
        };
        registeredAccessors = new HashMap();
    }

    @Override
    public void reset() {
        int n;
        Tween tween = this;
        super.reset();
        tween.target = null;
        tween.targetClass = null;
        tween.accessor = null;
        tween.type = -1;
        tween.equation = null;
        tween.path = null;
        tween.isRelative = false;
        tween.isFrom = false;
        tween.waypointsCnt = 0;
        tween.combinedAttrsCnt = 0;
        int n2 = combinedAttrsLimit;
        if (tween.accessorBuffer.length != n2) {
            this.accessorBuffer = new float[n2];
        }
        if (this.pathBuffer.length != ((n = waypointsLimit) + 2) * n2) {
            this.pathBuffer = new float[(n + 2) * n2];
        }
    }

    public Tween ease(TweenEquation tweenEquation) {
        this.equation = tweenEquation;
        return this;
    }

    public Tween target(float ... fArray) {
        if (fArray.length > combinedAttrsLimit) {
            ((Tween)object).throwCombinedAttrsLimitReached();
        }
        Tween tween = object;
        Object object = ((Tween)object).targetValues;
        int n = fArray.length;
        System.arraycopy(fArray, 0, object, 0, n);
        return tween;
    }

    public Tween path(TweenPath tweenPath) {
        this.path = tweenPath;
        return this;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public Tween build() {
        Object object;
        if (this.target == null) {
            return this;
        }
        this.accessor = (TweenAccessor)registeredAccessors.get(this.targetClass);
        if (this.accessor == null && (object = this.target) instanceof TweenAccessor) {
            this.accessor = (TweenAccessor)object;
        }
        if ((object = this.accessor) != null) {
            Tween tween = this;
            int n = tween.type;
            float[] fArray = tween.accessorBuffer;
            this.combinedAttrsCnt = object.getValues(object = tween.target, n, fArray);
            if (this.combinedAttrsCnt > combinedAttrsLimit) {
                this.throwCombinedAttrsLimitReached();
            }
            return this;
        }
        throw new RuntimeException("No TweenAccessor was found for the target");
    }

    @Override
    public void free() {
        pool.free(this);
    }

    @Override
    public void initializeOverride() {
        Object object = this.target;
        if (object == null) {
            return;
        }
        Tween tween = this;
        int n = tween.type;
        this.accessor.getValues(object, n, tween.startValues);
        for (n = 0; n < this.combinedAttrsCnt; ++n) {
            Tween tween2 = this;
            float[] fArray = tween2.targetValues;
            float f = tween2.targetValues[n];
            float f2 = tween2.isRelative ? this.startValues[n] : 0.0f;
            fArray[n] = f + f2;
            for (int i = 0; i < this.waypointsCnt; ++i) {
                Tween tween3 = this;
                float[] fArray2 = tween3.waypoints;
                int n2 = i * this.combinedAttrsCnt + n;
                float f3 = tween3.waypoints[n2];
                float f4 = tween3.isRelative ? this.startValues[n] : 0.0f;
                fArray2[n2] = f3 + f4;
            }
            if (!this.isFrom) continue;
            Tween tween4 = this;
            float[] fArray3 = tween4.startValues;
            f = tween4.startValues[n];
            fArray3[n] = tween4.targetValues[n];
            tween4.targetValues[n] = f;
        }
    }

    @Override
    public void updateOverride(int n, int n2, boolean n3, float f) {
        Object object = ((Tween)object2).target;
        if (object != null && ((Tween)object2).equation != null) {
            float f2;
            Object object2;
            if (n3 == 0 && n > n2) {
                TweenAccessor tweenAccessor = ((Tween)object2).accessor;
                n3 = ((Tween)object2).type;
                object2 = ((BaseTween)object2).isReverse(n2) ? (Object)((Tween)object2).startValues : (Object)((Tween)object2).targetValues;
                tweenAccessor.setValues(object, n3, (float[])object2);
                return;
            }
            if (n3 == 0 && n < n2) {
                TweenAccessor tweenAccessor = ((Tween)object2).accessor;
                n3 = ((Tween)object2).type;
                object2 = ((BaseTween)object2).isReverse(n2) ? (Object)((Tween)object2).targetValues : (Object)((Tween)object2).startValues;
                tweenAccessor.setValues(object, n3, (float[])object2);
                return;
            }
            boolean bl = $assertionsDisabled;
            n2 = bl ? 1 : 0;
            if (!bl && n3 == 0) {
                throw new AssertionError();
            }
            if (n2 == 0 && !(((BaseTween)object2).getCurrentTime() >= 0.0f)) {
                throw new AssertionError();
            }
            if (n2 == 0 && !(((BaseTween)object2).getCurrentTime() <= ((BaseTween)object2).duration)) {
                throw new AssertionError();
            }
            float f3 = ((BaseTween)object2).duration;
            if (f2 < 1.0E-11f && f > -1.0E-11f) {
                TweenAccessor tweenAccessor = ((Tween)object2).accessor;
                Object object3 = ((Tween)object2).target;
                int n4 = ((Tween)object2).type;
                object2 = ((BaseTween)object2).isReverse(n) ? (Object)((Tween)object2).targetValues : (Object)((Tween)object2).startValues;
                tweenAccessor.setValues(object3, n4, (float[])object2);
                return;
            }
            if (f3 < 1.0E-11f && f < 1.0E-11f) {
                TweenAccessor tweenAccessor = ((Tween)object2).accessor;
                Object object4 = ((Tween)object2).target;
                int n5 = ((Tween)object2).type;
                object2 = ((BaseTween)object2).isReverse(n) ? (Object)((Tween)object2).startValues : (Object)((Tween)object2).targetValues;
                tweenAccessor.setValues(object4, n5, (float[])object2);
                return;
            }
            float f4 = ((BaseTween)object2).isReverse(n) ? ((BaseTween)object2).duration - ((BaseTween)object2).getCurrentTime() : ((BaseTween)object2).getCurrentTime();
            f4 = ((Tween)object2).equation.compute(f4 / ((BaseTween)object2).duration);
            if (((Tween)object2).waypointsCnt != 0 && ((Tween)object2).path != null) {
                for (int i = 0; i < ((Tween)object2).combinedAttrsCnt; ++i) {
                    int n6;
                    ((Tween)object2).pathBuffer[0] = ((Tween)object2).startValues[i];
                    ((Tween)object2).pathBuffer[((Tween)object2).waypointsCnt + 1] = ((Tween)object2).targetValues[i];
                    n3 = 0;
                    while (n3 < (n6 = ((Tween)object2).waypointsCnt)) {
                        n6 = n3 + 1;
                        ((Tween)object2).pathBuffer[n6] = ((Tween)object2).waypoints[n3 * ((Tween)object2).combinedAttrsCnt + i];
                        n3 = n6;
                    }
                    ((Tween)object2).accessorBuffer[i] = ((Tween)object2).path.compute(f4, ((Tween)object2).pathBuffer, n6 + 2);
                }
            } else {
                for (int i = 0; i < ((Tween)object2).combinedAttrsCnt; ++i) {
                    float f5 = ((Tween)object2).startValues[i];
                    ((Tween)object2).accessorBuffer[i] = f5 + f4 * (((Tween)object2).targetValues[i] - f5);
                }
            }
            ((Tween)object2).accessor.setValues(((Tween)object2).target, ((Tween)object2).type, ((Tween)object2).accessorBuffer);
            return;
        }
    }

    @Override
    public void forceStartValues() {
        Object object = this.target;
        if (object == null) {
            return;
        }
        Tween tween = this;
        int n = tween.type;
        this.accessor.setValues(object, n, tween.startValues);
    }

    @Override
    public void forceEndValues() {
        Object object = this.target;
        if (object == null) {
            return;
        }
        Tween tween = this;
        int n = tween.type;
        this.accessor.setValues(object, n, tween.targetValues);
    }

    @Override
    public boolean containsTarget(Object object) {
        return this.target == object;
    }
}

