/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList;

import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.markers.KMappedMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;

public final class PersistentVectorMutableIterator
extends AbstractListIterator
implements ListIterator,
KMappedMarker {
    public final PersistentVectorBuilder builder;
    public int expectedModCount;
    public TrieIterator trieIterator;
    public int lastIteratedIndex;

    public PersistentVectorMutableIterator(PersistentVectorBuilder persistentVectorBuilder, int n) {
        PersistentVectorBuilder persistentVectorBuilder2 = persistentVectorBuilder;
        Intrinsics.checkNotNullParameter(persistentVectorBuilder2, "builder");
        super(n, persistentVectorBuilder2.size());
        this.builder = persistentVectorBuilder;
        this.expectedModCount = persistentVectorBuilder.getModCount$kotlinx_collections_immutable();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    private final void reset() {
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        persistentVectorMutableIterator.setSize(persistentVectorMutableIterator.builder.size());
        persistentVectorMutableIterator.expectedModCount = persistentVectorMutableIterator.builder.getModCount$kotlinx_collections_immutable();
        persistentVectorMutableIterator.lastIteratedIndex = -1;
        persistentVectorMutableIterator.setupTrieIterator();
    }

    private final void setupTrieIterator() {
        Object[] objectArray = abstractListIterator.builder.getRoot$kotlinx_collections_immutable();
        if (objectArray == null) {
            abstractListIterator.trieIterator = null;
            return;
        }
        PersistentVectorMutableIterator persistentVectorMutableIterator = abstractListIterator;
        int n = UtilsKt.rootSize(persistentVectorMutableIterator.builder.size());
        int n2 = RangesKt___RangesKt.coerceAtMost(persistentVectorMutableIterator.getIndex(), n);
        int n3 = persistentVectorMutableIterator.builder.getRootShift$kotlinx_collections_immutable() / 5 + 1;
        TrieIterator trieIterator = persistentVectorMutableIterator.trieIterator;
        if (trieIterator == null) {
            TrieIterator trieIterator2;
            PersistentVectorMutableIterator persistentVectorMutableIterator2 = abstractListIterator;
            AbstractListIterator abstractListIterator = trieIterator2;
            trieIterator2 = new TrieIterator(objectArray, n2, n, n3);
            persistentVectorMutableIterator2.trieIterator = abstractListIterator;
        } else {
            TrieIterator trieIterator3 = trieIterator;
            Intrinsics.checkNotNull(trieIterator3);
            trieIterator3.reset$kotlinx_collections_immutable(objectArray, n2, n, n3);
        }
    }

    private final void checkForComodification() {
        if (this.expectedModCount == this.builder.getModCount$kotlinx_collections_immutable()) {
            return;
        }
        throw new ConcurrentModificationException();
    }

    private final void checkHasIterated() {
        if (this.lastIteratedIndex != -1) {
            return;
        }
        throw new IllegalStateException();
    }

    public Object previous() {
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        persistentVectorMutableIterator.checkForComodification();
        persistentVectorMutableIterator.checkHasPrevious$kotlinx_collections_immutable();
        persistentVectorMutableIterator.lastIteratedIndex = persistentVectorMutableIterator.getIndex() - 1;
        TrieIterator trieIterator = persistentVectorMutableIterator.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            PersistentVectorMutableIterator persistentVectorMutableIterator2 = this;
            persistentVectorMutableIterator2.setIndex(persistentVectorMutableIterator2.getIndex() + -1);
            return objectArray[persistentVectorMutableIterator2.getIndex()];
        }
        if (this.getIndex() > trieIterator.getSize()) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            PersistentVectorMutableIterator persistentVectorMutableIterator3 = this;
            persistentVectorMutableIterator3.setIndex(persistentVectorMutableIterator3.getIndex() + -1);
            return objectArray[persistentVectorMutableIterator3.getIndex() - trieIterator.getSize()];
        }
        PersistentVectorMutableIterator persistentVectorMutableIterator4 = this;
        persistentVectorMutableIterator4.setIndex(persistentVectorMutableIterator4.getIndex() + -1);
        return trieIterator.previous();
    }

    @Override
    public Object next() {
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        persistentVectorMutableIterator.checkForComodification();
        persistentVectorMutableIterator.checkHasNext$kotlinx_collections_immutable();
        persistentVectorMutableIterator.lastIteratedIndex = persistentVectorMutableIterator.getIndex();
        TrieIterator trieIterator = persistentVectorMutableIterator.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            PersistentVectorMutableIterator persistentVectorMutableIterator2 = this;
            int n = persistentVectorMutableIterator2.getIndex();
            persistentVectorMutableIterator2.setIndex(n + 1);
            return objectArray[n];
        }
        if (trieIterator.hasNext()) {
            PersistentVectorMutableIterator persistentVectorMutableIterator3 = this;
            persistentVectorMutableIterator3.setIndex(persistentVectorMutableIterator3.getIndex() + 1);
            return trieIterator.next();
        }
        Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
        int n = this.getIndex();
        this.setIndex(n + 1);
        return objectArray[n - trieIterator.getSize()];
    }

    @Override
    public void add(Object object) {
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        persistentVectorMutableIterator.checkForComodification();
        persistentVectorMutableIterator.builder.add(this.getIndex(), object);
        persistentVectorMutableIterator.setIndex(persistentVectorMutableIterator.getIndex() + 1);
        persistentVectorMutableIterator.reset();
    }

    @Override
    public void remove() {
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        persistentVectorMutableIterator.checkForComodification();
        persistentVectorMutableIterator.checkHasIterated();
        persistentVectorMutableIterator.builder.remove(this.lastIteratedIndex);
        if (persistentVectorMutableIterator.lastIteratedIndex < this.getIndex()) {
            PersistentVectorMutableIterator persistentVectorMutableIterator2 = this;
            persistentVectorMutableIterator2.setIndex(persistentVectorMutableIterator2.lastIteratedIndex);
        }
        this.reset();
    }

    @Override
    public void set(Object object) {
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        persistentVectorMutableIterator.checkForComodification();
        persistentVectorMutableIterator.checkHasIterated();
        persistentVectorMutableIterator.builder.set(this.lastIteratedIndex, object);
        persistentVectorMutableIterator.expectedModCount = persistentVectorMutableIterator.builder.getModCount$kotlinx_collections_immutable();
        persistentVectorMutableIterator.setupTrieIterator();
    }
}

