/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.collections.builders;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.AbstractList;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.builders.ListBuilderKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.builders.MapBuilderEntries;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.builders.MapBuilderKeys;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.builders.MapBuilderValues;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.markers.KMappedMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.markers.KMutableMap;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;

public final class MapBuilder
implements Map,
Serializable,
KMutableMap {
    public static final Companion Companion = new Companion(null);
    public static final MapBuilder Empty;
    public Object[] keysArray;
    public Object[] valuesArray;
    public int[] presenceArray;
    public int[] hashArray;
    public int maxProbeDistance;
    public int length;
    public int hashShift;
    public int modCount;
    public int size;
    public MapBuilderKeys keysView;
    public MapBuilderValues valuesView;
    public MapBuilderEntries entriesView;
    public boolean isReadOnly;

    public MapBuilder(Object[] objectArray, Object[] objectArray2, int[] nArray, int[] nArray2, int n, int n2) {
        MapBuilder mapBuilder = this;
        this.keysArray = objectArray;
        this.valuesArray = objectArray2;
        this.presenceArray = nArray;
        this.hashArray = nArray2;
        this.maxProbeDistance = n;
        mapBuilder.length = n2;
        mapBuilder.hashShift = MapBuilder.Companion.computeShift(this.getHashSize());
    }

    public MapBuilder() {
        this(8);
    }

    public MapBuilder(int n) {
        Object[] objectArray = objectArray2;
        int n2 = n;
        Object[] objectArray2 = ListBuilderKt.arrayOfUninitializedElements(n2);
        int[] nArray = new int[n2];
        Object[] objectArray3 = objectArray2;
        objectArray2 = new int[MapBuilder.Companion.computeHashSize(n)];
        super(objectArray3, null, nArray, (int[])objectArray2, 2, 0);
    }

    public final int getHashSize() {
        return this.hashArray.length;
    }

    private final void registerModification() {
        ++this.modCount;
    }

    public final void ensureExtraCapacity(int n) {
        if (this.shouldCompact(n)) {
            this.compact(true);
        } else {
            MapBuilder mapBuilder = this;
            mapBuilder.ensureCapacity(mapBuilder.length + n);
        }
    }

    public final boolean shouldCompact(int n) {
        int n2 = this.length;
        int n3 = this.getCapacity$kotlin_stdlib() - n2;
        return n3 < n && (n2 -= this.size()) + n3 >= n && n2 >= this.getCapacity$kotlin_stdlib() / 4;
    }

    private final void ensureCapacity(int n) {
        if (n >= 0) {
            if (n > this.getCapacity$kotlin_stdlib()) {
                MapBuilder mapBuilder = this;
                n = AbstractList.Companion.newCapacity$kotlin_stdlib(this.getCapacity$kotlin_stdlib(), n);
                mapBuilder.keysArray = ListBuilderKt.copyOfUninitializedElements(mapBuilder.keysArray, n);
                Object object = mapBuilder.valuesArray;
                object = mapBuilder.valuesArray != null ? ListBuilderKt.copyOfUninitializedElements(object, n) : null;
                this.valuesArray = object;
                int[] nArray = Arrays.copyOf(this.presenceArray, n);
                Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
                this.presenceArray = nArray;
                n = MapBuilder.Companion.computeHashSize(n);
                if (n > this.getHashSize()) {
                    this.rehash(n);
                }
            }
            return;
        }
        throw new OutOfMemoryError();
    }

    public final Object[] allocateValuesArray() {
        Object[] objectArray = this.valuesArray;
        if (this.valuesArray != null) {
            return objectArray;
        }
        this.valuesArray = ListBuilderKt.arrayOfUninitializedElements(this.getCapacity$kotlin_stdlib());
        return this.valuesArray;
    }

    public final int hash(Object object) {
        return (object != null ? object.hashCode() : 0) * -1640531527 >>> this.hashShift;
    }

    public final void compact(boolean bl) {
        int n;
        int n2 = 0;
        Object[] objectArray = this.valuesArray;
        for (int i = 0; i < (n = this.length); ++i) {
            int[] nArray = this.presenceArray;
            int n3 = this.presenceArray[i];
            if (n3 < 0) continue;
            this.keysArray[n2] = this.keysArray[i];
            if (objectArray != null) {
                objectArray[n2] = objectArray[i];
            }
            if (bl) {
                nArray[n2] = n3;
                this.hashArray[n3] = n2 + 1;
            }
            ++n2;
        }
        ListBuilderKt.resetRange(this.keysArray, n2, n);
        if (objectArray != null) {
            ListBuilderKt.resetRange(objectArray, n2, this.length);
        }
        this.length = n2;
    }

    public final void rehash(int n) {
        MapBuilder mapBuilder = this;
        mapBuilder.registerModification();
        if (mapBuilder.length > this.size()) {
            this.compact(false);
        }
        MapBuilder mapBuilder2 = this;
        mapBuilder2.hashArray = new int[n];
        mapBuilder2.hashShift = MapBuilder.Companion.computeShift(n);
        n = 0;
        while (n < this.length) {
            if (this.putRehash(n++)) continue;
            throw new IllegalStateException("This cannot happen with fixed magic multiplier and grow-only hash array. Have object hashCodes changed?");
        }
    }

    public final boolean putRehash(int n) {
        MapBuilder mapBuilder = this;
        int n2 = mapBuilder.hash(mapBuilder.keysArray[n]);
        int n3 = mapBuilder.maxProbeDistance;
        while (true) {
            int[] nArray = this.hashArray;
            if (this.hashArray[n2] == 0) {
                nArray[n2] = n + 1;
                this.presenceArray[n] = n2;
                return true;
            }
            if ((n3 += -1) < 0) {
                return false;
            }
            int n4 = n2;
            n2 = n4 + -1;
            if (n4 != 0) continue;
            n2 = this.getHashSize() - 1;
        }
    }

    public final int findKey(Object object) {
        MapBuilder mapBuilder = this;
        int n = mapBuilder.hash(object);
        int n2 = mapBuilder.maxProbeDistance;
        int n3;
        while ((n3 = this.hashArray[n]) != 0) {
            if (n3 > 0 && Intrinsics.areEqual(this.keysArray[--n3], object)) {
                return n3;
            }
            if ((n2 += -1) < 0) {
                return -1;
            }
            int n4 = n;
            n = n4 + -1;
            if (n4 != 0) continue;
            n = this.getHashSize() - 1;
        }
        return -1;
    }

    public final int findValue(Object object) {
        int n = this.length;
        while ((n += -1) >= 0) {
            if (this.presenceArray[n] < 0) continue;
            Intrinsics.checkNotNull(this.valuesArray);
            if (!Intrinsics.areEqual(this.valuesArray[n], object)) continue;
            return n;
        }
        return -1;
    }

    public final void removeEntryAt(int n) {
        MapBuilder mapBuilder = this;
        ListBuilderKt.resetAt(mapBuilder.keysArray, n);
        Object[] objectArray = mapBuilder.valuesArray;
        if (mapBuilder.valuesArray != null) {
            ListBuilderKt.resetAt(objectArray, n);
        }
        MapBuilder mapBuilder2 = this;
        mapBuilder2.removeHashAt(mapBuilder2.presenceArray[n]);
        mapBuilder2.presenceArray[n] = -1;
        mapBuilder2.size = mapBuilder2.size() + -1;
        mapBuilder2.registerModification();
    }

    public final void removeHashAt(int n) {
        int n2 = 0;
        int n3 = RangesKt___RangesKt.coerceAtMost(this.maxProbeDistance * 2, this.getHashSize() / 2);
        int n4 = n2;
        int n5 = n3;
        n2 = n;
        n3 = n4;
        do {
            int n6 = n;
            n = n6 + -1;
            if (n6 == 0) {
                n = this.getHashSize() - 1;
            }
            if (++n3 > this.maxProbeDistance) {
                this.hashArray[n2] = 0;
                return;
            }
            int[] nArray = this.hashArray;
            int n7 = this.hashArray[n];
            if (n7 == 0) {
                nArray[n2] = 0;
                return;
            }
            if (n7 < 0) {
                nArray[n2] = -1;
                n3 = n2 = 0;
                n2 = n;
                continue;
            }
            MapBuilder mapBuilder = this;
            int n8 = n7 - 1;
            if ((mapBuilder.hash(mapBuilder.keysArray[n8]) - n & this.getHashSize() - 1) < n3) continue;
            MapBuilder mapBuilder2 = this;
            mapBuilder2.hashArray[n2] = n7;
            mapBuilder2.presenceArray[n8] = n2;
            n3 = n2 = 0;
            n2 = n;
        } while ((n5 += -1) >= 0);
        this.hashArray[n2] = -1;
    }

    public final boolean contentEquals(Map map2) {
        return this.size() == map2.size() && this.containsAllEntries$kotlin_stdlib(map2.entrySet());
    }

    public final boolean putEntry(Map.Entry entry) {
        int n = objectArray.addKey$kotlin_stdlib(entry.getKey());
        Object[] objectArray = objectArray.allocateValuesArray();
        if (n >= 0) {
            objectArray[n] = entry.getValue();
            return true;
        }
        n = -n - 1;
        Object object = objectArray[n];
        if (!Intrinsics.areEqual(entry.getValue(), object)) {
            objectArray[n] = entry.getValue();
            return true;
        }
        return false;
    }

    public final boolean putAllEntries(Collection object) {
        if (object.isEmpty()) {
            return false;
        }
        this.ensureExtraCapacity(object.size());
        object = object.iterator();
        boolean bl = false;
        while (object.hasNext()) {
            if (!this.putEntry((Map.Entry)object.next())) continue;
            bl = true;
        }
        return bl;
    }

    static {
        new MapBuilder(0).isReadOnly = true;
        Empty = new MapBuilder(0);
    }

    public int getSize() {
        return this.size;
    }

    public final Map build() {
        MapBuilder mapBuilder = mapBuilder2;
        mapBuilder.checkIsMutable$kotlin_stdlib();
        mapBuilder.isReadOnly = true;
        if (mapBuilder.size() <= 0) {
            MapBuilder mapBuilder2 = Empty;
            Intrinsics.checkNotNull(mapBuilder2, "null cannot be cast to non-null type kotlin.collections.Map<K of kotlin.collections.builders.MapBuilder, V of kotlin.collections.builders.MapBuilder>");
        }
        return mapBuilder2;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.findKey(object) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.findValue(object) >= 0;
    }

    public Object get(Object object) {
        int n = this.findKey(object);
        if (n < 0) {
            return null;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        return this.valuesArray[n];
    }

    public Object put(Object object, Object object2) {
        objectArray.checkIsMutable$kotlin_stdlib();
        int n = objectArray.addKey$kotlin_stdlib(object);
        Object[] objectArray = objectArray.allocateValuesArray();
        if (n < 0) {
            n = -n - 1;
            objectArray[n] = object2;
            return objectArray[n];
        }
        objectArray[n] = object2;
        return null;
    }

    public void putAll(Map map2) {
        Intrinsics.checkNotNullParameter(map2, "from");
        this.checkIsMutable$kotlin_stdlib();
        this.putAllEntries(map2.entrySet());
    }

    public Object remove(Object object) {
        MapBuilder mapBuilder = this;
        mapBuilder.checkIsMutable$kotlin_stdlib();
        int n = mapBuilder.findKey(object);
        if (n < 0) {
            return null;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        Object object2 = this.valuesArray[n];
        this.removeEntryAt(n);
        return object2;
    }

    @Override
    public void clear() {
        MapBuilder mapBuilder = this;
        mapBuilder.checkIsMutable$kotlin_stdlib();
        int n = 0;
        int n2 = mapBuilder.length - 1;
        if (n2 >= 0) {
            while (true) {
                int[] nArray = this.presenceArray;
                int n3 = this.presenceArray[n];
                if (n3 >= 0) {
                    this.hashArray[n3] = 0;
                    nArray[n] = -1;
                }
                if (n == n2) break;
                ++n;
            }
        }
        MapBuilder mapBuilder2 = this;
        ListBuilderKt.resetRange(mapBuilder2.keysArray, 0, this.length);
        Object[] objectArray = mapBuilder2.valuesArray;
        if (mapBuilder2.valuesArray != null) {
            ListBuilderKt.resetRange(objectArray, 0, this.length);
        }
        this.size = 0;
        this.length = 0;
        this.registerModification();
    }

    public Set getKeys() {
        MapBuilderKeys mapBuilderKeys = this.keysView;
        if (mapBuilderKeys == null) {
            MapBuilderKeys mapBuilderKeys2;
            mapBuilderKeys = mapBuilderKeys2;
            mapBuilderKeys2 = new MapBuilderKeys(this);
            this.keysView = mapBuilderKeys;
        }
        return mapBuilderKeys;
    }

    public Collection getValues() {
        MapBuilderValues mapBuilderValues = this.valuesView;
        if (mapBuilderValues == null) {
            MapBuilderValues mapBuilderValues2;
            mapBuilderValues = mapBuilderValues2;
            mapBuilderValues2 = new MapBuilderValues(this);
            this.valuesView = mapBuilderValues;
        }
        return mapBuilderValues;
    }

    public Set getEntries() {
        MapBuilderEntries mapBuilderEntries = this.entriesView;
        if (mapBuilderEntries == null) {
            MapBuilderEntries mapBuilderEntries2;
            mapBuilderEntries = mapBuilderEntries2;
            mapBuilderEntries(this);
            this.entriesView = mapBuilderEntries;
            return mapBuilderEntries2;
        }
        return mapBuilderEntries;
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof Map && this.contentEquals((Map)object);
    }

    @Override
    public int hashCode() {
        int n = 0;
        EntriesItr entriesItr = this.entriesIterator$kotlin_stdlib();
        while (entriesItr.hasNext()) {
            n += entriesItr.nextHashCode$kotlin_stdlib();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder(this.size() * 3 + 2).append("{");
        int n = 0;
        EntriesItr entriesItr = this.entriesIterator$kotlin_stdlib();
        while (entriesItr.hasNext()) {
            if (n > 0) {
                stringBuilder2.append(", ");
            }
            entriesItr.nextAppendString(stringBuilder2);
            ++n;
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("}");
        String string = stringBuilder3.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final int getCapacity$kotlin_stdlib() {
        return this.keysArray.length;
    }

    public final void checkIsMutable$kotlin_stdlib() {
        if (!this.isReadOnly) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    public final int addKey$kotlin_stdlib(Object object) {
        this.checkIsMutable$kotlin_stdlib();
        block0: while (true) {
            int n = this.hash(object);
            int n2 = RangesKt___RangesKt.coerceAtMost(this.maxProbeDistance * 2, this.getHashSize() / 2);
            int n3 = 0;
            while (true) {
                int n4;
                if ((n4 = this.hashArray[n]) <= 0) {
                    if (this.length >= this.getCapacity$kotlin_stdlib()) {
                        this.ensureExtraCapacity(1);
                        continue block0;
                    }
                    n2 = this.length;
                    this.length = n4 = n2 + 1;
                    this.keysArray[n2] = object;
                    this.presenceArray[n2] = n;
                    this.hashArray[n] = n4;
                    this.size = this.size() + 1;
                    this.registerModification();
                    if (n3 > this.maxProbeDistance) {
                        this.maxProbeDistance = n3;
                    }
                    return n2;
                }
                if (Intrinsics.areEqual(this.keysArray[n4 - 1], object)) {
                    return -n4;
                }
                if (++n3 > n2) {
                    this.rehash(this.getHashSize() * 2);
                    continue block0;
                }
                int n5 = n;
                n = n5 + -1;
                if (n5 != 0) continue;
                n = this.getHashSize() - 1;
            }
            break;
        }
    }

    public final boolean removeKey$kotlin_stdlib(Object object) {
        MapBuilder mapBuilder = this;
        mapBuilder.checkIsMutable$kotlin_stdlib();
        int n = mapBuilder.findKey(object);
        if (n < 0) {
            return false;
        }
        this.removeEntryAt(n);
        return true;
    }

    public final boolean containsEntry$kotlin_stdlib(Map.Entry entry) {
        Map.Entry entry2 = entry;
        Intrinsics.checkNotNullParameter(entry2, "entry");
        int n = this.findKey(entry2.getKey());
        if (n < 0) {
            return false;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        return Intrinsics.areEqual(this.valuesArray[n], entry.getValue());
    }

    public final boolean containsAllEntries$kotlin_stdlib(Collection object) {
        Collection collection = object;
        Intrinsics.checkNotNullParameter(collection, "m");
        for (Object e : collection) {
            if (e != null) {
                try {
                    if (this.containsEntry$kotlin_stdlib((Map.Entry)e)) continue;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public final boolean removeEntry$kotlin_stdlib(Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        this.checkIsMutable$kotlin_stdlib();
        int n = this.findKey(entry.getKey());
        if (n < 0) {
            return false;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        if (!Intrinsics.areEqual(this.valuesArray[n], entry.getValue())) {
            return false;
        }
        this.removeEntryAt(n);
        return true;
    }

    public final boolean removeValue$kotlin_stdlib(Object object) {
        MapBuilder mapBuilder = this;
        mapBuilder.checkIsMutable$kotlin_stdlib();
        int n = mapBuilder.findValue(object);
        if (n < 0) {
            return false;
        }
        this.removeEntryAt(n);
        return true;
    }

    public final KeysItr keysIterator$kotlin_stdlib() {
        return new KeysItr(this);
    }

    public final ValuesItr valuesIterator$kotlin_stdlib() {
        return new ValuesItr(this);
    }

    public final EntriesItr entriesIterator$kotlin_stdlib() {
        return new EntriesItr(this);
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final MapBuilder getEmpty$kotlin_stdlib() {
            return Empty;
        }

        public final int computeHashSize(int n) {
            return Integer.highestOneBit(RangesKt___RangesKt.coerceAtLeast(n, 1) * 3);
        }

        public final int computeShift(int n) {
            return Integer.numberOfLeadingZeros(n) + 1;
        }
    }

    public static final class EntriesItr
    extends Itr
    implements Iterator,
    KMappedMarker {
        public EntriesItr(MapBuilder mapBuilder) {
            Intrinsics.checkNotNullParameter(mapBuilder, "map");
            super(mapBuilder);
        }

        public EntryRef next() {
            EntriesItr entriesItr = kMappedMarker;
            entriesItr.checkForComodification$kotlin_stdlib();
            if (entriesItr.getIndex$kotlin_stdlib() < kMappedMarker.getMap$kotlin_stdlib().length) {
                EntriesItr entriesItr2 = kMappedMarker;
                int n = entriesItr2.getIndex$kotlin_stdlib();
                entriesItr2.setIndex$kotlin_stdlib(n + 1);
                entriesItr2.setLastIndex$kotlin_stdlib(n);
                EntriesItr entriesItr3 = kMappedMarker;
                KMappedMarker kMappedMarker = entriesItr3.getMap$kotlin_stdlib();
                EntryRef entryRef = new EntryRef((MapBuilder)kMappedMarker, entriesItr3.getLastIndex$kotlin_stdlib());
                kMappedMarker.initNext$kotlin_stdlib();
                return entryRef;
            }
            throw new NoSuchElementException();
        }

        public final int nextHashCode$kotlin_stdlib() {
            if (this.getIndex$kotlin_stdlib() < this.getMap$kotlin_stdlib().length) {
                EntriesItr entriesItr = this;
                int n = entriesItr.getIndex$kotlin_stdlib();
                entriesItr.setIndex$kotlin_stdlib(n + 1);
                entriesItr.setLastIndex$kotlin_stdlib(n);
                Object object = entriesItr.getMap$kotlin_stdlib().keysArray[this.getLastIndex$kotlin_stdlib()];
                int n2 = object != null ? object.hashCode() : 0;
                Object[] objectArray = this.getMap$kotlin_stdlib().valuesArray;
                Intrinsics.checkNotNull(objectArray);
                Object object2 = objectArray[this.getLastIndex$kotlin_stdlib()];
                int n3 = object2 != null ? object2.hashCode() : 0;
                this.initNext$kotlin_stdlib();
                return n2 ^ n3;
            }
            throw new NoSuchElementException();
        }

        public final void nextAppendString(StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter(stringBuilder, "sb");
            if (this.getIndex$kotlin_stdlib() < this.getMap$kotlin_stdlib().length) {
                EntriesItr entriesItr = this;
                int n = entriesItr.getIndex$kotlin_stdlib();
                entriesItr.setIndex$kotlin_stdlib(n + 1);
                entriesItr.setLastIndex$kotlin_stdlib(n);
                Object object = entriesItr.getMap$kotlin_stdlib().keysArray[this.getLastIndex$kotlin_stdlib()];
                if (object == this.getMap$kotlin_stdlib()) {
                    stringBuilder.append("(this Map)");
                } else {
                    stringBuilder.append(object);
                }
                stringBuilder.append('=');
                Object[] objectArray = this.getMap$kotlin_stdlib().valuesArray;
                Intrinsics.checkNotNull(objectArray);
                object = objectArray[this.getLastIndex$kotlin_stdlib()];
                if (object == this.getMap$kotlin_stdlib()) {
                    stringBuilder.append("(this Map)");
                } else {
                    stringBuilder.append(object);
                }
                this.initNext$kotlin_stdlib();
                return;
            }
            throw new NoSuchElementException();
        }
    }

    public static final class EntryRef
    implements Map.Entry,
    KMappedMarker {
        public final MapBuilder map;
        public final int index;
        public final int expectedModCount;

        public EntryRef(MapBuilder mapBuilder, int n) {
            Intrinsics.checkNotNullParameter(mapBuilder, "map");
            this.map = mapBuilder;
            this.index = n;
            this.expectedModCount = mapBuilder.modCount;
        }

        private final void checkForComodification() {
            if (this.map.modCount == this.expectedModCount) {
                return;
            }
            throw new ConcurrentModificationException("The backing map has been modified after this entry was obtained.");
        }

        public Object getKey() {
            EntryRef entryRef = this;
            entryRef.checkForComodification();
            return entryRef.map.keysArray[this.index];
        }

        public Object getValue() {
            EntryRef entryRef = this;
            entryRef.checkForComodification();
            Object[] objectArray = entryRef.map.valuesArray;
            Intrinsics.checkNotNull(objectArray);
            return objectArray[this.index];
        }

        public Object setValue(Object object) {
            EntryRef entryRef = this;
            entryRef.checkForComodification();
            entryRef.map.checkIsMutable$kotlin_stdlib();
            Object[] objectArray = entryRef.map.allocateValuesArray();
            int n = this.index;
            objectArray[n] = object;
            return objectArray[n];
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Map.Entry && Intrinsics.areEqual((object = (Map.Entry)object).getKey(), this.getKey()) && Intrinsics.areEqual(object.getValue(), this.getValue());
        }

        @Override
        public int hashCode() {
            Object object = ((EntryRef)object2).getKey();
            int n = object != null ? object.hashCode() : 0;
            Object object2 = ((EntryRef)object2).getValue();
            int n2 = object2 != null ? object2.hashCode() : 0;
            return n ^ n2;
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    public static abstract class Itr {
        public final MapBuilder map;
        public int index;
        public int lastIndex;
        public int expectedModCount;

        public Itr(MapBuilder mapBuilder) {
            Itr itr = this;
            Intrinsics.checkNotNullParameter(mapBuilder, "map");
            itr.map = mapBuilder;
            itr.lastIndex = -1;
            this.expectedModCount = mapBuilder.modCount;
            this.initNext$kotlin_stdlib();
        }

        public final MapBuilder getMap$kotlin_stdlib() {
            return this.map;
        }

        public final int getIndex$kotlin_stdlib() {
            return this.index;
        }

        public final void setIndex$kotlin_stdlib(int n) {
            this.index = n;
        }

        public final int getLastIndex$kotlin_stdlib() {
            return this.lastIndex;
        }

        public final void setLastIndex$kotlin_stdlib(int n) {
            this.lastIndex = n;
        }

        public final void initNext$kotlin_stdlib() {
            while (this.index < this.map.length) {
                int n = this.index;
                if (this.map.presenceArray[n] >= 0) break;
                this.index = n + 1;
            }
        }

        public final boolean hasNext() {
            return this.index < this.map.length;
        }

        public final void remove() {
            Itr itr = this;
            itr.checkForComodification$kotlin_stdlib();
            if (itr.lastIndex != -1) {
                Itr itr2 = this;
                itr2.map.checkIsMutable$kotlin_stdlib();
                itr2.map.removeEntryAt(this.lastIndex);
                itr2.lastIndex = -1;
                itr2.expectedModCount = itr2.map.modCount;
                return;
            }
            throw new IllegalStateException("Call next() before removing element from the iterator.".toString());
        }

        public final void checkForComodification$kotlin_stdlib() {
            if (this.map.modCount == this.expectedModCount) {
                return;
            }
            throw new ConcurrentModificationException();
        }
    }

    public static final class KeysItr
    extends Itr
    implements Iterator,
    KMappedMarker {
        public KeysItr(MapBuilder mapBuilder) {
            Intrinsics.checkNotNullParameter(mapBuilder, "map");
            super(mapBuilder);
        }

        public Object next() {
            KeysItr keysItr = this;
            keysItr.checkForComodification$kotlin_stdlib();
            if (keysItr.getIndex$kotlin_stdlib() < this.getMap$kotlin_stdlib().length) {
                KeysItr keysItr2 = this;
                int n = keysItr2.getIndex$kotlin_stdlib();
                keysItr2.setIndex$kotlin_stdlib(n + 1);
                keysItr2.setLastIndex$kotlin_stdlib(n);
                Object object = keysItr2.getMap$kotlin_stdlib().keysArray[this.getLastIndex$kotlin_stdlib()];
                this.initNext$kotlin_stdlib();
                return object;
            }
            throw new NoSuchElementException();
        }
    }

    public static final class ValuesItr
    extends Itr
    implements Iterator,
    KMappedMarker {
        public ValuesItr(MapBuilder mapBuilder) {
            Intrinsics.checkNotNullParameter(mapBuilder, "map");
            super(mapBuilder);
        }

        public Object next() {
            ValuesItr valuesItr = this;
            valuesItr.checkForComodification$kotlin_stdlib();
            if (valuesItr.getIndex$kotlin_stdlib() < this.getMap$kotlin_stdlib().length) {
                ValuesItr valuesItr2 = this;
                int n = valuesItr2.getIndex$kotlin_stdlib();
                valuesItr2.setIndex$kotlin_stdlib(n + 1);
                valuesItr2.setLastIndex$kotlin_stdlib(n);
                Object[] objectArray = valuesItr2.getMap$kotlin_stdlib().valuesArray;
                Intrinsics.checkNotNull(objectArray);
                Object object = objectArray[this.getLastIndex$kotlin_stdlib()];
                this.initNext$kotlin_stdlib();
                return object;
            }
            throw new NoSuchElementException();
        }
    }
}

