/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.platform;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import top.fifthlight.touchcontroller.common.gal.GlfwPlatform;
import top.fifthlight.touchcontroller.common.gal.NativeLibraryPathGetter;
import top.fifthlight.touchcontroller.common.gal.PlatformWindowProvider;
import top.fifthlight.touchcontroller.common.platform.Platform;
import top.fifthlight.touchcontroller.common.platform.PlatformProvider$special$;
import top.fifthlight.touchcontroller.common.platform.android.AndroidPlatform;
import top.fifthlight.touchcontroller.common.platform.proxy.ProxyPlatform;
import top.fifthlight.touchcontroller.common.platform.wayland.WaylandPlatform;
import top.fifthlight.touchcontroller.common.platform.win32.Win32Platform;
import top.fifthlight.touchcontroller.proxy.server.LauncherSocketProxyServer;
import top.fifthlight.touchcontroller.proxy.server.LauncherSocketProxyServerKt;
import top.fifthlight.touchcontroller.relocated.kotlin.KotlinNothingValueException;
import top.fifthlight.touchcontroller.relocated.kotlin.Lazy;
import top.fifthlight.touchcontroller.relocated.kotlin.LazyKt__LazyJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.NoWhenBranchMatchedException;
import top.fifthlight.touchcontroller.relocated.kotlin.Pair;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.SetsKt__SetsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.io.path.PathsKt__PathUtilsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function0;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function1;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Reflection;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringNumberConversionsKt;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.text.StringsKt__StringsKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.coroutines.GlobalScope;
import top.fifthlight.touchcontroller.relocated.org.koin.core.Koin;
import top.fifthlight.touchcontroller.relocated.org.koin.core.component.KoinComponent;
import top.fifthlight.touchcontroller.relocated.org.koin.core.qualifier.Qualifier;
import top.fifthlight.touchcontroller.relocated.org.koin.mp.KoinPlatformTools;
import top.fifthlight.touchcontroller.relocated.org.slf4j.Logger;
import top.fifthlight.touchcontroller.relocated.org.slf4j.LoggerFactory;

public final class PlatformProvider
implements KoinComponent {
    public final Lazy nativeLibraryPathGetter$delegate;
    public final Logger logger;
    public final Lazy isAndroid$delegate;
    public boolean platformLoaded;
    public Platform platform;

    public PlatformProvider() {
        PlatformProvider platformProvider = this;
        platformProvider.nativeLibraryPathGetter$delegate = LazyKt__LazyJVMKt.lazy(KoinPlatformTools.INSTANCE.defaultLazyMode(), new Function0(this, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$1 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(NativeLibraryPathGetter.class), qualifier, function0);
            }
        });
        platformProvider.logger = LoggerFactory.getLogger(PlatformProvider.class);
        platformProvider.isAndroid$delegate = LazyKt__LazyJVMKt.lazy(() -> PlatformProvider.isAndroid_delegate$lambda$0(platformProvider));
    }

    public static final boolean isAndroid_delegate$lambda$0(PlatformProvider platformProvider) {
        boolean bl;
        block4: {
            SecurityException securityException2;
            Object object;
            block6: {
                String[] stringArray = new String[2];
                object = stringArray;
                stringArray[0] = "system";
                stringArray[1] = "build.prop";
                object = Paths.get("/", object);
                Intrinsics.checkNotNull(object);
                int n = 0;
                try {
                    bl = Files.exists((Path)object, Arrays.copyOf(new LinkOption[0], n));
                    break block4;
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException2) {
                    break block6;
                }
                platformProvider.logger.info("Failed to access " + object + ", may running on Android", iOException);
                bl = true;
                break block4;
            }
            platformProvider.logger.info("Failed to access " + object + ", may running on Android", securityException2);
            bl = true;
        }
        return bl;
    }

    public static final Platform probeNativeLibraryInfo$lambda$6(String string) {
        return new AndroidPlatform(string);
    }

    public static final Platform probeNativeLibraryInfo$lambda$8(GlfwPlatform glfwPlatform) {
        return new Win32Platform(((GlfwPlatform.Win32)glfwPlatform).getNativeWindow());
    }

    public static final Platform probeNativeLibraryInfo$lambda$10(GlfwPlatform glfwPlatform) {
        if ((glfwPlatform = (GlfwPlatform.Wayland)glfwPlatform) instanceof GlfwPlatform.Wayland) {
            return new WaylandPlatform(((GlfwPlatform.Wayland)glfwPlatform).getNativeWindow());
        }
        throw new AssertionError();
    }

    public static final /* synthetic */ void access$posixReadOnlySetter(PlatformProvider platformProvider, Path path) {
        platformProvider.posixReadOnlySetter(path);
    }

    public static final /* synthetic */ void access$windowsReadOnlySetter(PlatformProvider platformProvider, Path path) {
        platformProvider.windowsReadOnlySetter(path);
    }

    public final Platform getPlatform() {
        return this.platform;
    }

    public final void load(PlatformWindowProvider platformWindowProvider) {
        Intrinsics.checkNotNullParameter(platformWindowProvider, "windowProvider");
        if (this.platformLoaded) {
            return;
        }
        this.platform = this.loadPlatform(platformWindowProvider);
        this.platformLoaded = true;
    }

    @Override
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    public final NativeLibraryPathGetter getNativeLibraryPathGetter() {
        return (NativeLibraryPathGetter)this.nativeLibraryPathGetter$delegate.getValue();
    }

    public final boolean isAndroid() {
        return (Boolean)this.isAndroid$delegate.getValue();
    }

    /*
     * Exception decompiling
     */
    public final Path extractNativeLibrary(String var1_4, String var2_6, InputStream var3_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [8 : 111->117)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void windowsReadOnlySetter(Path path) {
        Object object = DosFileAttributeView.class;
        if ((object = Files.getFileAttributeView(path, object, Arrays.copyOf(new LinkOption[0], 0))) != null) {
            ((DosFileAttributeView)object).setReadOnly(true);
            return;
        }
        PathsKt__PathUtilsKt.fileAttributeViewNotAvailable(path, DosFileAttributeView.class);
        throw new KotlinNothingValueException();
    }

    public final void posixReadOnlySetter(Path path) {
        Object object = PosixFileAttributeView.class;
        if ((object = Files.getFileAttributeView(path, object, Arrays.copyOf(new LinkOption[0], 0))) != null) {
            ((PosixFileAttributeView)object).setPermissions(SetsKt__SetsKt.setOf((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE}));
            return;
        }
        PathsKt__PathUtilsKt.fileAttributeViewNotAvailable(path, PosixFileAttributeView.class);
        throw new KotlinNothingValueException();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final NativeLibraryInfo probeNativeLibraryInfo(PlatformWindowProvider object) {
        boolean bl;
        Object object2;
        Object object3;
        Object object4;
        block80: {
            block79: {
                int n;
                block76: {
                    Function1 function1;
                    block78: {
                        block77: {
                            block73: {
                                Function1 function12;
                                block75: {
                                    block74: {
                                        object4 = System.getProperty("os.name");
                                        object3 = System.getProperty("os.arch");
                                        ((PlatformProvider)object2).logger.info("System name: " + (String)object4 + ", system arch: " + (String)object3);
                                        Intrinsics.checkNotNull(object4);
                                        if ((!StringsKt__StringsJVMKt.startsWith$default((String)object4, "Linux", false, 2, null) || !((PlatformProvider)object2).isAndroid()) && !StringsKt__StringsKt.contains((CharSequence)object4, "Android", true)) break block73;
                                        ((PlatformProvider)object2).logger.info("Android detected");
                                        object = System.getenv("TOUCH_CONTROLLER_PROXY_SOCKET");
                                        if (object == null || object.length() <= 0) {
                                            object = null;
                                        }
                                        if (object == null) {
                                            ((PlatformProvider)object2).logger.info("No TOUCH_CONTROLLER_PROXY_SOCKET environment set, TouchController will not be loaded");
                                            return null;
                                        }
                                        if (object3 == null) break block74;
                                        n = -1;
                                        switch (((String)object3).hashCode()) {
                                            case 145444210: {
                                                if (!((String)object3).equals("armeabi-v7a")) break;
                                                n = 1;
                                                break;
                                            }
                                            case 93085786: {
                                                if (!((String)object3).equals("armhf")) break;
                                                n = 1;
                                                break;
                                            }
                                            case 93085699: {
                                                if (!((String)object3).equals("armel")) break;
                                                n = 1;
                                                break;
                                            }
                                            case 93084186: {
                                                if (!((String)object3).equals("arm64")) break;
                                                n = 2;
                                                break;
                                            }
                                            case 92926582: {
                                                if (!((String)object3).equals("amd64")) break;
                                                n = 3;
                                                break;
                                            }
                                            case 3181739: {
                                                if (!((String)object3).equals("i686")) break;
                                                n = 4;
                                                break;
                                            }
                                            case 3180778: {
                                                if (!((String)object3).equals("i586")) break;
                                                n = 4;
                                                break;
                                            }
                                            case 3179817: {
                                                if (!((String)object3).equals("i486")) break;
                                                n = 4;
                                                break;
                                            }
                                            case 3178856: {
                                                if (!((String)object3).equals("i386")) break;
                                                n = 4;
                                                break;
                                            }
                                            case 117110: {
                                                if (!((String)object3).equals("x86")) break;
                                                n = 4;
                                                break;
                                            }
                                            case 96860: {
                                                if (!((String)object3).equals("arm")) break;
                                                n = 1;
                                                break;
                                            }
                                            case -738963905: {
                                                if (!((String)object3).equals("armeabi")) break;
                                                n = 1;
                                                break;
                                            }
                                            case -806050265: {
                                                if (!((String)object3).equals("x86_64")) break;
                                                n = 3;
                                                break;
                                            }
                                            case -806050360: {
                                                if (!((String)object3).equals("x86_32")) break;
                                                n = 4;
                                                break;
                                            }
                                            case -1221096139: {
                                                if (!((String)object3).equals("aarch64")) break;
                                                n = 2;
                                                break;
                                            }
                                        }
                                        switch (n) {
                                            default: {
                                                break;
                                            }
                                            case 1: {
                                                object4 = "armv7-linux-androideabi";
                                                break block75;
                                            }
                                            case 3: {
                                                object4 = "x86_64-linux-android";
                                                break block75;
                                            }
                                            case 4: {
                                                object4 = "i686-linux-android";
                                                break block75;
                                            }
                                            case 2: {
                                                object4 = "aarch64-linux-android";
                                                break block75;
                                            }
                                        }
                                    }
                                    object4 = null;
                                }
                                if (object4 == null) {
                                    ((PlatformProvider)object2).logger.warn("Unsupported Android arch");
                                    return null;
                                }
                                Object object5 = object;
                                object = (String)object4 + "/libproxy_server_android.so";
                                object4 = function12;
                                function12 = new Function1(object2){

                                    public final void invoke(Path path) {
                                        Intrinsics.checkNotNullParameter(path, "p0");
                                        PlatformProvider.access$posixReadOnlySetter((PlatformProvider)this.receiver, path);
                                    }
                                };
                                object2 = () -> PlatformProvider.probeNativeLibraryInfo$lambda$6((String)object5);
                                return new NativeLibraryInfo((String)object, null, "libproxy_server_android", ".so", (Function1)object4, true, (Function0)object2);
                            }
                            if (!((object = object.getPlatform()) instanceof GlfwPlatform.Win32)) break block76;
                            if (object3 == null) break block77;
                            tmp = -1;
                            switch (((String)object3).hashCode()) {
                                case 93084186: {
                                    if (!((String)object3).equals("arm64")) break;
                                    tmp = 1;
                                    break;
                                }
                                case 92926582: {
                                    if (!((String)object3).equals("amd64")) break;
                                    tmp = 2;
                                    break;
                                }
                                case 3181739: {
                                    if (!((String)object3).equals("i686")) break;
                                    tmp = 3;
                                    break;
                                }
                                case 3180778: {
                                    if (!((String)object3).equals("i586")) break;
                                    tmp = 3;
                                    break;
                                }
                                case 3179817: {
                                    if (!((String)object3).equals("i486")) break;
                                    tmp = 3;
                                    break;
                                }
                                case 3178856: {
                                    if (!((String)object3).equals("i386")) break;
                                    tmp = 3;
                                    break;
                                }
                                case 117110: {
                                    if (!((String)object3).equals("x86")) break;
                                    tmp = 3;
                                    break;
                                }
                                case -806050265: {
                                    if (!((String)object3).equals("x86_64")) break;
                                    tmp = 2;
                                    break;
                                }
                                case -806050360: {
                                    if (!((String)object3).equals("x86_32")) break;
                                    tmp = 3;
                                    break;
                                }
                                case -1221096139: {
                                    if (!((String)object3).equals("aarch64")) break;
                                    tmp = 1;
                                    break;
                                }
                            }
                            switch (tmp) {
                                default: {
                                    break;
                                }
                                case 2: {
                                    Pair pair;
                                    object4 = pair;
                                    pair = new Pair("x86_64-w64-mingw32", "x86_64");
                                    break block78;
                                }
                                case 3: {
                                    Pair pair;
                                    object4 = pair;
                                    pair = new Pair("i686-w64-mingw32", "i686");
                                    break block78;
                                }
                                case 1: {
                                    Pair pair;
                                    object4 = pair;
                                    pair = new Pair("aarch64-w64-mingw32", "aarch64");
                                    break block78;
                                }
                            }
                        }
                        object4 = null;
                    }
                    if (object4 == null) {
                        ((PlatformProvider)object2).logger.warn("Unsupported Windows arch: " + (String)object3);
                        return null;
                    }
                    String string = object4;
                    object4 = (String)((Pair)((Object)string)).component1();
                    object3 = (String)((Pair)((Object)string)).component2();
                    ((PlatformProvider)object2).logger.info("Target arch: " + (String)object4);
                    Object object6 = object;
                    object = (String)object4 + "/libproxy_windows.dll";
                    String[] stringArray = new String[8];
                    object4 = stringArray;
                    stringArray[0] = "..";
                    stringArray[1] = "..";
                    stringArray[2] = "..";
                    stringArray[3] = "proxy-windows";
                    stringArray[4] = "build";
                    stringArray[5] = "cmake";
                    stringArray[6] = object3;
                    stringArray[7] = "libproxy_windows.dll";
                    object4 = Paths.get("..", object4);
                    object3 = function1;
                    function1 = new Function1(object2){

                        public final void invoke(Path path) {
                            Intrinsics.checkNotNullParameter(path, "p0");
                            PlatformProvider.access$windowsReadOnlySetter((PlatformProvider)this.receiver, path);
                        }
                    };
                    object2 = () -> PlatformProvider.probeNativeLibraryInfo$lambda$8((GlfwPlatform)object6);
                    return new NativeLibraryInfo((String)object, (Path)object4, "libproxy_windows", ".dll", (Function1)object3, false, (Function0)object2);
                }
                bl = object instanceof GlfwPlatform.Wayland;
                if (!bl && !Intrinsics.areEqual(object, GlfwPlatform.X11.INSTANCE)) {
                    if (Intrinsics.areEqual(object, GlfwPlatform.Cocoa.INSTANCE)) {
                        ((PlatformProvider)object2).logger.warn("macOS is not supported for now");
                        return null;
                    }
                    if (Intrinsics.areEqual(object, GlfwPlatform.Unknown.INSTANCE)) {
                        ((PlatformProvider)object2).logger.warn("Unsupported system: " + (String)object4);
                        return null;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                if (object3 == null) break block79;
                tmp = -1;
                switch (((String)object3).hashCode()) {
                    case 93086174: {
                        if (!((String)object3).equals("armv8")) break;
                        tmp = 1;
                        break;
                    }
                    case 93086173: {
                        if (!((String)object3).equals("armv7")) break;
                        tmp = 2;
                        break;
                    }
                    case 93085786: {
                        if (!((String)object3).equals("armhf")) break;
                        tmp = 2;
                        break;
                    }
                    case 93085699: {
                        if (!((String)object3).equals("armel")) break;
                        tmp = 2;
                        break;
                    }
                    case 93084186: {
                        if (!((String)object3).equals("arm64")) break;
                        tmp = 1;
                        break;
                    }
                    case 92926582: {
                        if (!((String)object3).equals("amd64")) break;
                        tmp = 3;
                        break;
                    }
                    case 3181739: {
                        if (!((String)object3).equals("i686")) break;
                        tmp = 4;
                        break;
                    }
                    case 3180778: {
                        if (!((String)object3).equals("i586")) break;
                        tmp = 4;
                        break;
                    }
                    case 3179817: {
                        if (!((String)object3).equals("i486")) break;
                        tmp = 4;
                        break;
                    }
                    case 3178856: {
                        if (!((String)object3).equals("i386")) break;
                        tmp = 4;
                        break;
                    }
                    case 117110: {
                        if (!((String)object3).equals("x86")) break;
                        tmp = 4;
                        break;
                    }
                    case 96860: {
                        if (!((String)object3).equals("arm")) break;
                        tmp = 2;
                        break;
                    }
                    case -806050265: {
                        if (!((String)object3).equals("x86_64")) break;
                        tmp = 3;
                        break;
                    }
                    case -806050360: {
                        if (!((String)object3).equals("x86_32")) break;
                        tmp = 4;
                        break;
                    }
                    case -1221096139: {
                        if (!((String)object3).equals("aarch64")) break;
                        tmp = 1;
                        break;
                    }
                }
                switch (tmp) {
                    default: {
                        break;
                    }
                    case 2: {
                        Pair pair;
                        object4 = pair;
                        pair = new Pair("arm", "eabihf");
                        break block80;
                    }
                    case 3: {
                        Pair pair;
                        object4 = pair;
                        pair = new Pair("x86_64", "");
                        break block80;
                    }
                    case 4: {
                        Pair pair;
                        object4 = pair;
                        pair = new Pair("i386", "");
                        break block80;
                    }
                    case 1: {
                        Pair pair;
                        object4 = pair;
                        pair = new Pair("aarch64", "");
                        break block80;
                    }
                }
            }
            object4 = null;
        }
        if (object4 == null) {
            ((PlatformProvider)object2).logger.warn("Unsupported Linux arch: " + (String)object3);
            return null;
        }
        object4 = (String)object4.component1();
        object3 = (String)object4.component2();
        if (bl) {
            Function1 function1;
            Object object7 = "wayland";
            object3 = (String)object4 + "-linux-gnu" + (String)object3;
            ((PlatformProvider)object2).logger.info("Target triple: " + (String)object3);
            Object object8 = object;
            object = (String)object3 + "/libproxy_linux_" + (String)object7 + ".so";
            object3 = "libproxy_linux_" + (String)object7 + ".so";
            String[] stringArray = new String[8];
            String[] stringArray2 = stringArray;
            stringArray[0] = "..";
            stringArray[1] = "..";
            stringArray[2] = "..";
            stringArray[3] = "proxy-linux";
            stringArray[4] = "build";
            stringArray[5] = "cmake";
            stringArray[6] = object4;
            stringArray[7] = object3;
            object4 = Paths.get("..", stringArray2);
            object3 = "libproxy_linux_" + (String)object7;
            object7 = function1;
            function1 = new Function1(object2){

                public final void invoke(Path path) {
                    Intrinsics.checkNotNullParameter(path, "p0");
                    PlatformProvider.access$posixReadOnlySetter((PlatformProvider)this.receiver, path);
                }
            };
            object2 = () -> PlatformProvider.probeNativeLibraryInfo$lambda$10((GlfwPlatform)object8);
            return new NativeLibraryInfo((String)object, (Path)object4, (String)object3, ".so", (Function1)object7, false, (Function0)object2);
        }
        if (object instanceof GlfwPlatform.X11) {
            ((PlatformProvider)object2).logger.warn("X11 is not supported for now");
            return null;
        }
        throw new AssertionError();
    }

    public final Platform loadPlatform(PlatformWindowProvider platformWindowProvider) {
        Object object;
        block11: {
            String string;
            Object object2;
            LauncherSocketProxyServer launcherSocketProxyServer;
            Object object3;
            object = System.getenv("TOUCH_CONTROLLER_PROXY");
            object = object != null ? StringsKt__StringNumberConversionsKt.toIntOrNull((String)object) : null;
            if (object != null) {
                ((PlatformProvider)((Object)launcherSocketProxyServer2)).logger.warn("TOUCH_CONTROLLER_PROXY set, use legacy UDP transport");
                LauncherSocketProxyServer launcherSocketProxyServer2 = LauncherSocketProxyServerKt.localhostLauncherSocketProxyServer((Integer)object);
                if (launcherSocketProxyServer2 == null) {
                    return null;
                }
                return new ProxyPlatform(GlobalScope.INSTANCE, launcherSocketProxyServer2);
            }
            object = ((PlatformProvider)((Object)launcherSocketProxyServer2)).probeNativeLibraryInfo(platformWindowProvider);
            if (object == null) {
                return null;
            }
            PlatformProvider platformProvider = launcherSocketProxyServer2;
            platformProvider.logger.info("Native library info:");
            platformProvider.logger.info("path: " + ((NativeLibraryInfo)object).getModContainerPath());
            platformProvider.logger.info("debugPath: " + ((NativeLibraryInfo)object).getDebugPath());
            Object object4 = object;
            Object object5 = ((NativeLibraryInfo)object4).getModContainerPath();
            object5 = platformProvider.getNativeLibraryPathGetter().getNativeLibraryPath((String)object5, ((NativeLibraryInfo)object4).getDebugPath());
            if (object5 == null) {
                ((PlatformProvider)((Object)launcherSocketProxyServer2)).logger.warn("Failed to get native library path");
                return null;
            }
            try {
                object3 = object;
                launcherSocketProxyServer = launcherSocketProxyServer2;
                Object object6 = object;
                object2 = object6;
                string = ((NativeLibraryInfo)object6).getExtractPrefix();
            }
            catch (Exception exception) {
                ((PlatformProvider)((Object)launcherSocketProxyServer2)).logger.warn("Failed to extract native library", exception);
                return null;
            }
            object5 = ((PlatformProvider)((Object)launcherSocketProxyServer)).extractNativeLibrary(string, ((NativeLibraryInfo)object2).getExtractSuffix(), (InputStream)object5);
            try {
                ((NativeLibraryInfo)object3).getReadOnlySetter().invoke(object5);
            }
            catch (Exception exception) {
                ((PlatformProvider)((Object)launcherSocketProxyServer2)).logger.info("Failed to set file " + object5 + " read-only", exception);
            }
            ((PlatformProvider)((Object)launcherSocketProxyServer2)).logger.info("Loading native library");
            try {
                System.load(((Object)object5.toAbsolutePath()).toString());
                ((PlatformProvider)((Object)launcherSocketProxyServer2)).logger.info("Loaded native library");
                if (!((NativeLibraryInfo)object).getRemoveAfterLoaded()) break block11;
            }
            catch (Exception exception) {
                return null;
            }
            Files.deleteIfExists((Path)object5);
        }
        Platform platform = (Platform)((NativeLibraryInfo)object).getPlatformFactory().invoke();
        PlatformWindowProvider platformWindowProvider2 = platformWindowProvider;
        int n = platformWindowProvider2.getWindowWidth();
        platform.resize(n, platformWindowProvider2.getWindowHeight());
        return platform;
    }

    public static final class NativeLibraryInfo {
        public final String modContainerPath;
        public final Path debugPath;
        public final String extractPrefix;
        public final String extractSuffix;
        public final Function1 readOnlySetter;
        public final boolean removeAfterLoaded;
        public final Function0 platformFactory;

        public NativeLibraryInfo(String string, Path path, String string2, String string3, Function1 function1, boolean bl, Function0 function0) {
            Intrinsics.checkNotNullParameter(string, "modContainerPath");
            Intrinsics.checkNotNullParameter(string2, "extractPrefix");
            Intrinsics.checkNotNullParameter(string3, "extractSuffix");
            Intrinsics.checkNotNullParameter(function1, "readOnlySetter");
            Intrinsics.checkNotNullParameter(function0, "platformFactory");
            this.modContainerPath = string;
            this.debugPath = path;
            this.extractPrefix = string2;
            this.extractSuffix = string3;
            this.readOnlySetter = function1;
            this.removeAfterLoaded = bl;
            this.platformFactory = function0;
        }

        public final String getModContainerPath() {
            return this.modContainerPath;
        }

        public final Path getDebugPath() {
            return this.debugPath;
        }

        public final String getExtractPrefix() {
            return this.extractPrefix;
        }

        public final String getExtractSuffix() {
            return this.extractSuffix;
        }

        public final Function1 getReadOnlySetter() {
            return this.readOnlySetter;
        }

        public final boolean getRemoveAfterLoaded() {
            return this.removeAfterLoaded;
        }

        public final Function0 getPlatformFactory() {
            return this.platformFactory;
        }

        public String toString() {
            return "NativeLibraryInfo(modContainerPath=" + this.modContainerPath + ", debugPath=" + this.debugPath + ", extractPrefix=" + this.extractPrefix + ", extractSuffix=" + this.extractSuffix + ", readOnlySetter=" + this.readOnlySetter + ", removeAfterLoaded=" + this.removeAfterLoaded + ", platformFactory=" + this.platformFactory + ')';
        }

        public int hashCode() {
            NativeLibraryInfo nativeLibraryInfo = this;
            int n = nativeLibraryInfo.modContainerPath.hashCode() * 31;
            Path path = nativeLibraryInfo.debugPath;
            int n2 = path == null ? 0 : ((Object)path).hashCode();
            return (((((n + n2) * 31 + this.extractPrefix.hashCode()) * 31 + this.extractSuffix.hashCode()) * 31 + this.readOnlySetter.hashCode()) * 31 + Boolean.hashCode(this.removeAfterLoaded)) * 31 + this.platformFactory.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof NativeLibraryInfo)) {
                return false;
            }
            object = (NativeLibraryInfo)object;
            if (!Intrinsics.areEqual(this.modContainerPath, ((NativeLibraryInfo)object).modContainerPath)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.debugPath, ((NativeLibraryInfo)object).debugPath)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.extractPrefix, ((NativeLibraryInfo)object).extractPrefix)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.extractSuffix, ((NativeLibraryInfo)object).extractSuffix)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.readOnlySetter, ((NativeLibraryInfo)object).readOnlySetter)) {
                return false;
            }
            if (this.removeAfterLoaded != ((NativeLibraryInfo)object).removeAfterLoaded) {
                return false;
            }
            return Intrinsics.areEqual(this.platformFactory, ((NativeLibraryInfo)object).platformFactory);
        }
    }
}

