/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.org.slf4j;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import top.fifthlight.touchcontroller.relocated.org.slf4j.ILoggerFactory;
import top.fifthlight.touchcontroller.relocated.org.slf4j.Logger;
import top.fifthlight.touchcontroller.relocated.org.slf4j.event.SubstituteLoggingEvent;
import top.fifthlight.touchcontroller.relocated.org.slf4j.helpers.NOP_FallbackServiceProvider;
import top.fifthlight.touchcontroller.relocated.org.slf4j.helpers.Reporter;
import top.fifthlight.touchcontroller.relocated.org.slf4j.helpers.SubstituteLogger;
import top.fifthlight.touchcontroller.relocated.org.slf4j.helpers.SubstituteServiceProvider;
import top.fifthlight.touchcontroller.relocated.org.slf4j.helpers.Util;
import top.fifthlight.touchcontroller.relocated.org.slf4j.spi.SLF4JServiceProvider;

public abstract class LoggerFactory {
    public static volatile int INITIALIZATION_STATE = 0;
    public static final SubstituteServiceProvider SUBST_PROVIDER = new SubstituteServiceProvider();
    public static final NOP_FallbackServiceProvider NOP_FALLBACK_SERVICE_PROVIDER = new NOP_FallbackServiceProvider();
    public static boolean DETECT_LOGGER_NAME_MISMATCH = Util.safeGetBooleanSystemProperty("slf4j.detectLoggerNameMismatch");
    public static volatile SLF4JServiceProvider PROVIDER;
    public static final String[] API_COMPATIBILITY_LIST;

    public static List findServiceProviders() {
        ArrayList<SLF4JServiceProvider> arrayList;
        ArrayList<SLF4JServiceProvider> arrayList2 = arrayList;
        arrayList = new ArrayList<SLF4JServiceProvider>();
        Object object = LoggerFactory.class.getClassLoader();
        SLF4JServiceProvider sLF4JServiceProvider = LoggerFactory.loadExplicitlySpecified((ClassLoader)object);
        if (sLF4JServiceProvider != null) {
            ArrayList<SLF4JServiceProvider> arrayList3 = arrayList2;
            arrayList3.add(sLF4JServiceProvider);
            return arrayList3;
        }
        object = LoggerFactory.getServiceLoader((ClassLoader)object).iterator();
        while (object.hasNext()) {
            LoggerFactory.safelyInstantiate(arrayList2, (Iterator)object);
        }
        return arrayList2;
    }

    public static ServiceLoader getServiceLoader(ClassLoader classLoader) {
        return System.getSecurityManager() == null ? ServiceLoader.load(SLF4JServiceProvider.class, classLoader) : AccessController.doPrivileged(() -> ServiceLoader.load(SLF4JServiceProvider.class, classLoader));
    }

    public static void safelyInstantiate(List list, Iterator iterator2) {
        try {
            list.add((SLF4JServiceProvider)iterator2.next());
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            Reporter.error("A service provider failed to instantiate:\n" + serviceConfigurationError.getMessage());
        }
    }

    public static final void performInitialization() {
        LoggerFactory.bind();
        if (INITIALIZATION_STATE == 3) {
            LoggerFactory.versionSanityCheck();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void bind() {
        Exception exception2;
        block5: {
            List list;
            try {
                list = LoggerFactory.findServiceProviders();
            }
            catch (Exception exception2) {
                break block5;
            }
            LoggerFactory.reportMultipleBindingAmbiguity(list);
            if (list != null && !list.isEmpty()) {
                List list2 = list;
                PROVIDER = (SLF4JServiceProvider)list2.get(0);
                PROVIDER.initialize();
                INITIALIZATION_STATE = 3;
                LoggerFactory.reportActualBinding(list2);
            } else {
                INITIALIZATION_STATE = 4;
                Reporter.warn("No SLF4J providers were found.");
                Reporter.warn("Defaulting to no-operation (NOP) logger implementation");
                Reporter.warn("See https://www.slf4j.org/codes.html#noProviders for further details.");
                LoggerFactory.reportIgnoredStaticLoggerBinders(LoggerFactory.findPossibleStaticLoggerBinderPathSet());
            }
            LoggerFactory.postBindCleanUp();
            return;
        }
        LoggerFactory.failedBinding(exception2);
        throw new IllegalStateException("Unexpected initialization failure", exception2);
    }

    /*
     * WARNING - void declaration
     */
    public static SLF4JServiceProvider loadExplicitlySpecified(ClassLoader classLoader) {
        String string = System.getProperty("slf4j.provider");
        if (string != null && !string.isEmpty()) {
            void var0_7;
            block8: {
                try {
                    Reporter.info(String.format("Attempting to load provider \"%s\" specified via \"%s\" system property", string, "slf4j.provider"));
                    return (SLF4JServiceProvider)classLoader.loadClass(string).getConstructor(null).newInstance(null);
                }
                catch (ClassCastException classCastException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    break block8;
                }
                catch (IllegalAccessException illegalAccessException) {
                    break block8;
                }
                catch (InstantiationException instantiationException) {
                    break block8;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    break block8;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    break block8;
                }
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                Reporter.error(String.format("Specified SLF4JServiceProvider (%s) does not implement SLF4JServiceProvider interface", objectArray2), classCastException);
                return null;
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = string;
            Reporter.error(String.format("Failed to instantiate the specified SLF4JServiceProvider (%s)", objectArray3), (Throwable)var0_7);
            return null;
        }
        return null;
    }

    public static void reportIgnoredStaticLoggerBinders(Set object) {
        if (object.isEmpty()) {
            return;
        }
        Reporter.warn("Class path contains SLF4J bindings targeting slf4j-api versions 1.7.x or earlier.");
        object = object.iterator();
        while (object.hasNext()) {
            Reporter.warn("Ignoring binding found at [" + (URL)object.next() + "]");
        }
        Reporter.warn("See https://www.slf4j.org/codes.html#ignoredBindings for an explanation.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set findPossibleStaticLoggerBinderPathSet() {
        Object object;
        LinkedHashSet<URL> linkedHashSet;
        block5: {
            IOException iOException2;
            block4: {
                Enumeration<URL> enumeration;
                LinkedHashSet<URL> linkedHashSet2;
                linkedHashSet = linkedHashSet2;
                linkedHashSet2 = new LinkedHashSet<URL>();
                try {
                    object = LoggerFactory.class.getClassLoader();
                    enumeration = object == null ? ClassLoader.getSystemResources("org/slf4j/impl/StaticLoggerBinder.class") : ((ClassLoader)object).getResources("org/slf4j/impl/StaticLoggerBinder.class");
                }
                catch (IOException iOException2) {
                    break block4;
                }
                object = enumeration;
                break block5;
            }
            Reporter.error("Error getting resources from path", iOException2);
            return linkedHashSet;
        }
        while (object.hasMoreElements()) {
            linkedHashSet.add((URL)object.nextElement());
        }
        return linkedHashSet;
    }

    public static void postBindCleanUp() {
        LoggerFactory.fixSubstituteLoggers();
        LoggerFactory.replayEvents();
        SUBST_PROVIDER.getSubstituteLoggerFactory().clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void fixSubstituteLoggers() {
        SubstituteServiceProvider substituteServiceProvider = SUBST_PROVIDER;
        synchronized (substituteServiceProvider) {
            try {
                substituteServiceProvider.getSubstituteLoggerFactory().postInitialization();
                Iterator iterator2 = substituteServiceProvider.getSubstituteLoggerFactory().getLoggers().iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        return;
                    }
                    SubstituteLogger substituteLogger = (SubstituteLogger)iterator2.next();
                    substituteLogger.setDelegate(LoggerFactory.getLogger(substituteLogger.getName()));
                }
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    public static void failedBinding(Throwable throwable) {
        INITIALIZATION_STATE = 2;
        Reporter.error("Failed to instantiate SLF4J LoggerFactory", throwable);
    }

    public static void replayEvents() {
        ArrayList arrayList;
        LinkedBlockingQueue linkedBlockingQueue = SUBST_PROVIDER.getSubstituteLoggerFactory().getEventQueue();
        int n = linkedBlockingQueue.size();
        int n2 = 0;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(128);
        while (linkedBlockingQueue.drainTo(arrayList2, 128) != 0) {
            for (SubstituteLoggingEvent substituteLoggingEvent : arrayList2) {
                LoggerFactory.replaySingleEvent(substituteLoggingEvent);
                if (n2++ != 0) continue;
                LoggerFactory.emitReplayOrSubstituionWarning(substituteLoggingEvent, n);
            }
            arrayList2.clear();
        }
        return;
    }

    public static void emitReplayOrSubstituionWarning(SubstituteLoggingEvent substituteLoggingEvent, int n) {
        if (substituteLoggingEvent.getLogger().isDelegateEventAware()) {
            LoggerFactory.emitReplayWarning(n);
        } else if (!substituteLoggingEvent.getLogger().isDelegateNOP()) {
            LoggerFactory.emitSubstitutionWarning();
        }
    }

    public static void replaySingleEvent(SubstituteLoggingEvent substituteLoggingEvent) {
        if (substituteLoggingEvent == null) {
            return;
        }
        SubstituteLogger substituteLogger = substituteLoggingEvent.getLogger();
        String string = substituteLogger.getName();
        if (!substituteLogger.isDelegateNull()) {
            if (!substituteLogger.isDelegateNOP()) {
                if (substituteLogger.isDelegateEventAware()) {
                    if (substituteLogger.isEnabledForLevel(substituteLoggingEvent.getLevel())) {
                        substituteLogger.log(substituteLoggingEvent);
                    }
                } else {
                    Reporter.warn(string);
                }
            }
            return;
        }
        throw new IllegalStateException("Delegate logger cannot be null at this state.");
    }

    public static void emitSubstitutionWarning() {
        Reporter.warn("The following set of substitute loggers may have been accessed");
        Reporter.warn("during the initialization phase. Logging calls during this");
        Reporter.warn("phase were not honored. However, subsequent logging calls to these");
        Reporter.warn("loggers will work as normally expected.");
        Reporter.warn("See also https://www.slf4j.org/codes.html#substituteLogger");
    }

    public static void emitReplayWarning(int n) {
        Reporter.warn("A number (" + n + ") of logging calls during the initialization phase have been intercepted and are");
        Reporter.warn("now being replayed. These are subject to the filtering rules of the underlying logging system.");
        Reporter.warn("See also https://www.slf4j.org/codes.html#replay");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void versionSanityCheck() {
        Throwable throwable2;
        block5: {
            String[] stringArray;
            boolean bl;
            String string;
            try {
                string = PROVIDER.getRequestedApiVersion();
                bl = false;
                stringArray = API_COMPATIBILITY_LIST;
            }
            catch (Throwable throwable2) {
                break block5;
            }
            {
                int n = API_COMPATIBILITY_LIST.length;
                for (int i = 0; i < n; ++i) {
                    if (!string.startsWith(stringArray[i])) continue;
                    bl = true;
                }
            }
            if (bl) return;
            {
                Reporter.warn("The requested version " + string + " by your slf4j provider is not compatible with " + Arrays.asList(API_COMPATIBILITY_LIST).toString());
                Reporter.warn("See https://www.slf4j.org/codes.html#version_mismatch for further details.");
                return;
            }
        }
        Reporter.error("Unexpected problem occurred during version sanity check", throwable2);
    }

    public static boolean isAmbiguousProviderList(List list) {
        return list.size() > 1;
    }

    public static void reportMultipleBindingAmbiguity(List object) {
        if (LoggerFactory.isAmbiguousProviderList((List)object)) {
            Reporter.warn("Class path contains multiple SLF4J providers.");
            object = object.iterator();
            while (object.hasNext()) {
                Reporter.warn("Found provider [" + (SLF4JServiceProvider)object.next() + "]");
            }
            Reporter.warn("See https://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
        }
    }

    public static void reportActualBinding(List list) {
        if (!list.isEmpty()) {
            if (LoggerFactory.isAmbiguousProviderList(list)) {
                Reporter.info("Actual provider is of type [" + list.get(0) + "]");
            } else {
                Reporter.debug("Connected with provider of type [" + ((SLF4JServiceProvider)list.get(0)).getClass().getName() + "]");
            }
            return;
        }
        throw new IllegalStateException("No providers were found which is impossible after successful initialization.");
    }

    public static Logger getLogger(String string) {
        return LoggerFactory.getILoggerFactory().getLogger(string);
    }

    public static Logger getLogger(Class object) {
        Object object2;
        Logger logger = LoggerFactory.getLogger(((Class)object).getName());
        if (DETECT_LOGGER_NAME_MISMATCH && (object2 = Util.getCallingClass()) != null && LoggerFactory.nonMatchingClasses((Class)object, (Class)object2)) {
            object = logger.getName();
            object2 = ((Class)object2).getName();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            objectArray[1] = object2;
            Reporter.warn(String.format("Detected logger name mismatch. Given name: \"%s\"; computed name: \"%s\".", objectArray2));
            Reporter.warn("See https://www.slf4j.org/codes.html#loggerNameMismatch for an explanation");
        }
        return logger;
    }

    public static boolean nonMatchingClasses(Class clazz, Class clazz2) {
        return clazz2.isAssignableFrom(clazz) ^ true;
    }

    public static ILoggerFactory getILoggerFactory() {
        return LoggerFactory.getProvider().getLoggerFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SLF4JServiceProvider getProvider() {
        if (INITIALIZATION_STATE == 0) {
            Class<LoggerFactory> clazz = LoggerFactory.class;
            // MONITORENTER : top.fifthlight.touchcontroller.relocated.org.slf4j.LoggerFactory.class
            if (INITIALIZATION_STATE == 0) {
                INITIALIZATION_STATE = 1;
                LoggerFactory.performInitialization();
            }
        }
        switch (INITIALIZATION_STATE) {
            default: {
                throw new IllegalStateException("Unreachable code");
            }
            case 4: {
                return NOP_FALLBACK_SERVICE_PROVIDER;
            }
            case 3: {
                return PROVIDER;
            }
            case 2: {
                throw new IllegalStateException("org.slf4j.LoggerFactory in failed state. Original exception was thrown EARLIER. See also https://www.slf4j.org/codes.html#unsuccessfulInit");
            }
            case 1: 
        }
        return SUBST_PROVIDER;
    }

    static {
        API_COMPATIBILITY_LIST = new String[]{"2.0"};
    }
}

