/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.gal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import net.minecraftforge.fml.loading.FMLEnvironment;
import top.fifthlight.touchcontroller.common.gal.NativeLibraryPathGetter;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.org.slf4j.Logger;
import top.fifthlight.touchcontroller.relocated.org.slf4j.LoggerFactory;

public final class NativeLibraryPathGetterImpl
implements NativeLibraryPathGetter {
    public static final NativeLibraryPathGetterImpl INSTANCE = new NativeLibraryPathGetterImpl();
    public static final Logger logger = LoggerFactory.getLogger(NativeLibraryPathGetterImpl.class);
    public static final int $stable = 8;

    @Override
    public InputStream getNativeLibraryPath(String string, Path path) {
        Object object;
        Intrinsics.checkNotNullParameter(string, "path");
        if (FMLEnvironment.production) {
            object = NativeLibraryPathGetterImpl.class.getClassLoader().getResourceAsStream(string);
            if (object == null) {
                logger.warn("Failed to get resource " + string);
                object = null;
            }
        } else {
            if (path != null) {
                int n = 0;
                object = Files.newInputStream(path, Arrays.copyOf(new OpenOption[0], n));
                try {
                    Intrinsics.checkNotNullExpressionValue(object, "newInputStream(...)");
                }
                catch (IOException iOException) {
                    logger.warn("Read debug library failed", iOException);
                    object = null;
                }
            } else {
                object = null;
            }
            if (object == null) {
                logger.warn("No debug library for your platform");
                object = null;
            }
        }
        return object;
    }
}

