/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.platform;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.touchcontroller.common.platform.Platform;
import top.fifthlight.touchcontroller.proxy.message.LargeMessage;
import top.fifthlight.touchcontroller.proxy.message.MessageDecodeException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.ranges.RangesKt___RangesKt;

public abstract class LargeMessageWrappedPlatform
implements Platform {
    public final Logger logger = LoggerFactory.getLogger(LargeMessageWrappedPlatform.class);
    public ByteBuffer largeMessageBuffer = ByteBuffer.allocate(65536);
    public final ByteBuffer encodeBuffer = ByteBuffer.allocate(65536);

    public abstract ProxyMessage pollSmallEvent();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ProxyMessage pollEvent() {
        while (true) {
            MessageDecodeException messageDecodeException2;
            block7: {
                ProxyMessage proxyMessage;
                Object object;
                if ((object = this.pollSmallEvent()) == null) {
                    return null;
                }
                if (!(object instanceof LargeMessage)) {
                    return object;
                }
                object = (LargeMessage)object;
                this.largeMessageBuffer.put(((LargeMessage)object).getPayload());
                if (!((LargeMessage)object).getEnd()) continue;
                LargeMessageWrappedPlatform largeMessageWrappedPlatform = this;
                largeMessageWrappedPlatform.largeMessageBuffer.flip();
                try {
                    if (largeMessageWrappedPlatform.largeMessageBuffer.remaining() < 4) break block7;
                    ByteBuffer byteBuffer = this.largeMessageBuffer;
                    Intrinsics.checkNotNull(byteBuffer);
                    int n = byteBuffer.getInt();
                    object = this.largeMessageBuffer;
                    Intrinsics.checkNotNull(object);
                    proxyMessage = ProxyMessage.Companion.decode(n, (ByteBuffer)object);
                    this.largeMessageBuffer.clear();
                }
                catch (MessageDecodeException messageDecodeException2) {}
                return proxyMessage;
            }
            this.logger.warn("Large message less than 4 bytes?");
            continue;
            this.logger.warn("Bad message: " + messageDecodeException2);
        }
    }

    public abstract void sendSmallEvent(ProxyMessage var1);

    @Override
    public final void sendEvent(ProxyMessage object) {
        ProxyMessage proxyMessage = object;
        Intrinsics.checkNotNullParameter(proxyMessage, "message");
        if (!proxyMessage.getWrapInLargeMessage()) {
            this.sendSmallEvent((ProxyMessage)object);
            return;
        }
        LargeMessageWrappedPlatform largeMessageWrappedPlatform = this;
        largeMessageWrappedPlatform.encodeBuffer.clear();
        ByteBuffer byteBuffer = largeMessageWrappedPlatform.encodeBuffer;
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "encodeBuffer");
        ((ProxyMessage)object).encode(byteBuffer);
        this.encodeBuffer.flip();
        while (this.encodeBuffer.hasRemaining()) {
            LargeMessageWrappedPlatform largeMessageWrappedPlatform2 = this;
            object = new byte[RangesKt___RangesKt.coerceAtMost(largeMessageWrappedPlatform2.encodeBuffer.remaining(), 240)];
            largeMessageWrappedPlatform2.encodeBuffer.get((byte[])object);
            largeMessageWrappedPlatform2.sendSmallEvent(new LargeMessage((byte[])object, this.encodeBuffer.hasRemaining() ^ true));
        }
    }

    @Override
    public void resize(int n, int n2) {
        Platform.DefaultImpls.resize(this, n, n2);
    }
}

