/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal;

import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import top.fifthlight.touchcontroller.relocated.kotlin._Assertions;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlinx.serialization.json.internal.ByteArrayPool8k;

public final class CharsetReader {
    public final InputStream inputStream;
    public final Charset charset;
    public final CharsetDecoder decoder;
    public final ByteBuffer byteBuffer;
    public boolean hasLeftoverPotentiallySurrogateChar;
    public char leftoverChar;

    public CharsetReader(InputStream object, Charset charset) {
        Intrinsics.checkNotNullParameter(object, "inputStream");
        Intrinsics.checkNotNullParameter(charset, "charset");
        this.inputStream = object;
        this.charset = charset;
        object = CodingErrorAction.REPLACE;
        this.decoder = charset.newDecoder().onMalformedInput((CodingErrorAction)object).onUnmappableCharacter((CodingErrorAction)object);
        this.byteBuffer = ByteBuffer.wrap(ByteArrayPool8k.INSTANCE.take());
        ((Buffer)this.byteBuffer).flip();
    }

    public final int read(char[] cArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(cArray, "array");
        if (n2 == 0) {
            return 0;
        }
        if (n >= 0 && n < cArray.length && n2 >= 0 && n + n2 <= cArray.length) {
            int n3 = 0;
            if (((CharsetReader)((Object)string)).hasLeftoverPotentiallySurrogateChar) {
                cArray[n] = ((CharsetReader)((Object)string)).leftoverChar;
                ++n;
                ((CharsetReader)((Object)string)).hasLeftoverPotentiallySurrogateChar = false;
                n3 = 1;
                if ((n2 += -1) == 0) {
                    return n3;
                }
            }
            if (n2 == 1) {
                int n4 = ((CharsetReader)((Object)string)).oneShotReadSlowPath();
                if (n4 == -1) {
                    if (n3 == 0) {
                        n3 = -1;
                    }
                    return n3;
                }
                cArray[n] = (char)n4;
                return n3 + 1;
            }
            return ((CharsetReader)((Object)string)).doRead(cArray, n, n2) + n3;
        }
        String string = "Unexpected arguments: " + n + ", " + n2 + ", " + cArray.length;
        throw new IllegalArgumentException(string.toString());
    }

    public final void release() {
        byte[] byArray = this.byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        ByteArrayPool8k.INSTANCE.release(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int doRead(char[] object, int n, int n2) {
        if (((Buffer)(object = CharBuffer.wrap((char[])object, n, n2))).position() != 0) {
            object = ((CharBuffer)object).slice();
        }
        n = 0;
        while (true) {
            CoderResult coderResult;
            block13: {
                block12: {
                    block11: {
                        if (!(coderResult = this.decoder.decode(this.byteBuffer, (CharBuffer)object, n != 0)).isUnderflow()) break block11;
                        if (n == 0 && ((Buffer)object).hasRemaining()) {
                            if (this.fillByteBuffer() >= 0) continue;
                            n = 1;
                            if (((Buffer)object).position() != 0 || this.byteBuffer.hasRemaining()) {
                                this.decoder.reset();
                                continue;
                            }
                        }
                        break block12;
                    }
                    if (!coderResult.isOverflow()) break block13;
                    boolean bl = ((Buffer)object).position() > 0;
                    if (_Assertions.ENABLED) {
                        if (!bl) throw new AssertionError((Object)"Assertion failed");
                    }
                }
                if (n != 0) {
                    this.decoder.reset();
                }
                if (((Buffer)object).position() == 0) {
                    return -1;
                }
                int n3 = ((Buffer)object).position();
                return n3;
            }
            coderResult.throwException();
        }
    }

    public final int fillByteBuffer() {
        int n;
        int n2;
        block10: {
            block9: {
                CharsetReader charsetReader = this;
                charsetReader.byteBuffer.compact();
                try {
                    n2 = charsetReader.byteBuffer.limit();
                }
                catch (Throwable throwable) {
                    ((Buffer)this.byteBuffer).flip();
                    throw throwable;
                }
                n = charsetReader.byteBuffer.position();
                if (n <= n2) {
                    n2 -= n;
                    break block9;
                }
                n2 = 0;
            }
            InputStream inputStream = this.inputStream;
            byte[] byArray = this.byteBuffer.array();
            int n3 = this.byteBuffer.arrayOffset();
            n2 = inputStream.read(byArray, n3 + n, n2);
            if (n2 >= 0) break block10;
            ((Buffer)this.byteBuffer).flip();
            return n2;
        }
        CharsetReader charsetReader = this;
        CharsetReader charsetReader2 = charsetReader;
        CharsetReader charsetReader3 = charsetReader;
        ByteBuffer byteBuffer = charsetReader.byteBuffer;
        Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
        int n4 = n + n2;
        ((Buffer)byteBuffer).position(n4);
        ((Buffer)charsetReader3.byteBuffer).flip();
        return charsetReader2.byteBuffer.remaining();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int oneShotReadSlowPath() {
        int n;
        if (this.hasLeftoverPotentiallySurrogateChar) {
            this.hasLeftoverPotentiallySurrogateChar = false;
            return this.leftoverChar;
        }
        char[] cArray = new char[2];
        int n2 = this.read(cArray, 0, 2);
        if (n2 == -1) return -1;
        if (n2 != 1) {
            if (n2 != 2) throw new IllegalStateException(("Unreachable state: " + n2).toString());
            CharsetReader charsetReader = this;
            charsetReader.leftoverChar = cArray[1];
            charsetReader.hasLeftoverPotentiallySurrogateChar = true;
            n = cArray[0];
            return n;
        } else {
            n = cArray[0];
        }
        return n;
    }
}

