/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.org.joml;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;

public abstract class Options {
    public static final boolean DEBUG = Options.hasOption(System.getProperty("joml.debug", "false"));
    public static final boolean NO_UNSAFE = Options.hasOption(System.getProperty("joml.nounsafe", "false"));
    public static final boolean FORCE_UNSAFE = Options.hasOption(System.getProperty("joml.forceUnsafe", "false"));
    public static final boolean FASTMATH = Options.hasOption(System.getProperty("joml.fastmath", "false"));
    public static final boolean SIN_LOOKUP = Options.hasOption(System.getProperty("joml.sinLookup", "false"));
    public static final int SIN_LOOKUP_BITS = Integer.parseInt(System.getProperty("joml.sinLookup.bits", "14"));
    public static final boolean useNumberFormat = Options.hasOption(System.getProperty("joml.format", "true"));
    public static final boolean USE_MATH_FMA = Options.hasOption(System.getProperty("joml.useMathFma", "false"));
    public static final int numberFormatDecimals = Integer.parseInt(System.getProperty("joml.format.decimals", "3"));
    public static final NumberFormat NUMBER_FORMAT = Options.decimalFormat();

    public static NumberFormat decimalFormat() {
        NumberFormat numberFormat;
        if (useNumberFormat) {
            DecimalFormat decimalFormat;
            char[] cArray = new char[numberFormatDecimals];
            Arrays.fill(cArray, '0');
            numberFormat = decimalFormat;
            decimalFormat = new DecimalFormat(" 0." + new String(cArray) + "E0;-");
        } else {
            numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
            numberFormat.setGroupingUsed(false);
        }
        return numberFormat;
    }

    public static boolean hasOption(String string) {
        if (string == null) {
            return false;
        }
        if (string.trim().length() == 0) {
            return true;
        }
        return Boolean.valueOf(string);
    }
}

