/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.prediction.PredictiveAction;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.fifthlight.combine.platform_1_21_3_1_21_5.ItemFactoryImplKt;
import top.fifthlight.touchcontroller.common.config.GlobalConfig;
import top.fifthlight.touchcontroller.common.config.GlobalConfigHolder;
import top.fifthlight.touchcontroller.common.helper.CrosshairTargetHelper;
import top.fifthlight.touchcontroller.helper.GameModeWithBreakingProgress;
import top.fifthlight.touchcontroller.helper.SyncableGameMode;
import top.fifthlight.touchcontroller.relocated.kotlin.Pair;
import top.fifthlight.touchcontroller.relocated.org.koin.java.KoinJavaComponent;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class ClientPlayerInteractionManagerMixin
implements GameModeWithBreakingProgress,
SyncableGameMode {
    @Shadow
    private float destroyProgress;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private boolean resetPlayerLookTarget;
    @Unique
    private float prevYaw;
    @Unique
    private float prevPitch;

    @Unique
    private boolean crosshairAimingContainItem(Item item) {
        return ItemFactoryImplKt.contains(((GlobalConfig)((GlobalConfigHolder)KoinJavaComponent.get(GlobalConfigHolder.class)).getConfig().getValue()).getItem().getCrosshairAimingItems(), item);
    }

    @Shadow
    public abstract void ensureHasSentCarriedItem();

    @Override
    public float touchcontroller$getBreakingProgress() {
        return this.destroyProgress;
    }

    @Override
    public void touchcontroller$callSyncSelectedSlot() {
        this.ensureHasSentCarriedItem();
    }

    @Shadow
    public abstract void startPrediction(ClientLevel var1, PredictiveAction var2);

    @Unique
    public void interactBefore(Player player, InteractionHand object) {
        ClientPlayerInteractionManagerMixin clientPlayerInteractionManagerMixin;
        if (!clientPlayerInteractionManagerMixin3.crosshairAimingContainItem(player.getItemInHand((InteractionHand)object).getItem())) {
            return;
        }
        ClientPlayerInteractionManagerMixin clientPlayerInteractionManagerMixin2 = clientPlayerInteractionManagerMixin3;
        Player player2 = player;
        clientPlayerInteractionManagerMixin3.prevYaw = player.getYRot();
        clientPlayerInteractionManagerMixin3.prevPitch = player.getXRot();
        object = CrosshairTargetHelper.calculatePlayerRotation(CrosshairTargetHelper.INSTANCE.getLastCrosshairDirection());
        float f = ((Float)((Pair)object).getFirst()).floatValue();
        float f2 = ((Float)((Pair)object).getSecond()).floatValue();
        ClientPlayerInteractionManagerMixin clientPlayerInteractionManagerMixin3 = clientPlayerInteractionManagerMixin3.minecraft.level;
        clientPlayerInteractionManagerMixin.startPrediction((ClientLevel)clientPlayerInteractionManagerMixin3, n -> {
            Player player2 = player;
            boolean bl = player2.onGround();
            n = player2.horizontalCollision ? 1 : 0;
            return new ServerboundMovePlayerPacket.Rot(f, f2, bl, n != 0);
        });
        player2.setYRot(f);
        player2.setXRot(f2);
        clientPlayerInteractionManagerMixin2.resetPlayerLookTarget = true;
    }

    @Unique
    public void interactAfter(Player player) {
        if (!clientPlayerInteractionManagerMixin2.resetPlayerLookTarget) {
            return;
        }
        ClientPlayerInteractionManagerMixin clientPlayerInteractionManagerMixin = clientPlayerInteractionManagerMixin2;
        clientPlayerInteractionManagerMixin2.resetPlayerLookTarget = false;
        player.setYRot(clientPlayerInteractionManagerMixin2.prevYaw);
        player.setXRot(clientPlayerInteractionManagerMixin2.prevPitch);
        ClientPlayerInteractionManagerMixin clientPlayerInteractionManagerMixin2 = clientPlayerInteractionManagerMixin2.minecraft.level;
        clientPlayerInteractionManagerMixin.startPrediction((ClientLevel)clientPlayerInteractionManagerMixin2, n -> {
            Player player2 = player;
            float f = player2.getYRot();
            float f2 = player2.getXRot();
            boolean bl = player2.onGround();
            boolean bl2 = player2.horizontalCollision;
            return new ServerboundMovePlayerPacket.Rot(f, f2, bl, bl2);
        });
    }

    @Inject(method={"useItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V", ordinal=0)})
    public void interactBlockBefore(LocalPlayer localPlayer, InteractionHand interactionHand, BlockHitResult blockHitResult, CallbackInfoReturnable<InteractionResult> callbackInfoReturnable) {
        this.interactBefore((Player)localPlayer, interactionHand);
    }

    @Inject(method={"useItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V", ordinal=0, shift=At.Shift.AFTER)})
    public void interactBlockAfter(LocalPlayer localPlayer, InteractionHand interactionHand, BlockHitResult blockHitResult, CallbackInfoReturnable<InteractionResult> callbackInfoReturnable) {
        this.interactAfter((Player)localPlayer);
    }

    @Inject(method={"useItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V", ordinal=0)})
    public void interactItemBefore(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> callbackInfoReturnable) {
        this.interactBefore(player, interactionHand);
    }

    @Inject(method={"useItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V", ordinal=0, shift=At.Shift.AFTER)})
    public void interactItemAfter(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> callbackInfoReturnable) {
        this.interactAfter(player);
    }
}

