/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.touchcontroller.LoaderModuleKt;
import top.fifthlight.touchcontroller.common.config.GlobalConfigHolder;
import top.fifthlight.touchcontroller.common.event.BlockBreakEvents;
import top.fifthlight.touchcontroller.common.event.ConnectionEvents;
import top.fifthlight.touchcontroller.common.event.RenderEvents;
import top.fifthlight.touchcontroller.common.event.TickEvents;
import top.fifthlight.touchcontroller.common.event.WindowEvents;
import top.fifthlight.touchcontroller.common.model.ControllerHudModel;
import top.fifthlight.touchcontroller.common.ui.screen.ConfigScreenKt;
import top.fifthlight.touchcontroller.common_1_20_6.VersionModuleKt;
import top.fifthlight.touchcontroller.common_1_20_x.GameConfigEditorImpl;
import top.fifthlight.touchcontroller.common_1_20_x.gal.PlatformWindowProviderImpl;
import top.fifthlight.touchcontroller.relocated.kotlin.Unit;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function0;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Reflection;
import top.fifthlight.touchcontroller.relocated.org.koin.core.Koin;
import top.fifthlight.touchcontroller.relocated.org.koin.core.KoinApplication;
import top.fifthlight.touchcontroller.relocated.org.koin.core.component.KoinComponent;
import top.fifthlight.touchcontroller.relocated.org.koin.core.context.DefaultContextExtKt;
import top.fifthlight.touchcontroller.relocated.org.koin.core.module.Module;
import top.fifthlight.touchcontroller.relocated.org.koin.core.qualifier.Qualifier;
import top.fifthlight.touchcontroller.relocated.org.koin.logger.KoinApplicationExtKt;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.platform_1_20_x.CanvasImpl;

@Mod(value="touchcontroller")
public final class TouchController
implements KoinComponent {
    public static final Companion Companion = new Companion(null);
    private static boolean loaded;
    private final ModContainer container;
    private final Logger logger;

    public TouchController(IEventBus iEventBus, ModContainer modContainer) {
        Intrinsics.checkNotNullParameter(iEventBus, "modEventBus");
        Intrinsics.checkNotNullParameter(modContainer, "container");
        this.container = modContainer;
        this.logger = LoggerFactory.getLogger(TouchController.class);
        iEventBus.addListener(this::onClientSetup);
        iEventBus.addListener(this::onInterModProcess);
    }

    private final void onClientSetup(FMLClientSetupEvent fMLClientSetupEvent) {
        TouchController touchController = this;
        touchController.logger.info("Loading TouchController\u2026");
        DefaultContextExtKt.startKoin(TouchController::onClientSetup$lambda$0);
        touchController.initialize();
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.execute(() -> TouchController.onClientSetup$lambda$1(minecraft));
        loaded = true;
    }

    private final void onInterModProcess(InterModProcessEvent interModProcessEvent) {
        GameConfigEditorImpl.INSTANCE.executePendingCallback();
    }

    private final void initialize() {
        TouchController touchController = koinComponent;
        KoinComponent koinComponent = null;
        Function0 function0 = null;
        ((GlobalConfigHolder)touchController.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GlobalConfigHolder.class), (Qualifier)((Object)koinComponent), function0)).load();
        touchController.container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)TouchController::initialize$lambda$2));
        koinComponent = null;
        function0 = null;
        koinComponent = (ControllerHudModel)touchController.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ControllerHudModel.class), (Qualifier)((Object)koinComponent), function0);
        NeoForge.EVENT_BUS.register(new Object((ControllerHudModel)koinComponent){
            public final /* synthetic */ ControllerHudModel $controllerHudModel;
            {
                this.$controllerHudModel = controllerHudModel;
            }

            @SubscribeEvent
            public final void hudRender(RenderGuiEvent.Post post) {
                CanvasImpl canvasImpl;
                Intrinsics.checkNotNullParameter(post, "event");
                CanvasImpl canvasImpl2 = canvasImpl;
                GuiGraphics guiGraphics = post.getGuiGraphics();
                Intrinsics.checkNotNullExpressionValue(guiGraphics, "getGuiGraphics(...)");
                canvasImpl = new CanvasImpl(guiGraphics);
                RenderSystem.enableBlend();
                RenderEvents.INSTANCE.onHudRender(canvasImpl2);
            }

            @SubscribeEvent
            public final void blockOutlineEvent(RenderHighlightEvent.Block block) {
                Intrinsics.checkNotNullParameter(block, "event");
                if (!this.$controllerHudModel.getResult().getShowBlockOutline()) {
                    block.setCanceled(true);
                }
            }

            @SubscribeEvent
            public final void blockBroken(BlockEvent.BreakEvent breakEvent) {
                Intrinsics.checkNotNullParameter(breakEvent, "event");
                BlockBreakEvents.INSTANCE.afterBlockBreak();
            }

            @SubscribeEvent
            public final void clientTick(ClientTickEvent.Post post) {
                Intrinsics.checkNotNullParameter(post, "event");
                TickEvents.INSTANCE.clientTick();
            }

            @SubscribeEvent
            public final void joinWorld(ClientPlayerNetworkEvent.LoggingIn loggingIn) {
                Intrinsics.checkNotNullParameter(loggingIn, "event");
                ConnectionEvents.INSTANCE.onJoinedWorld();
            }
        });
    }

    private static final Unit onClientSetup$lambda$0(KoinApplication object) {
        KoinApplication koinApplication = object;
        Intrinsics.checkNotNullParameter(koinApplication, "$this$startKoin");
        KoinApplicationExtKt.slf4jLogger$default(koinApplication, null, 1, null);
        object = LoaderModuleKt.getLoaderModule();
        Module module = VersionModuleKt.getVersionModule();
        koinApplication.modules(new Module[]{object, module});
        return Unit.INSTANCE;
    }

    private static final void onClientSetup$lambda$1(Minecraft minecraft) {
        Window window = minecraft.getWindow();
        Intrinsics.checkNotNullExpressionValue(window, "getWindow(...)");
        WindowEvents.INSTANCE.onWindowCreated(new PlatformWindowProviderImpl(window));
    }

    private static final Screen initialize$lambda$2(Minecraft minecraft, Screen screen) {
        Object object = ConfigScreenKt.getConfigScreen(screen);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type net.minecraft.client.gui.screens.Screen");
        return (Screen)object;
    }

    public static final /* synthetic */ void access$setLoaded$cp(boolean bl) {
        loaded = bl;
    }

    @Override
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final boolean getLoaded() {
            return loaded;
        }
    }
}

