/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.combine.animation;

import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.Tween;
import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.TweenEquation;
import top.fifthlight.touchcontroller.relocated.aurelienribon.tweenengine.equations.Quint;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public interface TweenSpec {
    public Integer getTweenType();

    public Float getDuration();

    public TweenEquation getEquations();

    public void apply(Tween var1);

    public static final class Base
    implements Full {
        public static final Base INSTANCE = new Base();
        public static final int tweenType;
        public static final float duration;
        public static final TweenEquation equations;
        public static final int $stable;

        static {
            duration = 0.3f;
            Quint quint = Quint.OUT;
            Intrinsics.checkNotNullExpressionValue(quint, "OUT");
            equations = quint;
            $stable = 8;
        }

        @Override
        public Integer getTweenType() {
            return tweenType;
        }

        @Override
        public Float getDuration() {
            return Float.valueOf(duration);
        }

        @Override
        public TweenEquation getEquations() {
            return equations;
        }

        @Override
        public void apply(Tween tween) {
            Intrinsics.checkNotNullParameter(tween, "tween");
        }
    }

    public static final class Default
    implements Full {
        public final TweenSpec next;

        public Default(TweenSpec tweenSpec) {
            Intrinsics.checkNotNullParameter(tweenSpec, "next");
            this.next = tweenSpec;
        }

        @Override
        public Integer getTweenType() {
            Integer n = ((Default)((Object)n)).next.getTweenType();
            return n != null ? n.intValue() : Base.INSTANCE.getTweenType().intValue();
        }

        @Override
        public Float getDuration() {
            Float f = ((Default)((Object)f)).next.getDuration();
            return Float.valueOf(f != null ? f.floatValue() : Base.INSTANCE.getDuration().floatValue());
        }

        @Override
        public TweenEquation getEquations() {
            Object object = ((Default)object).next.getEquations();
            if (object == null) {
                object = Base.INSTANCE.getEquations();
            }
            return object;
        }

        @Override
        public void apply(Tween tween) {
            Intrinsics.checkNotNullParameter(tween, "tween");
            this.next.apply(tween);
        }
    }

    public static interface Full
    extends TweenSpec {
        @Override
        public Integer getTweenType();

        @Override
        public Float getDuration();
    }
}

