/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.proxy.message;

import java.nio.ByteBuffer;
import top.fifthlight.touchcontroller.proxy.message.BadMessageLengthException;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessage;
import top.fifthlight.touchcontroller.proxy.message.ProxyMessageDecoder;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class KeyboardShowMessage
extends ProxyMessage {
    public final boolean show;
    public final int type;

    public KeyboardShowMessage(boolean bl) {
        super(null);
        this.show = bl;
        this.type = 8;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void encode(ByteBuffer byteBuffer) {
        KeyboardShowMessage keyboardShowMessage = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "buffer");
        super.encode(byteBuffer2);
        if (keyboardShowMessage.show) {
            byteBuffer.put((byte)1);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public String toString() {
        return "KeyboardShowMessage(show=" + this.show + ')';
    }

    public int hashCode() {
        return Boolean.hashCode(this.show);
    }

    public boolean equals(Object object) {
        if (keyboardShowMessage2 == object) {
            return true;
        }
        if (!(object instanceof KeyboardShowMessage)) {
            return false;
        }
        KeyboardShowMessage keyboardShowMessage = keyboardShowMessage2;
        KeyboardShowMessage keyboardShowMessage2 = (KeyboardShowMessage)object;
        return keyboardShowMessage.show == keyboardShowMessage2.show;
    }

    public static final class Decoder
    extends ProxyMessageDecoder {
        public static final Decoder INSTANCE = new Decoder();

        @Override
        public KeyboardShowMessage decode(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNullParameter(byteBuffer2, "payload");
            if (byteBuffer2.remaining() == 1) {
                boolean bl = byteBuffer.get() != 0;
                return new KeyboardShowMessage(bl);
            }
            throw new BadMessageLengthException(1, byteBuffer.remaining());
        }
    }
}

