/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.collection;

import java.util.Arrays;
import java.util.RandomAccess;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.ArraysKt___ArraysJvmKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;

public final class MutableVector
implements RandomAccess {
    public Object[] content;
    public int size;

    public MutableVector(Object[] objectArray, int n) {
        Intrinsics.checkNotNullParameter(objectArray, "content");
        this.content = objectArray;
        this.size = n;
    }

    public final Object[] getContent() {
        return this.content;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean add(Object object) {
        Object[] objectArray = objectArray2;
        objectArray.ensureCapacity(objectArray.size + 1);
        Object[] objectArray2 = objectArray.content;
        int n = objectArray.size;
        objectArray2[n] = object;
        objectArray2.size = n + 1;
        return true;
    }

    public final void clear() {
        Object[] objectArray = this.content;
        for (int i = (v207289).getSize() - 1; -1 < i; --i) {
            objectArray[i] = null;
        }
        this.size = 0;
    }

    public final boolean contains(Object object) {
        int n = 0;
        int n2 = this.getSize() - 1;
        if (n2 >= 0) {
            while (true) {
                if (Intrinsics.areEqual(this.getContent()[n], object)) {
                    return true;
                }
                if (n == n2) break;
                ++n;
            }
        }
        return false;
    }

    public final void ensureCapacity(int n) {
        Object[] objectArray = this.content;
        if (this.content.length < n) {
            Object[] objectArray2 = Arrays.copyOf(objectArray, Math.max(n, objectArray.length * 2));
            Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
            this.content = objectArray2;
        }
    }

    public final int indexOf(Object object) {
        int n = this.size;
        if (n > 0) {
            int n2 = 0;
            Object[] objectArray = this.content;
            do {
                if (!Intrinsics.areEqual(object, objectArray[n2])) continue;
                return n2;
            } while (++n2 < n);
        }
        return -1;
    }

    public final boolean isNotEmpty() {
        return this.size != 0;
    }

    public final boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeAt(n);
            return true;
        }
        return false;
    }

    public final Object removeAt(int n) {
        int n2;
        MutableVector mutableVector = this;
        Object[] objectArray = mutableVector.content;
        Object object = mutableVector.content[n];
        if (n != mutableVector.getSize() - 1) {
            int n3 = n + 1;
            int n4 = this.size;
            ArraysKt___ArraysJvmKt.copyInto(objectArray, objectArray, n, n3, n4);
        }
        this.size = n2 = this.size + -1;
        objectArray[n2] = null;
        return object;
    }

    public final void setSize(int n) {
        this.size = n;
    }
}

