/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.snapshots;

import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.snapshots.SnapshotStateList;
import top.fifthlight.touchcontroller.relocated.androidx.compose.runtime.snapshots.SnapshotStateListKt;
import top.fifthlight.touchcontroller.relocated.kotlin.KotlinNothingValueException;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.markers.KMappedMarker;

public final class StateListIterator
implements ListIterator,
KMappedMarker {
    public final SnapshotStateList list;
    public int index;
    public int lastRequested;
    public int structure;

    public StateListIterator(SnapshotStateList snapshotStateList, int n) {
        StateListIterator stateListIterator = this;
        Intrinsics.checkNotNullParameter(snapshotStateList, "list");
        this.list = snapshotStateList;
        stateListIterator.index = n - 1;
        stateListIterator.lastRequested = -1;
        this.structure = snapshotStateList.getStructure$runtime();
    }

    @Override
    public boolean hasPrevious() {
        return this.index >= 0;
    }

    @Override
    public int nextIndex() {
        return this.index + 1;
    }

    public Object previous() {
        int n;
        StateListIterator stateListIterator = this;
        stateListIterator.validateModification();
        SnapshotStateListKt.access$validateRange(stateListIterator.index, this.list.size());
        stateListIterator.lastRequested = n = stateListIterator.index;
        this.index += -1;
        return stateListIterator.list.get(n);
    }

    @Override
    public int previousIndex() {
        return this.index;
    }

    public void add(Object object) {
        StateListIterator stateListIterator = this;
        stateListIterator.validateModification();
        stateListIterator.list.add(this.index + 1, object);
        stateListIterator.lastRequested = -1;
        ++stateListIterator.index;
        stateListIterator.structure = stateListIterator.list.getStructure$runtime();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size() - 1;
    }

    @Override
    public Object next() {
        int n;
        StateListIterator stateListIterator = this;
        stateListIterator.validateModification();
        this.lastRequested = n = stateListIterator.index + 1;
        SnapshotStateListKt.access$validateRange(n, this.list.size());
        this.index = n;
        return stateListIterator.list.get(n);
    }

    @Override
    public void remove() {
        StateListIterator stateListIterator = this;
        stateListIterator.validateModification();
        stateListIterator.list.remove(this.index);
        stateListIterator.index += -1;
        stateListIterator.lastRequested = -1;
        stateListIterator.structure = stateListIterator.list.getStructure$runtime();
    }

    public void set(Object object) {
        StateListIterator stateListIterator = this;
        stateListIterator.validateModification();
        int n = stateListIterator.lastRequested;
        if (n >= 0) {
            StateListIterator stateListIterator2 = this;
            stateListIterator2.list.set(n, object);
            stateListIterator2.structure = stateListIterator2.list.getStructure$runtime();
            return;
        }
        SnapshotStateListKt.access$invalidIteratorSet();
        throw new KotlinNothingValueException();
    }

    public final void validateModification() {
        if (this.list.getStructure$runtime() == this.structure) {
            return;
        }
        throw new ConcurrentModificationException();
    }
}

