/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal;

import java.util.Arrays;
import top.fifthlight.touchcontroller.relocated.kotlin.UninitializedPropertyAccessException;

public abstract class Intrinsics {
    public static void checkNotNull(Object object) {
        if (object == null) {
            Intrinsics.throwJavaNpe();
        }
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            Intrinsics.throwJavaNpe(string);
        }
    }

    public static void throwJavaNpe() {
        throw (NullPointerException)Intrinsics.sanitizeStackTrace(new NullPointerException());
    }

    public static void throwJavaNpe(String string) {
        throw (NullPointerException)Intrinsics.sanitizeStackTrace(new NullPointerException(string));
    }

    public static void throwUninitializedProperty(String string) {
        throw (UninitializedPropertyAccessException)Intrinsics.sanitizeStackTrace(new UninitializedPropertyAccessException(string));
    }

    public static void throwUninitializedPropertyAccessException(String string) {
        Intrinsics.throwUninitializedProperty("lateinit property " + string + " has not been initialized");
    }

    public static void checkNotNullExpressionValue(Object object, String string) {
        if (object != null) {
            return;
        }
        throw (NullPointerException)Intrinsics.sanitizeStackTrace(new NullPointerException(string + " must not be null"));
    }

    public static void checkNotNullParameter(Object object, String string) {
        if (object == null) {
            Intrinsics.throwParameterIsNullNPE(string);
        }
    }

    public static void throwParameterIsNullNPE(String string) {
        throw (NullPointerException)Intrinsics.sanitizeStackTrace(new NullPointerException(Intrinsics.createParameterIsNullExceptionMessage(string)));
    }

    public static String createParameterIsNullExceptionMessage(String string) {
        Object object = Thread.currentThread().getStackTrace();
        String string2 = Intrinsics.class.getName();
        int n = 0;
        while (!object[n].getClassName().equals(string2)) {
            ++n;
        }
        while (object[n].getClassName().equals(string2)) {
            ++n;
        }
        StackTraceElement stackTraceElement = object[n];
        object = stackTraceElement.getClassName();
        return "Parameter specified as non-null is null: method " + (String)object + "." + stackTraceElement.getMethodName() + ", parameter " + string;
    }

    public static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static boolean areEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static Throwable sanitizeStackTrace(Throwable throwable) {
        return Intrinsics.sanitizeStackTrace(throwable, Intrinsics.class.getName());
    }

    public static Throwable sanitizeStackTrace(Throwable throwable, String string) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(stackTraceElementArray[i].getClassName())) continue;
            n2 = i;
        }
        Throwable throwable2 = throwable;
        throwable2.setStackTrace(Arrays.copyOfRange(stackTraceElementArray, n2 + 1, n));
        return throwable2;
    }

    public static abstract class Kotlin {
    }
}

