/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.common.event;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.touchcontroller.common.config.ControllerLayout;
import top.fifthlight.touchcontroller.common.config.GlobalConfig;
import top.fifthlight.touchcontroller.common.config.GlobalConfigHolder;
import top.fifthlight.touchcontroller.common.config.LayerConditionKey;
import top.fifthlight.touchcontroller.common.config.preset.LayoutPreset;
import top.fifthlight.touchcontroller.common.config.preset.PresetControlInfo;
import top.fifthlight.touchcontroller.common.event.RenderEvents$special$;
import top.fifthlight.touchcontroller.common.event.WindowEvents;
import top.fifthlight.touchcontroller.common.gal.CameraPerspective;
import top.fifthlight.touchcontroller.common.gal.CrosshairTarget;
import top.fifthlight.touchcontroller.common.gal.DefaultKeyBindingType;
import top.fifthlight.touchcontroller.common.gal.GameState;
import top.fifthlight.touchcontroller.common.gal.GameStateProvider;
import top.fifthlight.touchcontroller.common.gal.KeyBindingHandler;
import top.fifthlight.touchcontroller.common.gal.PlayerHandle;
import top.fifthlight.touchcontroller.common.gal.PlayerHandleFactory;
import top.fifthlight.touchcontroller.common.gal.RidingEntityType;
import top.fifthlight.touchcontroller.common.gal.ViewActionProvider;
import top.fifthlight.touchcontroller.common.gal.WindowHandle;
import top.fifthlight.touchcontroller.common.layout.Context;
import top.fifthlight.touchcontroller.common.layout.ContextInput;
import top.fifthlight.touchcontroller.common.layout.ContextResult;
import top.fifthlight.touchcontroller.common.layout.ContextStatus;
import top.fifthlight.touchcontroller.common.layout.ContextTimer;
import top.fifthlight.touchcontroller.common.layout.DrawQueue;
import top.fifthlight.touchcontroller.common.layout.HudKt;
import top.fifthlight.touchcontroller.common.layout.InventorySlotStatus;
import top.fifthlight.touchcontroller.common.model.ControllerHudModel;
import top.fifthlight.touchcontroller.common.model.TouchStateModel;
import top.fifthlight.touchcontroller.common.platform.PlatformProvider;
import top.fifthlight.touchcontroller.proxy.message.AddPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.CapabilityMessage;
import top.fifthlight.touchcontroller.proxy.message.ClearPointerMessage;
import top.fifthlight.touchcontroller.proxy.message.RemovePointerMessage;
import top.fifthlight.touchcontroller.proxy.message.VibrateMessage;
import top.fifthlight.touchcontroller.relocated.kotlin.Lazy;
import top.fifthlight.touchcontroller.relocated.kotlin.LazyKt__LazyJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.collections.MapsKt__MapsJVMKt;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function0;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.functions.Function2;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.DefaultConstructorMarker;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Intrinsics;
import top.fifthlight.touchcontroller.relocated.kotlin.jvm.internal.Reflection;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.ExtensionsKt;
import top.fifthlight.touchcontroller.relocated.kotlinx.collections.immutable.PersistentMap;
import top.fifthlight.touchcontroller.relocated.org.koin.core.Koin;
import top.fifthlight.touchcontroller.relocated.org.koin.core.component.KoinComponent;
import top.fifthlight.touchcontroller.relocated.org.koin.core.qualifier.Qualifier;
import top.fifthlight.touchcontroller.relocated.org.koin.mp.KoinPlatformTools;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.combine.paint.Canvas;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntOffset;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.IntSize;
import top.fifthlight.touchcontroller.relocated.top.fifthlight.data.Offset;

public final class RenderEvents
implements KoinComponent {
    public static final RenderEvents INSTANCE;
    public static final Logger logger;
    public static final Lazy window$delegate;
    public static final Lazy configHolder$delegate;
    public static final Lazy controllerHudModel$delegate;
    public static final Lazy touchStateModel$delegate;
    public static final Lazy playerHandleFactory$delegate;
    public static final Lazy platformProvider$delegate;
    public static final Lazy gameStateProvider$delegate;
    public static final Lazy keyBindingHandler$delegate;
    public static final Lazy viewActionProvider$delegate;
    public static int prevWidth;
    public static int prevHeight;
    public static final PlatformCapabilities platformCapabilities;
    public static final int $stable;

    private final PlatformProvider getPlatformProvider() {
        return (PlatformProvider)platformProvider$delegate.getValue();
    }

    private final KeyBindingHandler getKeyBindingHandler() {
        return (KeyBindingHandler)keyBindingHandler$delegate.getValue();
    }

    public static final void onRenderStart() {
        ContextInput contextInput;
        DrawQueue drawQueue;
        Object object;
        Object object2;
        Object object3 = INSTANCE;
        ((RenderEvents)object3).getControllerHudModel().getTimer().renderTick();
        ((RenderEvents)object3).getKeyBindingHandler().renderTick(((RenderEvents)object3).getControllerHudModel().getTimer().getRenderTick());
        if (((RenderEvents)object3).getControllerHudModel().getStatus().getVibrate()) {
            object2 = ((RenderEvents)object3).getPlatformProvider().getPlatform();
            if (object2 != null) {
                object2.sendEvent(new VibrateMessage(VibrateMessage.Kind.BLOCK_BROKEN));
            }
            ((RenderEvents)object3).getControllerHudModel().getStatus().setVibrate(false);
        }
        RenderEvents renderEvents = object3;
        object3 = renderEvents.getGameStateProvider().currentState();
        object2 = renderEvents.getPlatformProvider().getPlatform();
        if (object2 != null) {
            while (true) {
                WindowEvents windowEvents = WindowEvents.INSTANCE;
                int n = windowEvents.getWindowWidth$common();
                int n2 = windowEvents.getWindowHeight$common();
                if (n != prevWidth || n2 != prevHeight) {
                    prevWidth = n;
                    prevHeight = n2;
                    object2.resize(n, n2);
                }
                if ((object = object2.pollEvent()) == null) break;
                if (object instanceof AddPointerMessage) {
                    AddPointerMessage addPointerMessage = (AddPointerMessage)object;
                    int n3 = addPointerMessage.getIndex();
                    float f = addPointerMessage.getX();
                    float f2 = addPointerMessage.getY();
                    long l = Float.floatToRawIntBits(f2);
                    INSTANCE.getTouchStateModel().addPointer-_0sKWyo(n3, Offset.constructor-impl((long)Float.floatToRawIntBits(f) << 32 | l & 0xFFFFFFFFL));
                    continue;
                }
                if (object instanceof RemovePointerMessage) {
                    INSTANCE.getTouchStateModel().removePointer(((RemovePointerMessage)object).getIndex());
                    continue;
                }
                if (Intrinsics.areEqual(object, ClearPointerMessage.INSTANCE)) {
                    INSTANCE.getTouchStateModel().clearPointer();
                    continue;
                }
                if (!(object instanceof CapabilityMessage)) continue;
                String string = ((CapabilityMessage)(object = (CapabilityMessage)object)).getCapability();
                if (Intrinsics.areEqual(string, "text_status")) {
                    platformCapabilities.setTextStatus(true);
                    continue;
                }
                if (Intrinsics.areEqual(string, "keyboard_show")) {
                    platformCapabilities.setKeyboardShow(true);
                    continue;
                }
                logger.warn("Unknown capability: " + ((CapabilityMessage)object).getCapability());
            }
        }
        if (((GlobalConfig)((RenderEvents)(object2 = INSTANCE)).getConfigHolder().getConfig().getValue()).getDebug().getEnableTouchEmulation()) {
            object = ((RenderEvents)object2).getWindow().getMousePosition-sHUuaow();
            if (((RenderEvents)object2).getWindow().getMouseLeftPressed() && object != null) {
                long l = Offset.div-JopVrvY(((Offset)object).unbox-impl(), IntSize.toSize-2DEOzdI(((RenderEvents)object2).getWindow().getSize-KlICH20()));
                ((RenderEvents)object2).getTouchStateModel().addPointer-_0sKWyo(0, l);
            } else {
                ((RenderEvents)object2).getTouchStateModel().clearPointer();
            }
        }
        if (!((GameState)object3).getInGame()) {
            return;
        }
        PlayerHandle playerHandle = ((RenderEvents)object2).getPlayerHandleFactory().getPlayerHandle();
        if (playerHandle == null) {
            return;
        }
        if (playerHandle.isFlying() || playerHandle.isSubmergedInWater()) {
            super.getKeyBindingHandler().getState(DefaultKeyBindingType.SNEAK).clearLock();
        }
        Object object4 = playerHandle.getRidingEntityType();
        Object object5 = MapsKt__MapsJVMKt.createMapBuilder();
        object5.put(LayerConditionKey.FLYING, playerHandle.isFlying());
        object5.put(LayerConditionKey.CAN_FLY, playerHandle.getCanFly());
        object5.put(LayerConditionKey.SWIMMING, playerHandle.isTouchingWater());
        object5.put(LayerConditionKey.UNDERWATER, playerHandle.isSubmergedInWater());
        object5.put(LayerConditionKey.SPRINTING, playerHandle.isSprinting());
        object5.put(LayerConditionKey.SNEAKING, playerHandle.isSneaking());
        object5.put(LayerConditionKey.ON_GROUND, playerHandle.getOnGround());
        object5.put(LayerConditionKey.NOT_ON_GROUND, playerHandle.getOnGround() ^ true);
        object5.put(LayerConditionKey.USING_ITEM, playerHandle.isUsingItem());
        Object object6 = LayerConditionKey.RIDING;
        Boolean bl = object4 != null;
        object5.put(object6, bl);
        object6 = LayerConditionKey.BLOCK_SELECTED;
        bl = ((RenderEvents)object2).getViewActionProvider().getCrosshairTarget() == CrosshairTarget.BLOCK;
        object5.put(object6, bl);
        object6 = LayerConditionKey.ON_MINECART;
        bl = object4 == RidingEntityType.MINECART;
        object5.put(object6, bl);
        object6 = LayerConditionKey.ON_BOAT;
        bl = object4 == RidingEntityType.BOAT;
        object5.put(object6, bl);
        object6 = LayerConditionKey.ON_PIG;
        bl = object4 == RidingEntityType.PIG;
        object5.put(object6, bl);
        object6 = LayerConditionKey.ON_HORSE;
        bl = object4 == RidingEntityType.HORSE;
        object5.put(object6, bl);
        object6 = LayerConditionKey.ON_CAMEL;
        bl = object4 == RidingEntityType.CAMEL;
        object5.put(object6, bl);
        object6 = LayerConditionKey.ON_LLAMA;
        bl = object4 == RidingEntityType.LLAMA;
        RidingEntityType ridingEntityType = object4;
        object5.put(object6, bl);
        object4 = LayerConditionKey.ON_STRIDER;
        object6 = ridingEntityType == RidingEntityType.STRIDER;
        Map map2 = object5;
        map2.put(object4, object6);
        object4 = ExtensionsKt.toPersistentMap(MapsKt__MapsJVMKt.build(map2));
        object5 = (LayoutPreset)((RenderEvents)object2).getConfigHolder().getCurrentPreset().getValue();
        object6 = drawQueue;
        drawQueue = new DrawQueue();
        long l = ((RenderEvents)object2).getWindow().getSize-KlICH20();
        long l2 = ((RenderEvents)object2).getWindow().getScaledSize-KlICH20();
        long l3 = ((RenderEvents)object2).getWindow().getScaledSize-KlICH20();
        long l4 = IntOffset.Companion.getZERO-ITD3_cg();
        HashMap hashMap = ((RenderEvents)object2).getTouchStateModel().getPointers();
        ContextInput contextInput2 = contextInput;
        Object object7 = object3;
        boolean bl2 = ((GameState)object7).getInGui();
        Object object8 = ((GameState)object7).getPerspective();
        contextInput = new ContextInput(bl2, (PersistentMap)object4, (CameraPerspective)((Object)object8));
        InventorySlotStatus[] inventorySlotStatusArray = ((RenderEvents)object2).getControllerHudModel().getStatus();
        object4 = ((RenderEvents)object2).getControllerHudModel().getTimer();
        object8 = super.getKeyBindingHandler();
        GlobalConfig globalConfig = (GlobalConfig)((RenderEvents)object2).getConfigHolder().getConfig().getValue();
        PresetControlInfo presetControlInfo = ((LayoutPreset)object5).getControlInfo();
        Context context = new Context(l, l2, (DrawQueue)object6, l3, l4, 0.0f, hashMap, contextInput2, null, (ContextStatus)inventorySlotStatusArray, (KeyBindingHandler)object8, (ContextTimer)object4, globalConfig, presetControlInfo, 288, null);
        HudKt.Hud(context, ControllerLayout.box-impl(((LayoutPreset)object5).getLayout-HWbCNyc()));
        inventorySlotStatusArray = context.getResult();
        ((RenderEvents)object2).getControllerHudModel().setResult((ContextResult)inventorySlotStatusArray);
        ((RenderEvents)object2).getControllerHudModel().setPendingDrawQueue((DrawQueue)object6);
        ((RenderEvents)object2).getControllerHudModel().getStatus().getDoubleClickCounter().clean(((RenderEvents)object2).getControllerHudModel().getTimer().getClientTick());
        object2 = inventorySlotStatusArray.getPendingAction().iterator();
        while (object2.hasNext()) {
            ((Function2)object2.next()).invoke(INSTANCE.getControllerHudModel().getTimer(), playerHandle);
        }
        object2 = inventorySlotStatusArray.getLookDirection-sHUuaow();
        if (object2 != null) {
            long l5 = ((Offset)object2).unbox-impl();
            float f = Offset.component1-impl(l5);
            double d = f;
            double d2 = Offset.component2-impl(l5);
            playerHandle.changeLookDirection(d, d2);
        }
        inventorySlotStatusArray = inventorySlotStatusArray.getInventory().getSlots();
        int n = 0;
        for (InventorySlotStatus inventorySlotStatus : inventorySlotStatusArray) {
            int n4 = n + 1;
            if (inventorySlotStatus.getSelect()) {
                playerHandle.setCurrentSelectedSlot(n);
            }
            if (inventorySlotStatus.getDrop()) {
                if (playerHandle.getInventorySlot(n).isEmpty()) {
                    playerHandle.setCurrentSelectedSlot(n);
                } else {
                    playerHandle.dropSlot(n);
                }
            }
            n = n4;
        }
    }

    static {
        RenderEvents renderEvents;
        RenderEvents renderEvents2 = renderEvents;
        INSTANCE = new RenderEvents();
        logger = LoggerFactory.getLogger(RenderEvents.class);
        KoinPlatformTools koinPlatformTools = KoinPlatformTools.INSTANCE;
        window$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$1 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(WindowHandle.class), qualifier, function0);
            }
        });
        configHolder$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$2 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GlobalConfigHolder.class), qualifier, function0);
            }
        });
        controllerHudModel$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$3 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ControllerHudModel.class), qualifier, function0);
            }
        });
        touchStateModel$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$4 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(TouchStateModel.class), qualifier, function0);
            }
        });
        playerHandleFactory$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$5 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PlayerHandleFactory.class), qualifier, function0);
            }
        });
        platformProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$6 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(PlatformProvider.class), qualifier, function0);
            }
        });
        gameStateProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$7 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(GameStateProvider.class), qualifier, function0);
            }
        });
        keyBindingHandler$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$8 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(KeyBindingHandler.class), qualifier, function0);
            }
        });
        viewActionProvider$delegate = LazyKt__LazyJVMKt.lazy(koinPlatformTools.defaultLazyMode(), new Function0(renderEvents2, null, null){
            public final /* synthetic */ KoinComponent $this_inject;
            public final /* synthetic */ Qualifier $qualifier;
            public final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = koinComponent;
                this.$qualifier = qualifier;
                this.$parameters = function0;
            }

            public final Object invoke() {
                special$$inlined$inject$default$9 v0 = koinComponent;
                KoinComponent koinComponent = v0.$this_inject;
                Qualifier qualifier = v0.$qualifier;
                Function0 function0 = v0.$parameters;
                return koinComponent.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ViewActionProvider.class), qualifier, function0);
            }
        });
        platformCapabilities = new PlatformCapabilities(false, false, 3, null);
        $stable = 8;
    }

    public final PlatformCapabilities getPlatformCapabilities() {
        return platformCapabilities;
    }

    public final void onHudRender(Canvas canvas) {
        Intrinsics.checkNotNullParameter(canvas, "canvas");
        DrawQueue drawQueue = ((RenderEvents)((Object)drawQueue)).getControllerHudModel().getPendingDrawQueue();
        if (drawQueue != null) {
            drawQueue.execute(canvas);
            INSTANCE.getControllerHudModel().setPendingDrawQueue(null);
        }
    }

    public final boolean shouldRenderCrosshair() {
        GlobalConfig globalConfig = (GlobalConfig)((RenderEvents)this).getConfigHolder().getConfig().getValue();
        if (!globalConfig.getRegular().getDisableCrosshair()) {
            return true;
        }
        if ((this = ((RenderEvents)this).getPlayerHandleFactory().getPlayerHandle()) == null) {
            return false;
        }
        return this.hasItemsOnHand(globalConfig.getItem().getShowCrosshairItems());
    }

    @Override
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    public final WindowHandle getWindow() {
        return (WindowHandle)window$delegate.getValue();
    }

    public final GlobalConfigHolder getConfigHolder() {
        return (GlobalConfigHolder)configHolder$delegate.getValue();
    }

    public final ControllerHudModel getControllerHudModel() {
        return (ControllerHudModel)controllerHudModel$delegate.getValue();
    }

    public final TouchStateModel getTouchStateModel() {
        return (TouchStateModel)touchStateModel$delegate.getValue();
    }

    public final PlayerHandleFactory getPlayerHandleFactory() {
        return (PlayerHandleFactory)playerHandleFactory$delegate.getValue();
    }

    public final GameStateProvider getGameStateProvider() {
        return (GameStateProvider)gameStateProvider$delegate.getValue();
    }

    public final ViewActionProvider getViewActionProvider() {
        return (ViewActionProvider)viewActionProvider$delegate.getValue();
    }

    public static final class PlatformCapabilities {
        public boolean textStatus;
        public boolean keyboardShow;

        public PlatformCapabilities(boolean bl, boolean bl2) {
            this.textStatus = bl;
            this.keyboardShow = bl2;
        }

        public /* synthetic */ PlatformCapabilities(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final void setTextStatus(boolean bl) {
            this.textStatus = bl;
        }

        public final boolean getKeyboardShow() {
            return this.keyboardShow;
        }

        public final void setKeyboardShow(boolean bl) {
            this.keyboardShow = bl;
        }

        public String toString() {
            return "PlatformCapabilities(textStatus=" + this.textStatus + ", keyboardShow=" + this.keyboardShow + ')';
        }

        public int hashCode() {
            return Boolean.hashCode(this.textStatus) * 31 + Boolean.hashCode(this.keyboardShow);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PlatformCapabilities)) {
                return false;
            }
            object = (PlatformCapabilities)object;
            if (this.textStatus != ((PlatformCapabilities)object).textStatus) {
                return false;
            }
            return this.keyboardShow == ((PlatformCapabilities)object).keyboardShow;
        }
    }
}

