/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.touchcontroller.mixin;

import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import top.fifthlight.touchcontroller.common.helper.CrosshairTargetHelper;

@Mixin(value={GameRenderer.class})
public abstract class CrosshairTargetMixin {
    @Unique
    private static Vec3 touchController$currentDirection;
    @Shadow
    @Final
    private Camera mainCamera;

    @Redirect(method={"pick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;pick(DFZ)Lnet/minecraft/world/phys/HitResult;", ordinal=0))
    private HitResult cameraRaycast(Entity entity, double d, float f, boolean bl) {
        CrosshairTargetMixin crosshairTargetMixin = crosshairTargetMixin2;
        double d2 = crosshairTargetMixin.getFov(crosshairTargetMixin.mainCamera, f, true);
        double d3 = Math.toRadians(entity.getViewXRot(f));
        double d4 = Math.toRadians(entity.getViewYRot(f));
        Vec3 vec3 = entity.getEyePosition(f);
        CrosshairTargetMixin crosshairTargetMixin2 = CrosshairTargetHelper.getCrosshairDirection(crosshairTargetMixin2.getProjectionMatrix(d2), d3, d4);
        CrosshairTargetHelper.INSTANCE.setLastCrosshairDirection((Vector3d)crosshairTargetMixin2);
        CrosshairTargetMixin crosshairTargetMixin3 = crosshairTargetMixin2;
        d2 = ((Vector3d)crosshairTargetMixin3).x;
        d3 = ((Vector3d)crosshairTargetMixin3).y;
        d4 = ((Vector3d)crosshairTargetMixin3).z;
        touchController$currentDirection = new Vec3(d2, d3, d4);
        double d5 = ((Vector3d)crosshairTargetMixin2).x * d;
        CrosshairTargetMixin crosshairTargetMixin4 = crosshairTargetMixin2;
        d2 = ((Vector3d)crosshairTargetMixin4).y * d;
        d = ((Vector3d)crosshairTargetMixin4).z * d;
        crosshairTargetMixin2 = vec3.add(d5, d2, d);
        ClipContext.Fluid fluid = bl ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE;
        return entity.level().clip(new ClipContext(vec3, (Vec3)crosshairTargetMixin2, ClipContext.Block.OUTLINE, fluid, entity));
    }

    @Redirect(method={"pick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;", ordinal=0))
    private Vec3 getRotationVec(Entity entity, float f) {
        return touchController$currentDirection;
    }

    @Shadow
    public abstract Matrix4f getProjectionMatrix(double var1);

    @Shadow
    public abstract double getFov(Camera var1, float var2, boolean var3);
}

