#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;

out vec4 fragColor;

void main() {
    // vec3 glintColor = vec3(255, 143, 255) / 255.0; // actions & stuff glint color
    vec3 glintColor = vec3(234, 225, 224) / 255.0;

    vec4 textureColor = texture(Sampler0, texCoord0);
    vec4 color = textureColor * vertexColor * ColorModulator;
    float textureAlpha = texture(Sampler0, texCoord0).a * 255;

    vec4 finalColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);

    if (color.a < 0.1) {
        discard;
    }

    if(textureAlpha == 128){
        finalColor = vec4(glintColor, 0.7);
    }
    
    fragColor = finalColor;
}

