#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>

uniform sampler2D Sampler0;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord1;

out vec4 fragColor;

void main() {
    vec3 glintColor = vec3(244, 38, 15) / 255.0;

    vec4 textureColor = texture(Sampler0, texCoord0);
    vec4 color = textureColor * vertexColor * ColorModulator;
    float textureAlpha = texture(Sampler0, texCoord0).a * 255;

    float dist = vertexDistance;
    float fogFactor = max(
      clamp((dist - FogRenderDistanceStart) / (FogRenderDistanceEnd - FogRenderDistanceStart), 0.0, 1.0),
      clamp((dist - FogEnvironmentalStart) / (FogEnvironmentalEnd - FogEnvironmentalStart), 0.0, 1.0)
    );
    vec4 finalColor = mix(color, FogColor, fogFactor);

    if (color.a < 0.1) {
        discard;
    }

    if(textureAlpha == 128){
        finalColor = vec4(glintColor, 0.4);
    }
    
    fragColor = finalColor;
}
